/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ScatteredCollectionIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="parsed-report-by-path", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={ExternalAnalysisImportInfo.class})
public class ReportResultByCodePathIndex
implements IProjectIndex {
    private final ScatteredCollectionIndex<ExternalAnalysisImportInfo<?>> delegate;

    public ReportResultByCodePathIndex(IStore store) {
        this.delegate = ScatteredCollectionIndex.forSerializable((IStore)store, (int)10);
    }

    public void removeAnalysisResults(List<String> uniformPaths) throws StorageException {
        for (String uniformPath : uniformPaths) {
            this.delegate.remove(StringUtils.stringToBytes((String)uniformPath));
        }
    }

    public void setAnalysisResults(PairList<String, ExternalAnalysisImportInfos> uniformPathsAndAnalysisInfos) throws StorageException {
        for (Pair uniformPathsAndAnalysisInfo : uniformPathsAndAnalysisInfos) {
            this.delegate.put(StringUtils.stringToBytes((String)((String)uniformPathsAndAnalysisInfo.getFirst())), ((ExternalAnalysisImportInfos)uniformPathsAndAnalysisInfo.getSecond()).getInfos());
        }
    }

    public @Nullable ExternalAnalysisImportInfos getAnalysisResult(String uniformPath) throws StorageException {
        return this.delegate.get(StringUtils.stringToBytes((String)uniformPath)).map(ExternalAnalysisImportInfos::new).orElse(null);
    }

    public List<@Nullable ExternalAnalysisImportInfos> getAnalysisResults(List<String> uniformPaths) throws StorageException {
        return (List)IStreamWithException.wrap(uniformPaths.stream(), StorageException.class).map(this::getAnalysisResult).collect(Collectors.toList());
    }
}

