/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.index.configuration.tools.ModelAdvisorConfiguration;
import com.teamscale.index.dependencies.ITypeIndex;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class ModelAdvisorReportParser
extends FindingCollectingReportParserBase {
    private static final String USE_SID_PREFIX = "USE_SID:";
    private static final String MODEL_LINK_INDICATOR = "hilite";
    private static final String MODEL_ADVISOR_CLASS_FAILED_CHECK = "FailedCheck";
    private static final String MODEL_ADVISOR_CLASS_WARNING_CHECK = "WarningCheck";
    private static final String MODEL_ADVISOR_CLASS_CHECK_HEADING = "CheckHeading";
    private static final String MODEL_ADVISOR_ID_PREFIX_HEADING = "Heading_";
    private static final String MODEL_ADVISOR_UNDERSCORE_IN_PATH_REPLACEMENT = "zs";
    private static final String MODEL_ADVISOR_SLASH_IN_PATH_REPLACEMENT = "zf";
    private static final String MODEL_ADVISOR_NEWLINE_IN_PATH_REPLACEMENT = "zr";
    private static final String MATLAB_MODELADVISORPRIVATE_HILITE_LINE = "matlab: modeladvisorprivate hiliteLine";
    private static final Pattern MATLAB_HILITE_SYSTEM_PATTERN = Pattern.compile("matlab: *hilite_system\\('?(.*?)'?\\)");
    private static final Pattern MATLAB_HILITE_SYSTEM_CHAR_PATTERN = Pattern.compile("char\\(\\[(.*?)]\\)");
    private static final Pattern ONLY_UNDERSCORES = Pattern.compile("_+");
    private final Collection<CheckMapping> knownChecks = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)Resource.of(ModelAdvisorConfiguration.class, (String)"/com/teamscale/index/configuration/tools/model-advisor/check-mappings.tsv")).values();
    private final CheckMapping unsupportedCheck = this.knownChecks.stream().filter(c -> c.checkId.equals("cqse.modeladvisor.teamscale_unsupported_model_advisor_check")).findFirst().get();
    private final CheckMapping abortedCheck = this.knownChecks.stream().filter(c -> c.checkId.equals("cqse.modeladvisor.teamscale_abnormal_exit_in_model_advisor_check")).findFirst().get();
    private static final Map<String, String> MODEL_ADVISOR_CHECK_ID_MIGRATIONS = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)".jc_0009", (Object)".na_0009"), Pair.createPair((Object)".jm_0010", (Object)"jc_0602")});
    private QualifiedNameLocation defaultLocation = null;
    private final List<ModelAdvisorFinding> findings = new ArrayList<ModelAdvisorFinding>();
    private final List<ModelAdvisorFinding> unsupportedCheckFindings = new ArrayList<ModelAdvisorFinding>();
    private static final String ABNORMAL_EXIT_MESSAGE_START = "Abnormal exit:";
    private LazyModelLoader simulinkModelLoader;
    private static final String RECOMMENDED_ACTION_TAG = "\nRecommended Action\n";

    @Override
    public void init(TokenElementIndexCache tokenElementCache, TokenElementLineInfoIndex tokenElementLineInfoIndex, BinaryElementIndex binaryElementIndex, IMatchingPathsLookup matchingPathsLookup, ITypeIndex typeIndex, ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex, String connectorId, MetaIndex projectMetaIndex, boolean disablePlausibilityCheckForPathMapping, ExecuteInParallelBatchesFunction parallelExecutor, String repository) {
        super.init(tokenElementCache, tokenElementLineInfoIndex, binaryElementIndex, matchingPathsLookup, typeIndex, externalFindingsGroupDescriptionIndex, connectorId, projectMetaIndex, disablePlausibilityCheckForPathMapping, parallelExecutor, repository);
        this.simulinkModelLoader = new LazyModelLoader(binaryElementIndex);
    }

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) {
        Document htmlDocument = Jsoup.parse((String)report);
        this.defaultLocation = this.extractDefaultLocation(htmlDocument);
        Elements divElements = htmlDocument.getElementsByTag(EHTMLElement.DIV.getName());
        for (Element divElement : divElements) {
            String classValue = divElement.className();
            if (MODEL_ADVISOR_CLASS_FAILED_CHECK.equals(classValue)) {
                this.parseCheck(divElement, true);
                continue;
            }
            if (!MODEL_ADVISOR_CLASS_WARNING_CHECK.equals(classValue)) continue;
            this.parseCheck(divElement, false);
        }
    }

    private QualifiedNameLocation extractDefaultLocation(Document htmlDocument) {
        String modelName;
        String uniformPath;
        String title;
        int indexOfQuotation;
        Elements titleElements = htmlDocument.getElementsByTag(EHTMLElement.TITLE.getName());
        if (!titleElements.isEmpty() && (indexOfQuotation = (title = ((Element)titleElements.get(0)).text()).indexOf(39)) > 0 && (uniformPath = this.findUniformPathForModelPath(modelName = title.substring(indexOfQuotation + 1, title.lastIndexOf(39)))) != null) {
            return new QualifiedNameLocation("", uniformPath);
        }
        LOGGER.warn("Unable to extract the default location for findings based on the <title> tag of the HTML report. Finding collection may be incomplete.");
        return null;
    }

    private void parseCheck(Element divElement, boolean checkIsFailed) {
        if (checkIsFailed) {
            if (this.checkForAbnormalExitAndAddFinding(divElement)) {
                return;
            }
            this.parseFailedModelAdvisorFindingsFromTable(divElement);
        } else {
            this.parseModelAdvisorFindingsFromLinks(divElement);
        }
    }

    private void parseFailedModelAdvisorFindingsFromTable(Element divElement) {
        String checkId = ModelAdvisorReportParser.parseCheckId(divElement);
        CheckMapping check = this.determineCheckMappingForModelAdvisorId(checkId);
        Elements tableElements = divElement.getElementsByTag(EHTMLElement.TABLE.getName());
        if (tableElements.isEmpty()) {
            if (this.isUnsupportedCheck(check)) {
                LOGGER.error("No locations found for unsupported check '{}'", (Object)checkId);
            } else {
                LOGGER.error("No locations found for check '{}'", (Object)check.checkId);
            }
            return;
        }
        if (tableElements.size() > 1) {
            LOGGER.error("Expected exactly one <table> element but found {}", (Object)tableElements.size());
            return;
        }
        ETrafficLightColor findingColor = ETrafficLightColor.YELLOW;
        if (divElement.className().contains(MODEL_ADVISOR_CLASS_FAILED_CHECK)) {
            findingColor = ETrafficLightColor.RED;
        }
        String recommendedAction = ModelAdvisorReportParser.getFollowingRecommendedAction((Element)tableElements.get(0), divElement);
        Elements trElements = ((Element)tableElements.get(0)).getElementsByTag(EHTMLElement.TR.getName());
        for (Element trElement : trElements) {
            this.parseFailedModelAdvisorFindingsFromTableRow(trElement, check, findingColor, recommendedAction);
        }
    }

    private boolean isUnsupportedCheck(CheckMapping check) {
        return check.checkId.equals(this.unsupportedCheck.checkId);
    }

    private static boolean isSupportedFinding(ModelAdvisorFinding finding) {
        return !finding.matlabReference.startsWith(MATLAB_MODELADVISORPRIVATE_HILITE_LINE);
    }

    private boolean checkForAbnormalExitAndAddFinding(Element divElement) {
        String checkId = ModelAdvisorReportParser.parseCheckId(divElement);
        String checkName = ModelAdvisorReportParser.parseCheckName(divElement);
        String findingMessage = String.format("Abnormal termination of model-advisor check %s (%s)", MarkupUtils.formatAsSourceCode((String)checkId), MarkupUtils.formatAsSourceCode((String)checkName));
        if (divElement.text().contains("Error occurred during model compile.")) {
            ModelAdvisorFinding finding = new ModelAdvisorFinding(this.abortedCheck, "", findingMessage, ETrafficLightColor.YELLOW, null);
            if (ModelAdvisorReportParser.isSupportedFinding(finding)) {
                this.findings.add(finding);
            }
            return true;
        }
        Elements paragraphs = divElement.getElementsByTag(EHTMLElement.P.getName());
        for (Element paragraph : paragraphs) {
            String text = paragraph.text().trim();
            if (!text.startsWith(ABNORMAL_EXIT_MESSAGE_START)) continue;
            ModelAdvisorFinding finding = new ModelAdvisorFinding(this.abortedCheck, "", findingMessage, ETrafficLightColor.YELLOW, null);
            if (ModelAdvisorReportParser.isSupportedFinding(finding)) {
                this.findings.add(finding);
            }
            return true;
        }
        return false;
    }

    private void parseFailedModelAdvisorFindingsFromTableRow(Element trElement, CheckMapping check, ETrafficLightColor findingColor, String recommendedAction) {
        CCSMAssert.isTrue((boolean)EHTMLElement.TR.getName().equalsIgnoreCase(trElement.tagName()), (String)("The passed element was no <tr> element (was " + trElement.tagName() + ")"));
        Elements tdElements = trElement.getElementsByTag(EHTMLElement.TD.getName());
        if (tdElements.isEmpty()) {
            return;
        }
        if (tdElements.size() != 2) {
            LOGGER.error("Found a table with {} columns, but expected 2", (Object)tdElements.size());
            return;
        }
        Elements aElement = ((Element)tdElements.get(0)).getElementsByTag(EHTMLElement.A.getName());
        if (aElement == null || aElement.isEmpty()) {
            LOGGER.error("The location of the model item is not linked");
        } else {
            ModelAdvisorFinding finding = new ModelAdvisorFinding(check, ((Element)aElement.get(0)).attr(EHTMLAttribute.HREF.getName()), ((Element)tdElements.get(1)).wholeText(), findingColor, recommendedAction);
            if (this.isUnsupportedCheck(check)) {
                this.unsupportedCheckFindings.add(finding);
            } else if (ModelAdvisorReportParser.isSupportedFinding(finding)) {
                this.findings.add(finding);
            }
        }
    }

    private void parseModelAdvisorFindingsFromLinks(Element divElement) {
        String checkId = ModelAdvisorReportParser.parseCheckId(divElement);
        CheckMapping check = this.determineCheckMappingForModelAdvisorId(checkId);
        String message = this.getMessage(divElement, check, checkId);
        Elements aElements = ModelAdvisorReportParser.getAElements(divElement);
        boolean specificLocationFound = this.createFindingsFromAElements(divElement, aElements, message, check);
        if (!specificLocationFound) {
            String recommendedAction = ModelAdvisorReportParser.getFollowingRecommendedAction(divElement, null);
            ModelAdvisorFinding finding = new ModelAdvisorFinding(check, "", message, ETrafficLightColor.YELLOW, recommendedAction);
            if (this.isUnsupportedCheck(check)) {
                this.unsupportedCheckFindings.add(finding);
            } else if (ModelAdvisorReportParser.isSupportedFinding(finding)) {
                this.findings.add(finding);
            }
        }
    }

    private static @NonNull Elements getAElements(Element divElement) {
        Elements aElements = divElement.getElementsByTag(EHTMLElement.A.getName());
        aElements.removeAll(divElement.getElementsByTag(EHTMLElement.TABLE.getName()).stream().filter(table -> table.getElementsContainingText("Exclusion").stream().anyMatch(element -> !element.tagName().equals(EHTMLElement.A.getName()))).flatMap(tables -> tables.getElementsByTag(EHTMLElement.A.getName()).stream()).toList());
        return aElements;
    }

    private String getMessage(Element divElement, CheckMapping check, String checkId) {
        Object message = check.getReadableCheckName();
        if (this.isUnsupportedCheck(check)) {
            String checkName = ModelAdvisorReportParser.parseCheckName(divElement);
            message = "Check " + MarkupUtils.formatAsSourceCode((String)checkId) + "(" + MarkupUtils.formatAsSourceCode((String)checkName) + ") is not supported by Teamscale's model-advisor report parser.";
        }
        return message;
    }

    private boolean createFindingsFromAElements(Element divElement, Elements aElements, String message, CheckMapping check) {
        boolean specificLocationFound = false;
        for (Element aElement : aElements) {
            String href = aElement.attr(EHTMLAttribute.HREF.getName());
            if (!href.contains(MODEL_LINK_INDICATOR)) continue;
            this.createFindingFromAElement(aElement, divElement, message, check);
            specificLocationFound = true;
        }
        return specificLocationFound;
    }

    private void createFindingFromAElement(Element aElement, Element topElement, String message, CheckMapping check) {
        String href = aElement.attr(EHTMLAttribute.HREF.getName());
        String recommendedAction = ModelAdvisorReportParser.getFollowingRecommendedAction(aElement, topElement);
        ModelAdvisorFinding modelAdvisorFinding = new ModelAdvisorFinding(check, href, message, ETrafficLightColor.YELLOW, recommendedAction);
        if (this.isUnsupportedCheck(check)) {
            this.unsupportedCheckFindings.add(modelAdvisorFinding);
        } else if (ModelAdvisorReportParser.isSupportedFinding(modelAdvisorFinding)) {
            this.findings.add(modelAdvisorFinding);
        }
    }

    private static String getFollowingRecommendedAction(Element startElement, Element topElement) {
        Element current = startElement;
        while (current != null) {
            Optional<String> recommendedAction = ModelAdvisorReportParser.traverseSiblingsAndCollectRecommendedAction(current);
            if (recommendedAction.isPresent()) {
                return recommendedAction.get();
            }
            if ((current = current.parent()) != topElement) continue;
            break;
        }
        return null;
    }

    private static Optional<String> traverseSiblingsAndCollectRecommendedAction(Element current) {
        StringBuilder sb = new StringBuilder();
        boolean foundRecommendedAction = false;
        for (Node currentSibling : CollectionUtils.subListFrom((List)current.siblingNodes(), (int)current.siblingIndex())) {
            if (currentSibling instanceof Element && ((Element)currentSibling).wholeText().equals(RECOMMENDED_ACTION_TAG)) {
                foundRecommendedAction = true;
                continue;
            }
            if (foundRecommendedAction && currentSibling instanceof Element) {
                sb.append(((Element)currentSibling).wholeText());
                continue;
            }
            if (!(currentSibling instanceof TextNode)) continue;
            String siblingText = ((TextNode)currentSibling).getWholeText();
            if (ONLY_UNDERSCORES.matcher(siblingText.trim()).matches()) break;
            if (!foundRecommendedAction) continue;
            sb.append(((TextNode)currentSibling).getWholeText());
        }
        if (!foundRecommendedAction) {
            return Optional.empty();
        }
        return Optional.of(sb.toString().trim());
    }

    private QualifiedNameLocation parseLocation(String modelAdvisorLink) {
        if (modelAdvisorLink.startsWith(MATLAB_MODELADVISORPRIVATE_HILITE_LINE) || modelAdvisorLink.isEmpty()) {
            return null;
        }
        Matcher matcher = MATLAB_HILITE_SYSTEM_PATTERN.matcher(modelAdvisorLink);
        String modelItem = matcher.matches() ? ModelAdvisorReportParser.parseLocationFromHiliteSystem(matcher.group(1)) : StringUtils.getLastPart((String)modelAdvisorLink, (char)' ');
        if (modelItem.startsWith(USE_SID_PREFIX)) {
            return this.parseLocationFromIds(modelItem.substring(USE_SID_PREFIX.length()));
        }
        Pair<String, String> modelAndBlockId = ModelAdvisorReportParser.cleanUpModelItem(modelItem);
        String model = (String)modelAndBlockId.getFirst();
        String blockId = (String)modelAndBlockId.getSecond();
        String uniformPath = this.findUniformPathForModelPath(model);
        if (uniformPath != null) {
            if (StringUtils.isEmpty((String)blockId)) {
                return new QualifiedNameLocation("", uniformPath);
            }
            blockId = ModelAdvisorReportParser.fixModelNameInBlockId(this.getModelName(uniformPath), blockId);
            return new QualifiedNameLocation(blockId, uniformPath);
        }
        return null;
    }

    private static Pair<String, String> cleanUpModelItem(String modelItem) {
        modelItem = modelItem.replace(MODEL_ADVISOR_UNDERSCORE_IN_PATH_REPLACEMENT, "_");
        modelItem = modelItem.replace(MODEL_ADVISOR_SLASH_IN_PATH_REPLACEMENT, "/");
        int indexOfFirstSlash = (modelItem = modelItem.replace(MODEL_ADVISOR_NEWLINE_IN_PATH_REPLACEMENT, "\\n")).indexOf(47);
        if (indexOfFirstSlash > 0) {
            return Pair.createPair((Object)modelItem.substring(0, indexOfFirstSlash), (Object)modelItem);
        }
        return Pair.createPair((Object)modelItem, (Object)"");
    }

    private static String fixModelNameInBlockId(String realModelName, String blockId) {
        if (realModelName == null) {
            return blockId;
        }
        int indexOfFirstSlash = blockId.indexOf(47);
        if (indexOfFirstSlash > 0) {
            return realModelName + blockId.substring(indexOfFirstSlash);
        }
        return realModelName;
    }

    private Optional<SimulinkModel> loadModel(String uniformPath) {
        if (this.binaryElementIndex == null) {
            return Optional.empty();
        }
        try {
            return this.simulinkModelLoader.getModelByUniformPath(uniformPath);
        }
        catch (StorageException e) {
            LOGGER.warn("Unable to load model {}", (Object)uniformPath, (Object)e);
            return Optional.empty();
        }
    }

    private String getModelName(String uniformPath) {
        Optional<SimulinkModel> model = this.loadModel(uniformPath);
        return model.map(simulinkModel -> simulinkModel.getParameter("Name")).orElse(null);
    }

    private QualifiedNameLocation parseLocationFromIds(String path) {
        List sidSegments = StringUtils.splitToList((String)path, (String)":");
        if (sidSegments.size() < 2) {
            LOGGER.warn("Cannot extract the SID from '{}' because there is no separator ':'", (Object)path);
            return this.getGenericModelLocation(path);
        }
        Optional<QualifiedNameLocation> qualifiedNameLocation = this.resolveLocationFromSid((String)sidSegments.get(0), sidSegments.subList(1, sidSegments.size()));
        return qualifiedNameLocation.orElseGet(() -> this.getGenericModelLocation(path));
    }

    private static String parseLocationFromHiliteSystem(String hiliteSystemPath) {
        String path = hiliteSystemPath;
        Matcher matcher = MATLAB_HILITE_SYSTEM_CHAR_PATTERN.matcher(path);
        if (matcher.matches()) {
            StringBuilder nameBuilder = new StringBuilder();
            try {
                for (String charDigit : Patterns.WHITESPACE.split(matcher.group(1))) {
                    nameBuilder.append((char)Integer.parseInt(charDigit));
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Cannot extract location from {}, because the char array contains characters which are not integers.", (Object)hiliteSystemPath);
                return "";
            }
            path = Jsoup.parseBodyFragment((String)nameBuilder.toString()).text();
        }
        return path;
    }

    private static QualifiedNameLocation getQualifiedNameLocationForBlock(SimulinkBlock simulinkBlock) {
        if (simulinkBlock == null) {
            return null;
        }
        String fixedBlockId = simulinkBlock.buildQualifiedName();
        String uniformPath = simulinkBlock.getModel().getUniformPath();
        return new QualifiedNameLocation(fixedBlockId, uniformPath);
    }

    private static QualifiedNameLocation getQualifiedNameLocationForStateflowNode(StateflowNodeBase stateflowNode) {
        if (stateflowNode == null) {
            return null;
        }
        String qualifiedName = stateflowNode.buildQualifiedName();
        String uniformPath = stateflowNode.getMachine().getModel().getUniformPath();
        return new QualifiedNameLocation(qualifiedName, uniformPath);
    }

    private static QualifiedNameLocation getQualifiedNameLocationForStateflowTransition(StateflowTransition transition, String uniformPath) {
        if (transition == null) {
            return null;
        }
        String qualifiedName = transition.buildQualifiedName();
        return new QualifiedNameLocation(qualifiedName, uniformPath);
    }

    private @Nullable QualifiedNameLocation getGenericModelLocation(String model) {
        String uniformPath = this.findUniformPathForModelPath(model);
        if (uniformPath != null) {
            return new QualifiedNameLocation("", uniformPath);
        }
        return null;
    }

    private Optional<QualifiedNameLocation> resolveLocationFromSid(String initialModelName, List<String> idSegmentsTail) {
        String uniformPath = this.findUniformPathForModelPath(initialModelName);
        if (uniformPath == null || idSegmentsTail.isEmpty()) {
            return Optional.empty();
        }
        Optional model = this.loadModel(uniformPath);
        Optional<Object> currentBlock = Optional.empty();
        Optional<QualifiedNameLocation> currentLocation = Optional.empty();
        for (String sidFragment : idSegmentsTail.stream().filter(id -> !id.isEmpty()).toList()) {
            Optional<QualifiedNameLocation> location;
            if (model.isEmpty()) {
                return Optional.empty();
            }
            if (currentBlock.isPresent() && (location = ModelAdvisorReportParser.resolveQualifiedNameLocationDependingOnParent(model.get(), (SimulinkBlock)currentBlock.get(), sidFragment)).isPresent()) {
                return location;
            }
            currentBlock = ModelAdvisorReportParser.resolveBlockFromSimulinkId(model.get(), sidFragment);
            if (currentBlock.isEmpty()) {
                return currentLocation;
            }
            currentLocation = Optional.of(ModelAdvisorReportParser.getQualifiedNameLocationForBlock((SimulinkBlock)currentBlock.get()));
            if (!((SimulinkBlock)currentBlock.get()).isOfType("Reference") || ((SimulinkBlock)currentBlock.get()).getSourceBlockName() == null) continue;
            model = model.get().resolveModel(StringUtils.getFirstPart((String)((SimulinkBlock)currentBlock.get()).getSourceBlockName(), (String)"/"));
        }
        return currentLocation;
    }

    private static Optional<QualifiedNameLocation> resolveQualifiedNameLocationDependingOnParent(SimulinkModel model, SimulinkBlock parent, String sidFragment) {
        String id;
        Optional<SimulinkBlock> block;
        Optional<QualifiedNameLocation> stateflowLocation = ModelAdvisorReportParser.resolveLocationFromStateflowId(parent, sidFragment);
        if (stateflowLocation.isPresent()) {
            return stateflowLocation;
        }
        if (parent.isOfType("SubSystem") && (block = ModelAdvisorReportParser.resolveBlockFromSimulinkId(model, id = parent.getParameter("SID") + "::" + sidFragment)).isPresent()) {
            return Optional.of(ModelAdvisorReportParser.getQualifiedNameLocationForBlock(block.get()));
        }
        return Optional.empty();
    }

    private static Optional<SimulinkBlock> resolveBlockFromSimulinkId(SimulinkModel model, String sid) {
        if (model == null) {
            return Optional.empty();
        }
        return SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)true, (boolean)true).stream().filter(block -> sid.equals(block.getParameter("SID"))).findAny();
    }

    private static Optional<QualifiedNameLocation> resolveLocationFromStateflowId(SimulinkBlock chartBlock, String stateflowIDSegment) {
        if (!chartBlock.isStateflowChartBlock()) {
            return Optional.empty();
        }
        StateflowChart chart = ((StateflowBlock)chartBlock).getChart();
        Optional<StateflowNodeBase> node = ModelAdvisorReportParser.resolveNodeFromStateflowId(chart, stateflowIDSegment);
        if (node.isPresent()) {
            return Optional.of(ModelAdvisorReportParser.getQualifiedNameLocationForStateflowNode(node.get()));
        }
        Optional<StateflowTransition> transition = ModelAdvisorReportParser.resolveTransitionFromStateflowId(chart, stateflowIDSegment);
        if (transition.isPresent()) {
            return Optional.of(ModelAdvisorReportParser.getQualifiedNameLocationForStateflowTransition(transition.get(), chart.getMachine().getModel().getUniformPath()));
        }
        Optional<StateflowData> stateflowData = ModelAdvisorReportParser.resolveStateflowDataFromStateflowId(chart, stateflowIDSegment);
        if (stateflowData.isPresent()) {
            return Optional.of(ModelAdvisorReportParser.getQualifiedNameLocationForBlock(chartBlock));
        }
        return Optional.empty();
    }

    private static Optional<StateflowNodeBase> resolveNodeFromStateflowId(StateflowChart chart, String stateflowIDSegment) {
        String stateflowId = chart.getStateflowId() + ":" + stateflowIDSegment;
        return StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)true).stream().filter(node -> stateflowId.equals(node.getStateflowId())).findFirst();
    }

    private static Optional<StateflowTransition> resolveTransitionFromStateflowId(StateflowChart chart, String stateflowIDSegment) {
        String stateflowId = chart.getStateflowId() + ":" + stateflowIDSegment;
        return StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)true).stream().filter(transition -> stateflowId.equals(transition.getId())).findFirst();
    }

    private static Optional<StateflowData> resolveStateflowDataFromStateflowId(StateflowChart chart, String stateflowIDSegment) {
        String stateflowId = chart.getStateflowId() + ":" + stateflowIDSegment;
        return chart.getData().stream().filter(data -> stateflowId.equals(data.getStateflowId())).findFirst();
    }

    private static String parseCheckId(Element divElement) {
        Elements spanElements = divElement.getElementsByTag(EHTMLElement.SPAN.getName());
        for (Element spanElement : spanElements) {
            String classValue = spanElement.attr(EHTMLAttribute.CLASS.getName());
            if (!classValue.equals(MODEL_ADVISOR_CLASS_CHECK_HEADING)) continue;
            String idValue = spanElement.attr(EHTMLAttribute.ID.getName());
            if (idValue.isEmpty()) {
                LOGGER.warn("Missing 'id' attribute for {}", (Object)spanElement);
                continue;
            }
            if (!idValue.startsWith(MODEL_ADVISOR_ID_PREFIX_HEADING)) {
                LOGGER.warn("Unexpected format of 'id' attribute for {}", (Object)spanElement);
                continue;
            }
            return StringUtils.stripPrefix((String)idValue, (String)MODEL_ADVISOR_ID_PREFIX_HEADING);
        }
        return null;
    }

    private static String parseCheckName(Element divElement) {
        Elements spanElements = divElement.getElementsByTag(EHTMLElement.SPAN.getName());
        for (Element spanElement : spanElements) {
            String classValue = spanElement.attr(EHTMLAttribute.CLASS.getName());
            if (!MODEL_ADVISOR_CLASS_CHECK_HEADING.equals(classValue)) continue;
            return spanElement.text().trim();
        }
        return null;
    }

    private CheckMapping determineCheckMappingForModelAdvisorId(String checkId) {
        if (checkId == null || !checkId.contains(".")) {
            return this.unsupportedCheck;
        }
        String checkIdSuffix = checkId.substring(checkId.lastIndexOf(46));
        Optional<CheckMapping> check = this.knownChecks.stream().filter(c -> c.checkId.endsWith(checkIdSuffix)).findFirst();
        if (check.isEmpty() && MODEL_ADVISOR_CHECK_ID_MIGRATIONS.containsKey(checkIdSuffix)) {
            String newSuffix = MODEL_ADVISOR_CHECK_ID_MIGRATIONS.get(checkIdSuffix);
            check = this.knownChecks.stream().filter(c -> c.checkId.endsWith(newSuffix)).findFirst();
        }
        if (check.isEmpty()) {
            check = Optional.of(this.unsupportedCheck);
        }
        if (check.get().defaultEnablement == null) {
            LOGGER.warn("Check '{}' hidden behind disabled feature toggle", (Object)check.get().checkId);
            check = Optional.of(this.unsupportedCheck);
        }
        return check.get();
    }

    private String findUniformPathForModelPath(String model) {
        try {
            Optional<String> uniformPath = this.resolvePath(model);
            if (uniformPath.isPresent()) {
                return uniformPath.get();
            }
            for (String extension : ELanguage.SIMULINK.getFileExtensions()) {
                uniformPath = this.resolvePath(model + "." + extension);
                if (!uniformPath.isPresent()) continue;
                return uniformPath.get();
            }
        }
        catch (StorageException e) {
            LOGGER.error("Cannot get uniform path for model '{}'.", (Object)model, (Object)e);
        }
        return null;
    }

    @Override
    protected void collectFindings() {
        QualifiedNameLocation location;
        for (ModelAdvisorFinding finding : this.findings) {
            location = this.parseLocation(finding.matlabReference);
            if (location == null) {
                location = this.defaultLocation;
            }
            if (location == null) continue;
            DetachedFinding detachedFinding = new DetachedFinding(finding.check.checkId, "Model Advisor", finding.message, (ElementLocation)location, finding.findingColor);
            detachedFinding.setProperty("Rule ID", (Object)finding.check.checkId);
            if (finding.recommendedAction != null) {
                detachedFinding.setProperty("Recommended Action", (Object)finding.recommendedAction);
            }
            this.addFindingForPath(location.getUniformPath(), detachedFinding);
        }
        for (ModelAdvisorFinding finding : this.unsupportedCheckFindings) {
            location = this.parseLocation(finding.matlabReference);
            if (location == null) {
                location = this.defaultLocation;
            }
            if (location == null) continue;
            this.addFindingForPath(location.getUniformPath(), new DetachedFinding(this.unsupportedCheck.checkId, "Model Advisor", finding.message, (ElementLocation)location, finding.findingColor));
        }
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        ModelAdvisorReportParser.checkEnabledAnalysisTool(EAnalysisTool.MODEL_ADVISOR, analysisProfiles, projectId);
    }

    private record ModelAdvisorFinding(CheckMapping check, String matlabReference, String message, ETrafficLightColor findingColor, String recommendedAction) {
        private ModelAdvisorFinding(CheckMapping check, String matlabReference, String message, ETrafficLightColor findingColor, String recommendedAction) {
            this.check = check;
            this.matlabReference = matlabReference;
            this.message = message.trim();
            this.findingColor = findingColor;
            this.recommendedAction = recommendedAction;
        }
    }
}

