/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.google.common.base.CaseFormat;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class PyLintReportParser
extends FindingCollectingReportParserBase {
    private static final Pattern FINDING_PATTERN = Pattern.compile("\\{?line:\\s?(.*?),\\s?messageId:\\s?(.*?),\\s?message:\\s?(.*?),\\s?absolutePath:\\s?(.*?),\\s?messageName:\\s?(.*?)\\}?\n", 32);
    private static final Pattern RULE_NAME_PATTERN = Pattern.compile("([a-z])([A-Z])");

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        Matcher matcher = FINDING_PATTERN.matcher(StringUtils.ensureEndsWith((String)report, (String)"\n"));
        while (matcher.find()) {
            if (matcher.groupCount() != 5) {
                LOGGER.error("Invalid line in PyLint report: " + matcher.group());
            }
            String line = PyLintReportParser.removeDoubleQuotes(matcher.group(1));
            String messageId = PyLintReportParser.removeDoubleQuotes(matcher.group(2));
            String message = PyLintReportParser.removeDoubleQuotes(matcher.group(3));
            String path = PyLintReportParser.removeDoubleQuotes(matcher.group(4));
            String messageName = PyLintReportParser.removeDoubleQuotes(matcher.group(5));
            try {
                Optional<String> uniformPath = this.resolvePath(path);
                if (!uniformPath.isPresent()) continue;
                DetachedFinding finding = PyLintReportParser.createLineFinding(Integer.parseInt(line), uniformPath.get(), PyLintReportParser.getRuleId(messageId, messageName), "Pylint", message);
                this.addFindingForPath(uniformPath.get(), finding);
            }
            catch (StorageException e) {
                throw new ReportParserException((Throwable)e);
            }
        }
    }

    private static String removeDoubleQuotes(String string) {
        if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    protected void collectFindings() throws StorageException {
    }

    private static String getRuleId(String messageId, String messageName) {
        String niceRuleName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, messageName);
        niceRuleName = StringUtils.replaceAll((String)niceRuleName, (Pattern)RULE_NAME_PATTERN, (String)"$1 $2");
        return niceRuleName + " (" + messageId + ")";
    }
}

