/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.dependencies.ITypeIndex;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.logging.RateLimiting;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;

public abstract class ReportParserBase
implements IReportParser {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected IMatchingPathsLookup matchingPathsLookup;
    protected TokenElementIndexCache tokenElementIndexCache;
    protected TokenElementLineInfoIndex tokenElementLineInfoIndex;
    protected BinaryElementIndex binaryElementIndex;
    protected ITypeIndex typeIndexCache;
    protected ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex;
    protected String connectorId;
    protected @Nullable String repository;
    protected MetaIndex projectMetaIndex;
    protected boolean disablePlausibilityCheckForPathMapping;
    protected final RateLimiting loggingRateLimiting = new RateLimiting(100);
    protected ExecuteInParallelBatchesFunction parallelExecutor;

    @Override
    public void init(TokenElementIndexCache tokenElementCache, TokenElementLineInfoIndex tokenElementLineInfoIndex, BinaryElementIndex binaryElementIndex, IMatchingPathsLookup matchingPathsLookup, ITypeIndex typeIndex, ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex, String connectorId, MetaIndex projectMetaIndex, boolean disablePlausibilityCheckForPathMapping, ExecuteInParallelBatchesFunction parallelExecutor, String repository) {
        this.tokenElementIndexCache = tokenElementCache;
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
        this.binaryElementIndex = binaryElementIndex;
        this.matchingPathsLookup = matchingPathsLookup;
        this.typeIndexCache = typeIndex;
        this.externalFindingsGroupDescriptionIndex = externalFindingsGroupDescriptionIndex;
        this.connectorId = connectorId;
        this.projectMetaIndex = projectMetaIndex;
        this.disablePlausibilityCheckForPathMapping = disablePlausibilityCheckForPathMapping;
        this.parallelExecutor = parallelExecutor;
        this.repository = repository;
    }

    protected IPathMatchingPlausibilityCheck buildPlausibilityCheck() {
        return IPathMatchingPlausibilityCheck.acceptAll();
    }

    @Override
    public void parse(ReportContentIndexBase.ReportContent report, @Nullable String reportPath) throws ReportParserException {
        if (report.format == EReportFormat.SIMULINK_MAT) {
            throw new ReportParserException("Method must be overwritten for parsing of binary reports");
        }
        String content = report.getContentAsString();
        this.parseStringReport(content, reportPath);
    }

    @Override
    public void parseStringReport(String reportContent, @Nullable String reportPath) throws ReportParserException {
        this.resetState();
        this.initializeState(reportContent);
        this.parseStringReportInternal(reportContent, reportPath);
    }

    protected void initializeState(String report) {
    }

    protected void resetState() {
        this.loggingRateLimiting.reset();
    }

    protected abstract void parseStringReportInternal(String var1, @Nullable String var2) throws ReportParserException;

    @Override
    public ExternalAnalysisImportInfos getInfos() throws ReportParserException {
        try {
            return this.convertToImportInfos();
        }
        catch (StorageException e) {
            throw new ReportParserException("Failed to access storage: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract ExternalAnalysisImportInfos convertToImportInfos() throws StorageException;

    protected Optional<String> resolvePath(String pathFromReport) throws StorageException {
        return this.resolvePath(pathFromReport, null, "");
    }

    protected Optional<String> resolvePath(String pathFromReport, IPathMatchingPlausibilityCheck plausibilityCheck, String pathPrefix) throws StorageException {
        return this.matchingPathsLookup.lookupBestPath(pathFromReport, plausibilityCheck);
    }

    protected static DetachedFinding createFindingWithLocation(String ruleId, String groupName, String categoryName, String message, ElementLocation elementLocation) {
        DetachedFinding finding = new DetachedFinding(groupName, categoryName, message, elementLocation);
        finding.setProperty("Rule ID", (Object)ruleId);
        return finding;
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
    }

    protected static void checkEnabledAnalysisTool(EAnalysisTool tool, List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        if (!AnalysisProfileUtils.getConfiguredTools(analysisProfiles).contains(tool)) {
            throw new ConQATException("Upload failed. " + tool.getReadableName() + " analysis is not enabled in the analysis configuration for project: " + String.valueOf(projectId) + ".");
        }
    }
}

