/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.parser.ESPCopAttribute;
import com.teamscale.index.report.parser.ESPCopElement;
import com.teamscale.index.report.parser.ESpCopSeverity;
import com.teamscale.index.report.parser.ReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public class SPCopReportParser
extends FindingCollectingReportParserBase {
    private static final String SPCOP_FINDINGS_KEY = "SPCop";
    private List<SPCopFinding> spCopFindings = new ArrayList<SPCopFinding>();

    @Override
    protected void resetState() {
        super.resetState();
        this.spCopFindings = new ArrayList<SPCopFinding>();
    }

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            new SPCopReportReader().loadReport(report);
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        SPCopReportParser.checkEnabledAnalysisTool(EAnalysisTool.SPCOP, analysisProfiles, projectId);
    }

    protected void createSpCopFinding(String message, String location, String ruleId, int lineNumber, ESpCopSeverity severity) {
        this.spCopFindings.add(new SPCopFinding(this, message, location, ruleId, lineNumber, severity));
    }

    @Override
    protected void collectFindings() throws StorageException {
        for (SPCopFinding spCopFinding : this.spCopFindings) {
            Optional<String> uniformPath = this.resolvePath(spCopFinding.getLocation());
            if (!uniformPath.isPresent()) {
                LOGGER.warn("The path: " + String.valueOf(uniformPath) + " from the SPCop report could not be resolved to a uniform path in Teamscale. SpCop finding could not be created.");
                return;
            }
            DetachedFinding finding = SPCopReportParser.createLineFinding(spCopFinding.getLineNumber(), uniformPath.get(), spCopFinding.getRuleId(), SPCOP_FINDINGS_KEY, spCopFinding.getMessage());
            finding.setAssessment(spCopFinding.getSeverity().getColor());
            this.addFindingForPath(uniformPath.get(), finding);
        }
    }

    public class SPCopReportReader {
        public void loadReport(String report) throws ConQATException {
            new SPCopXMLParser(report).parse();
        }

        private class SPCopXMLParser
        extends XMLReaderBase<ESPCopElement, ESPCopAttribute, ConQATException> {
            public SPCopXMLParser(String report) {
                super(report, ESPCopAttribute.class);
            }

            public void parse() throws ConQATException {
                this.parseAndWrapExceptions();
                this.processDecendantElements(new VisitorGroupParser());
            }

            protected String getLocation() {
                return "SPCop report";
            }

            private class VisitorGroupParser
            implements IXMLElementProcessor<ESPCopElement, ConQATException> {
                private VisitorGroupParser() {
                }

                public ESPCopElement getTargetElement() {
                    return ESPCopElement.VisitorGroup;
                }

                public void process() throws ConQATException {
                    String visitorGroupName = SPCopXMLParser.this.getStringAttribute(ESPCopAttribute.Name);
                    SPCopXMLParser.this.processDecendantElements(new NotificationParser(visitorGroupName));
                }
            }

            private class NotificationParser
            implements IXMLElementProcessor<ESPCopElement, ConQATException> {
                private final String visitorGroupName;

                public NotificationParser(String visitorGroupName) {
                    this.visitorGroupName = visitorGroupName;
                }

                public ESPCopElement getTargetElement() {
                    return ESPCopElement.Notification;
                }

                public void process() {
                    String location = SPCopXMLParser.this.getChildText(ESPCopElement.HiveLocation);
                    String ruleId = this.buildRuleId();
                    if (!location.toLowerCase().endsWith(".xml")) {
                        return;
                    }
                    location = SPCopXMLParser.this.getChildText(ESPCopElement.WSPRelativeLocation);
                    ESpCopSeverity severity = (ESpCopSeverity)SPCopXMLParser.this.getEnumAttribute(ESPCopAttribute.Severity, ESpCopSeverity.class);
                    String message = SPCopXMLParser.this.getChildText(ESPCopElement.Message);
                    int lineNumber = this.getChildTextAsInteger(ESPCopElement.LineNumber);
                    SPCopReportParser.this.createSpCopFinding(message, location, ruleId, lineNumber, severity);
                }

                private String buildRuleId() {
                    String checkId = SPCopXMLParser.this.getStringAttribute(ESPCopAttribute.CheckID);
                    String name = SPCopXMLParser.this.getStringAttribute(ESPCopAttribute.Name);
                    String severity = SPCopXMLParser.this.getStringAttribute(ESPCopAttribute.Severity);
                    return name + " (" + checkId + ") [" + severity + ", " + this.visitorGroupName + "]";
                }

                private int getChildTextAsInteger(ESPCopElement element) {
                    String text = SPCopXMLParser.this.getChildText(element);
                    if (text != null) {
                        try {
                            return Integer.parseInt(text);
                        }
                        catch (NumberFormatException e) {
                            ReportParserBase.LOGGER.warn("Invalid integer value: " + text);
                        }
                    }
                    return -1;
                }
            }
        }
    }

    private class SPCopFinding {
        private final String message;
        private final String location;
        private final String ruleId;
        private final int lineNumber;
        private final ESpCopSeverity severity;

        public SPCopFinding(SPCopReportParser sPCopReportParser, String message, String location, String ruleId, int lineNumber, ESpCopSeverity severity) {
            this.message = message;
            this.location = location;
            this.ruleId = ruleId;
            this.lineNumber = lineNumber;
            this.severity = severity;
        }

        public ESpCopSeverity getSeverity() {
            return this.severity;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

