/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.index.repository.AcceptAllMergedRevisionsFilter;
import com.teamscale.index.repository.MergedRevisionsFilter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;

public class MergeAncestorExplorer {
    private final MergedRevisionsFilter sourceMergedRevisionFilter;
    private final MergedRevisionsFilter targetMergedRevisionFilter;

    public MergeAncestorExplorer(MergedRevisionsFilter sourceMergedRevisionFilter, MergedRevisionsFilter targetMergedRevisionFilter) {
        this.sourceMergedRevisionFilter = sourceMergedRevisionFilter;
        this.targetMergedRevisionFilter = targetMergedRevisionFilter;
    }

    public Set<CommitDescriptor> exploreAncestorsOfSourceCommit(CommitDescriptor sourceCommit, Set<CommitDescriptor> stopCommits, Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits) throws RepositoryException {
        return this.exploreAncestors(sourceCommit, stopCommits, parentedCommits, this.sourceMergedRevisionFilter);
    }

    public Set<CommitDescriptor> exploreAncestorsOfTargetCommit(CommitDescriptor targetCommit, Set<CommitDescriptor> stopCommits, Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits) throws RepositoryException {
        return this.exploreAncestors(targetCommit, stopCommits, parentedCommits, this.targetMergedRevisionFilter);
    }

    private Set<CommitDescriptor> exploreAncestors(CommitDescriptor startCommit, Set<CommitDescriptor> stopCommits, Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits, MergedRevisionsFilter mergedRevisionsFilter) throws RepositoryException {
        HashSet<CommitDescriptor> ancestors = new HashSet<CommitDescriptor>();
        ArrayDeque<CommitDescriptor> queue = new ArrayDeque<CommitDescriptor>();
        queue.add(startCommit);
        while (!queue.isEmpty()) {
            CommitDescriptor next = (CommitDescriptor)queue.poll();
            ParentedCommitDescriptor parentedNext = parentedCommits.get(next);
            if (parentedNext == null || mergedRevisionsFilter.isContainedInMergeOrOnInitialBranch(parentedNext) && !ancestors.add(next) || stopCommits.contains(next)) continue;
            queue.addAll((Collection<CommitDescriptor>)parentedNext.getParentCommits());
        }
        return ancestors;
    }

    public static MergeAncestorExplorer getMergeAncestorExplorerWithAcceptAllFilters() {
        return new MergeAncestorExplorer(new AcceptAllMergedRevisionsFilter(null), new AcceptAllMergedRevisionsFilter(null));
    }
}

