/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.trigger.RichCommitDescriptor;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.log.RollbackLogMessage;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.committree.ICommitTreeNodeAdjuster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class RepositoryChangeRetrieverUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static RichCommitDescriptor extractResultCommitAndPersist(CommitTreeNode commitTreeNode, IChangeRetrieverCommitTree commitTree, ICommitTreeNodeAdjuster commitTreeNodeAdjuster, Predicate<CommitTreeNode> skipOracle, ICommitTreeExpansion expandCommitTree, int pollingIntervalSeconds) throws StorageException, RepositoryException, RescheduleRequestedException {
        if (!commitTree.wasExpandedWithinTimespan(pollingIntervalSeconds) && (RepositoryChangeRetrieverUtils.isLastNodeOnBranch(commitTreeNode, commitTree) || RepositoryChangeRetrieverUtils.isTreeExhausted(commitTree))) {
            LOGGER.debug("Performing commit tree expansion during extractResultCommitAndPersist");
            RepositoryChangeRetrieverUtils.expandCommitTree(commitTree, expandCommitTree);
            commitTreeNodeAdjuster.adjustTimestamps(commitTree.getAllRawNodes());
        }
        ArrayList schedulingHints = new ArrayList();
        ArrayList schedulingPreAnnouncements = new ArrayList();
        commitTree.extractAndUpdateSchedulableCommits(schedulingHints, schedulingPreAnnouncements, skipOracle);
        List parentCommits = CollectionUtils.map((Collection)commitTreeNode.getNonEmptyParents(), CommitTreeNode::getAdjustedCommitDescriptor);
        if (commitTreeNode.getInjectedParent() != null) {
            parentCommits.add(commitTreeNode.getInjectedParent());
        }
        commitTree.persist();
        RichCommitDescriptor resultCommit = new RichCommitDescriptor(commitTreeNode.getAdjustedCommitDescriptor(), parentCommits, schedulingHints, schedulingPreAnnouncements);
        RepositoryChangeRetrieverUtils.validateCommit(resultCommit);
        LOGGER.debug("Resulting commit is " + String.valueOf(resultCommit) + " with hints " + String.valueOf(resultCommit.getSchedulingHints()));
        return resultCommit;
    }

    public static CommitTreeExpansionResult expandCommitTree(IChangeRetrieverCommitTree commitTree, ICommitTreeExpansion expandCommitTree) throws RepositoryException, RescheduleRequestedException {
        CommitTreeExpansionResult expansionResult = expandCommitTree.apply((ICommitTree)commitTree);
        if (expansionResult.fullyExpanded) {
            commitTree.setLastExpanded(Instant.now().toEpochMilli());
        } else {
            commitTree.resetLastExpandedTimestamp();
        }
        return expansionResult;
    }

    private static boolean isTreeExhausted(IChangeRetrieverCommitTree commitTree) {
        return !commitTree.hasSchedulableNodes() && !commitTree.hasScheduledNodes();
    }

    private static boolean isLastNodeOnBranch(CommitTreeNode commitTreeNode, IChangeRetrieverCommitTree commitTree) {
        Optional latestRevision = commitTree.getLatestContainedRevisionForBranch((ICommitTreeNode)commitTreeNode);
        if (latestRevision.isEmpty()) {
            return false;
        }
        return ((String)latestRevision.get()).equals(commitTreeNode.getRevision().getRevision());
    }

    private static void validateCommit(RichCommitDescriptor commit) {
        for (CommitDescriptor parent : commit.getParentCommits()) {
            CCSMAssert.isFalse((boolean)parent.equals((Object)commit), (String)"Commit may not be its own parent!");
        }
    }

    public static @Nullable CommitDescriptor resetCommitTreeWithOutputCommit(CommitDescriptor originalInputCommit, CommitTreeIndex commitTreeIndex, @Nullable BranchRenamingCommitTreeFacade branchRenamingFacade, RepositoryNeedsRollbackException ... previousRollbackExceptions) throws StorageException {
        ArrayList<RepositoryNeedsRollbackException> allRollbackExceptions = new ArrayList<RepositoryNeedsRollbackException>(Arrays.asList(previousRollbackExceptions));
        UUID rollbackId = RepositoryChangeRetrieverUtils.extractRollbackId(allRollbackExceptions);
        try {
            RepositoryChangeRetrieverUtils.resetCommitTree(originalInputCommit, commitTreeIndex, rollbackId);
        }
        catch (RepositoryNeedsRollbackException e) {
            allRollbackExceptions.add(e);
        }
        if (allRollbackExceptions.isEmpty()) {
            return null;
        }
        RollbackRequestedCommitDescriptor rollbackRequestCommit = RepositoryChangeRetrieverUtils.createRollbackRequestedCommitDescriptorForExceptions(allRollbackExceptions, rollbackId, branchRenamingFacade);
        LOGGER.warn((Message)new RollbackLogMessage(rollbackRequestCommit.getRollbackReason(), rollbackRequestCommit.getRollbackId()));
        return rollbackRequestCommit;
    }

    private static UUID extractRollbackId(List<RepositoryNeedsRollbackException> rollbackExceptions) {
        Set rollbackIds = CollectionUtils.mapToSet(rollbackExceptions, RepositoryNeedsRollbackException::getRollbackId);
        if (rollbackIds.isEmpty()) {
            return UUID.randomUUID();
        }
        if (rollbackIds.size() > 1) {
            LOGGER.warn("Clashing rollback IDs: " + StringUtils.concat((Iterable)rollbackIds, (String)", "));
        }
        return (UUID)CollectionUtils.getAny((Iterable)rollbackIds);
    }

    private static RollbackRequestedCommitDescriptor createRollbackRequestedCommitDescriptorForExceptions(List<RepositoryNeedsRollbackException> exceptions, UUID rollbackId, @Nullable BranchRenamingCommitTreeFacade branchRenamingCommitTreeFacade) {
        HashSet rollbackCommits = new HashSet();
        StringBuilder rollbackReason = new StringBuilder();
        for (RepositoryNeedsRollbackException exception : exceptions) {
            rollbackCommits.addAll(exception.getRollbackToAsSchedulingHints());
            rollbackReason.append(exception.getMessage()).append(" Rollback requested to:\n").append(exception.getRollbackToAsSchedulingHints()).append("\n");
        }
        if (branchRenamingCommitTreeFacade != null) {
            HashSet<CommitDescriptor> renamedCommitDescriptors = new HashSet<CommitDescriptor>(rollbackCommits.size());
            for (CommitDescriptor commitDescriptor : rollbackCommits) {
                String renamedBranch = branchRenamingCommitTreeFacade.renameBranch(commitDescriptor.getBranchName());
                renamedCommitDescriptors.add(new CommitDescriptor(renamedBranch, commitDescriptor.getTimestamp()));
            }
            rollbackCommits.addAll(renamedCommitDescriptors);
        }
        return new RollbackRequestedCommitDescriptor(new ArrayList(rollbackCommits), rollbackReason.toString(), rollbackId);
    }

    private static void resetCommitTree(CommitDescriptor originalInputCommit, CommitTreeIndex commitTreeIndex, UUID rollbackId) throws StorageException, RepositoryNeedsRollbackException {
        if (originalInputCommit == null) {
            return;
        }
        CommitTree commitTree = commitTreeIndex.loadTree();
        if (commitTree.hasScheduledAdjustedCommit(originalInputCommit)) {
            CommitTreeNode scheduledNode = commitTree.findScheduledNodeByAdjustedCommitDescriptor(originalInputCommit, rollbackId);
            scheduledNode.resetScheduledNode();
        }
        commitTree.resetLastExpandedTimestamp();
        commitTree.persist();
    }

    public static CommitTreeNode extractNextCommitTreeNode(IChangeRetrieverCommitTree commitTree, CommitDescriptor inputCommit, ICommitTreeExpansion expandCommitTree, ICommitTreeNodeAdjuster commitTreeNodeAdjuster, int pollingIntervalSeconds) throws StorageException, RescheduleRequestedException, RepositoryException {
        CommitTreeNode commitTreeNode = null;
        if (inputCommit != null) {
            commitTreeNode = commitTree.findScheduledNodeByAdjustedCommitDescriptor(inputCommit);
            if (commitTreeNode == null) {
                LOGGER.error("Had direct scheduling of commit {} for which no scheduled node exists in commit tree. Falling back to finding another node that can be scheduled.", (Object)inputCommit);
            } else if (commitTreeNode.getState() != ECommitTreeNodeState.SCHEDULED) {
                String message = "Had direct scheduling of commit " + String.valueOf(inputCommit) + " which is not in state SCHEDULED.";
                LOGGER.error(() -> message + " Performing rollback to restore valid state.");
                throw new RepositoryNeedsRollbackException(message, Map.of(inputCommit.getBranchName(), inputCommit.getTimestamp() - 1L));
            }
        }
        if (commitTreeNode == null) {
            LOGGER.debug("No scheduled node found, searching for schedulable node");
            commitTreeNode = commitTree.getNextSchedulableNode();
            if (commitTreeNode == null && !commitTree.wasExpandedWithinTimespan(pollingIntervalSeconds)) {
                LOGGER.debug("No schedulable node found, expanding commit tree");
                RepositoryChangeRetrieverUtils.expandCommitTree(commitTree, expandCommitTree);
                commitTreeNodeAdjuster.adjustTimestamps(commitTree.getAllRawNodes());
                commitTreeNode = commitTree.getNextSchedulableNode();
                commitTree.persist();
            }
        }
        LOGGER.debug("Selected commit tree node: " + String.valueOf(commitTreeNode));
        return commitTreeNode;
    }

    public static List<? extends ICommitTreeNode> determineNonEmptyParentsIncludingForkInformation(ICommitTreeNode commitTreeNode, IRepositoryConnection repositoryConnection, CommitDescriptorIndex commitDescriptorIndex, BranchRenamingCommitTreeFacade branchRenamingFacade) throws StorageException {
        List<ICommitTreeNode> nonEmptyParents = commitTreeNode.getNonEmptyParents();
        if (nonEmptyParents.isEmpty()) {
            LOGGER.debug("No non empty parents for commit revision " + String.valueOf(commitTreeNode.getRevision()) + " found, all parent revisions for the commit are the following" + String.valueOf(commitTreeNode.getParentRevisions()));
        }
        if (nonEmptyParents.isEmpty() && repositoryConnection.shouldInheritForkInformation()) {
            nonEmptyParents = RepositoryChangeRetrieverUtils.determineParentsFromInheritedForkInformation(commitTreeNode.getRevision().getBranchName(), commitDescriptorIndex, branchRenamingFacade);
        }
        return nonEmptyParents;
    }

    private static List<ICommitTreeNode> determineParentsFromInheritedForkInformation(String currentBranchName, CommitDescriptorIndex commitDescriptorIndex, BranchRenamingCommitTreeFacade branchRenamingFacade) throws StorageException {
        List allNodesOnBranch = commitDescriptorIndex.getCommitsForBranch(currentBranchName);
        if (allNodesOnBranch.isEmpty()) {
            return Collections.emptyList();
        }
        ParentedCommitDescriptor firstCommitOnBranch = (ParentedCommitDescriptor)allNodesOnBranch.get(0);
        if (firstCommitOnBranch.getFirstParentCommit() == null) {
            return Collections.emptyList();
        }
        String otherBranchName = firstCommitOnBranch.getFirstParentCommit().getBranchName();
        if (currentBranchName.equals(otherBranchName)) {
            throw new AssertionError((Object)("Expected first commit " + String.valueOf(firstCommitOnBranch) + " to have a parent from a different branch, but both are on the same branch."));
        }
        Optional<String> latestRevision = branchRenamingFacade.resolveLatestRevisionBefore(otherBranchName, firstCommitOnBranch.getFirstParentCommit().getTimestamp());
        if (latestRevision.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(branchRenamingFacade.getNodeByRevision(new CommitTreeRevision(latestRevision.get(), otherBranchName)));
    }

    public static @Nullable RepositoryChangeSet determineChangeSet(ICommitTreeNode originalNode, ICommitTreeNode ancestorNode, BranchRenamingCommitTreeFacade branchRenamingFacade, IRepositoryConnection repositoryConnection) throws RepositoryException {
        if (!repositoryConnection.supportsSkipping() && originalNode.getParentRevisions().isEmpty()) {
            throw new RepositoryException("May not call this method for revision " + String.valueOf(originalNode.getRevision()) + " without parents!");
        }
        if (repositoryConnection.supportsSkipping() || ((CommitTreeRevision)originalNode.getParentRevisions().get(0)).equals((Object)ancestorNode.getRevision())) {
            return repositoryConnection.getChangeSet(branchRenamingFacade.unrenameBranch(originalNode), branchRenamingFacade.unrenameBranch(ancestorNode));
        }
        return RepositoryChangeRetrieverUtils.collectChangeSetTransitively(originalNode, ancestorNode, branchRenamingFacade, repositoryConnection);
    }

    private static @Nullable RepositoryChangeSet collectChangeSetTransitively(ICommitTreeNode originalNode, ICommitTreeNode ancestorNode, BranchRenamingCommitTreeFacade branchRenamingFacade, IRepositoryConnection repositoryConnection) throws RepositoryException {
        LOGGER.traceEntry("Collecting changes for revisions {} to {}", new Object[]{ancestorNode.getRevision().getRevision(), originalNode.getRevision().getRevision()});
        ArrayList<RepositoryChangeSet> changeSets = new ArrayList<RepositoryChangeSet>();
        ICommitTreeNode branchRenamingAncestorNode = branchRenamingFacade.getNodeByRevision(ancestorNode.getRevision());
        CCSMAssert.isNotNull((Object)branchRenamingAncestorNode, (String)("Failed to resolve ancestor node from " + String.valueOf(ancestorNode)));
        ICommitTreeNode node = originalNode;
        while (!node.getRevision().equals((Object)branchRenamingAncestorNode.getRevision())) {
            if (node.getParentRevisions().isEmpty()) {
                LOGGER.warn("Did not find expected parent " + String.valueOf(ancestorNode.getRevision()) + " while traversing parent history of " + String.valueOf(originalNode.getRevision()));
                break;
            }
            ICommitTreeNode directParent = branchRenamingFacade.getNodeByRevision((CommitTreeRevision)node.getParentRevisions().get(0));
            CCSMAssert.isNotNull((Object)directParent, (String)("Failed to resolve direct parent of " + String.valueOf(node)));
            RepositoryChangeSet localChange = repositoryConnection.getChangeSet(branchRenamingFacade.unrenameBranch(node), branchRenamingFacade.unrenameBranch(directParent));
            if (localChange != null) {
                LOGGER.debug("Adding changeset with ID {} to the list of changes between revisions {} and {}.", (Object)localChange.getRevision(), (Object)ancestorNode.getRevision().getRevision(), (Object)originalNode.getRevision().getRevision());
                changeSets.add(localChange);
            }
            node = directParent;
        }
        if (changeSets.isEmpty()) {
            return (RepositoryChangeSet)((Object)LOGGER.traceExit((Object)((RepositoryChangeSet)null)));
        }
        RepositoryChangeSet changeSet = ((RepositoryChangeSet)((Object)changeSets.get(0))).cloneWithoutChanges();
        Collections.reverse(changeSets);
        changeSets.forEach(changeSet::applyChanges);
        return (RepositoryChangeSet)((Object)LOGGER.traceExit((Object)changeSet));
    }

    @FunctionalInterface
    public static interface ICommitTreeExpansion {
        public CommitTreeExpansionResult apply(ICommitTree var1) throws RepositoryException, RescheduleRequestedException;
    }
}

