/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.IRevisionResolver;
import com.teamscale.index.repository.base.CredentialsBasedRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRevisionResolver;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.svn.SVNRepositoryConnectorDescriptor;
import com.teamscale.index.repository.svn.SVNRevisionResolver;
import com.teamscale.index.repository.tfs.TfsRepositoryConnectorDescriptor;
import com.teamscale.index.repository.tfs.TfsRevisionResolver;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class RevisionResolverFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Optional<IRevisionResolver> getRevisionResolver(ConnectorDescriptorBase connectorDescriptor, InternalProjectId project, IndexLayer indexLayer) throws StorageException {
        CredentialsBasedRepositoryConnectorDescriptorBase credentialsBasedConnectorDescriptor;
        GitRepositoryConnectorDescriptor gitRepositoryConnectorDescriptor;
        IRevisionResolver revisionResolver;
        if (connectorDescriptor instanceof GitRepositoryConnectorDescriptor && (revisionResolver = RevisionResolverFactory.getGitBasedRevisionResolverInternal(gitRepositoryConnectorDescriptor = (GitRepositoryConnectorDescriptor)connectorDescriptor, project, indexLayer)) != null) {
            return Optional.of(revisionResolver);
        }
        if (connectorDescriptor instanceof CredentialsBasedRepositoryConnectorDescriptorBase && (revisionResolver = RevisionResolverFactory.getRevisionResolverForNonGitConnectors(credentialsBasedConnectorDescriptor = (CredentialsBasedRepositoryConnectorDescriptorBase)connectorDescriptor, indexLayer)) != null) {
            return Optional.of(revisionResolver);
        }
        LOGGER.warn("No revision resolver that supports: " + connectorDescriptor.connectorEnum.getReadableName() + " yet.");
        return Optional.empty();
    }

    public static Optional<GitRevisionResolver> getGitBasedRevisionResolver(GitRepositoryConnectorDescriptor gitConnectorDescriptor, InternalProjectId project, IndexLayer indexLayer) throws StorageException {
        return Optional.ofNullable(RevisionResolverFactory.getGitBasedRevisionResolverInternal(gitConnectorDescriptor, project, indexLayer));
    }

    private static @Nullable IRevisionResolver getRevisionResolverForNonGitConnectors(CredentialsBasedRepositoryConnectorDescriptorBase connectorDescriptor, IndexLayer indexLayer) throws StorageException {
        ExternalCredentialsIndex credentialsIndex = (ExternalCredentialsIndex)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials credentials = credentialsIndex.getExternalCredentials(connectorDescriptor.getAccountIdentifier());
        switch (connectorDescriptor.getRepositoryType()) {
            case SVN: {
                CCSMAssert.isInstanceOf((Object)((Object)connectorDescriptor), SVNRepositoryConnectorDescriptor.class);
                SVNRepositoryConnectorDescriptor svnConnectorDescriptor = (SVNRepositoryConnectorDescriptor)connectorDescriptor;
                return new SVNRevisionResolver(credentials, svnConnectorDescriptor);
            }
            case TFS: {
                CCSMAssert.isInstanceOf((Object)((Object)connectorDescriptor), TfsRepositoryConnectorDescriptor.class);
                TfsRepositoryConnectorDescriptor tfsConnectorDescriptor = (TfsRepositoryConnectorDescriptor)connectorDescriptor;
                return new TfsRevisionResolver(credentials, tfsConnectorDescriptor, connectorDescriptor.branchingEnabled, connectorDescriptor.getPathSuffix(), tfsConnectorDescriptor.branchLookupPaths);
            }
        }
        return null;
    }

    private static @Nullable GitRevisionResolver getGitBasedRevisionResolverInternal(GitRepositoryConnectorDescriptor gitConnectorDescriptor, InternalProjectId project, IndexLayer indexLayer) throws StorageException {
        String repositoryNameOrPathSuffix;
        ExternalCredentials credentials = null;
        switch (gitConnectorDescriptor.getRepositoryType()) {
            default: {
                throw new MatchException(null, null);
            }
            case AZURE_DEVOPS_GIT: 
            case BITBUCKET_SERVER: 
            case GITEA: 
            case GITLAB: 
            case SCM_MANAGER: {
                Object object;
                Object object2 = object = ((GitRepositoryManagementConnectorDescriptorBase)gitConnectorDescriptor).getRepositoryName();
                break;
            }
            case BITBUCKET: {
                Object object;
                CCSMAssert.isInstanceOf((Object)((Object)gitConnectorDescriptor), BitbucketCloudRepositoryConnectorDescriptor.class);
                BitbucketCloudRepositoryConnectorDescriptor bitbucketCloudConnectorDescriptor = (BitbucketCloudRepositoryConnectorDescriptor)gitConnectorDescriptor;
                try {
                    credentials = bitbucketCloudConnectorDescriptor.resolveExternalCredentials();
                }
                catch (ConnectorValidationException e) {
                    throw new StorageException((Throwable)e);
                }
                Object object2 = object = "";
                break;
            }
            case GIT: {
                Object object;
                Object object2 = object = gitConnectorDescriptor.getPathSuffix();
                break;
            }
            case GITHUB: {
                Object object;
                CCSMAssert.isInstanceOf((Object)((Object)gitConnectorDescriptor), GitHubRepositoryConnectorDescriptor.class);
                GitHubRepositoryConnectorDescriptor gitHubConnectorDescriptor = (GitHubRepositoryConnectorDescriptor)gitConnectorDescriptor;
                credentials = RevisionResolverFactory.getExternalCredentialsForGithubConnector(gitHubConnectorDescriptor, indexLayer);
                Object object2 = object = "";
                break;
            }
            case GERRIT: {
                Object object;
                CCSMAssert.isInstanceOf((Object)((Object)gitConnectorDescriptor), GerritRepositoryConnectorDescriptor.class);
                GerritRepositoryConnectorDescriptor gerritConnectorDescriptor = (GerritRepositoryConnectorDescriptor)gitConnectorDescriptor;
                Object object2 = object = gerritConnectorDescriptor.getGerritProjectName() + "/" + gerritConnectorDescriptor.getPathSuffix();
                break;
            }
            case SVN: 
            case TFS: 
            case FILE_SYSTEM: 
            case S3: 
            case MULTI_VERSION_FILE_SYSTEM: 
            case ARTIFACTORY: 
            case ABAP_GIT: 
            case ARTIFICIAL_MERGE_REQUEST: {
                Object object;
                Object object2 = repositoryNameOrPathSuffix = (object = null);
            }
        }
        if (repositoryNameOrPathSuffix == null) {
            return null;
        }
        if (credentials == null) {
            ExternalCredentialsIndex credentialsIndex = (ExternalCredentialsIndex)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
            String accountIdentifier = gitConnectorDescriptor.getAccountIdentifier();
            credentials = credentialsIndex.getExternalCredentials(accountIdentifier);
        }
        return new GitRevisionResolver(gitConnectorDescriptor, repositoryNameOrPathSuffix, project, credentials, indexLayer);
    }

    private static ExternalCredentials getExternalCredentialsForGithubConnector(GitHubRepositoryConnectorDescriptor gitHubConnectorDescriptor, IndexLayer indexLayer) throws StorageException {
        try {
            String gitHubServerUrl = gitHubConnectorDescriptor.getGitHubServerUrl().url();
            String fullRepositoryName = gitHubConnectorDescriptor.getRepositoryName();
            GitHubAppBasedRepositoryAccessHelper<ProjectConfigurationException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<ProjectConfigurationException>(gitHubServerUrl, fullRepositoryName, indexLayer.openGlobalStorageSystem(), ProjectConfigurationException::new, LOGGER);
            return new ExternalCredentials("dummy", repositoryAccessHelper.getRepositoryCloneUrl(), "x-access-token", repositoryAccessHelper.getInstallationAccessToken());
        }
        catch (ServiceCallException | ProjectConfigurationException e) {
            throw new StorageException(e);
        }
    }
}

