/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

public abstract class GlobalArchiveContentIndexBase
extends IndexBase
implements IGlobalIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] HASH_TO_CONTENT_KEY_PREFIX = new byte[]{1};
    private static final byte[] HASH_TO_LAST_ACCESSED_TIMESTAMP_KEY_PREFIX = new byte[]{2};
    private static final byte[] HASH_TO_SIZE_KEY_PREFIX = new byte[]{3};
    private static final XXHash64 FAST_HASHER = XXHashFactory.fastestInstance().hash64();

    protected GlobalArchiveContentIndexBase(IStore store) {
        super(store);
    }

    public byte[] setContent(byte[] content) throws StorageException {
        int contentLength = content.length;
        byte[] contentHash = ByteArrayUtils.longToByteArray((long)FAST_HASHER.hash(content, 0, contentLength, 0L));
        byte[] contentKey = GlobalArchiveContentIndexBase.makeContentKey(contentHash);
        byte[] lastUpdatedTimestamp = ByteArrayUtils.longToByteArray((long)System.currentTimeMillis());
        this.store.put(PairList.fromPairs((Pair)Pair.createPair((Object)GlobalArchiveContentIndexBase.makeLastAccessedKey(contentHash), (Object)lastUpdatedTimestamp), (Pair[])new Pair[]{Pair.createPair((Object)contentKey, (Object)content), Pair.createPair((Object)GlobalArchiveContentIndexBase.makeEntrySizeKey(contentHash), (Object)ByteArrayUtils.longToByteArray((long)content.length))}));
        return contentHash;
    }

    public List<byte @Nullable []> getContent(List<byte @Nullable []> contentHashes) throws StorageException {
        HashSet<Integer> nullEntryIndexes = new HashSet<Integer>();
        for (int i = 0; i < contentHashes.size(); ++i) {
            if (contentHashes.get(i) != null) continue;
            nullEntryIndexes.add(i);
        }
        List nonNullContentHashes = CollectionUtils.filterNullEntries(contentHashes);
        List bytes = this.store.get(CollectionUtils.map((Collection)nonNullContentHashes, GlobalArchiveContentIndexBase::makeContentKey));
        PairList lastAccessedUpdates = new PairList(nonNullContentHashes.size());
        byte[] updateTimestamp = ByteArrayUtils.longToByteArray((long)System.currentTimeMillis());
        for (int i = 0; i < nonNullContentHashes.size(); ++i) {
            byte[] contentHash = (byte[])nonNullContentHashes.get(i);
            if (bytes.get(i) == null) continue;
            lastAccessedUpdates.add((Object)GlobalArchiveContentIndexBase.makeLastAccessedKey(contentHash), (Object)updateTimestamp);
        }
        this.store.put(lastAccessedUpdates);
        if (nullEntryIndexes.isEmpty()) {
            return bytes;
        }
        ArrayList<byte[]> returnValues = new ArrayList<byte[]>(contentHashes.size());
        int j = 0;
        for (int i = 0; i < contentHashes.size(); ++i) {
            if (nullEntryIndexes.contains(i)) {
                returnValues.add(null);
                continue;
            }
            returnValues.add((byte[])bytes.get(j++));
        }
        return returnValues;
    }

    private static byte[] makeContentKey(byte[] hash) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{HASH_TO_CONTENT_KEY_PREFIX, hash});
    }

    private static byte[] makeLastAccessedKey(byte[] contentHash) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{HASH_TO_LAST_ACCESSED_TIMESTAMP_KEY_PREFIX, contentHash});
    }

    private static byte[] makeEntrySizeKey(byte[] contentHash) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{HASH_TO_SIZE_KEY_PREFIX, contentHash});
    }

    private PairList<byte[], Long> getAllLastAccessedEntries() throws StorageException {
        PairList result = new PairList();
        this.store.scan(HASH_TO_LAST_ACCESSED_TIMESTAMP_KEY_PREFIX, (key, value) -> {
            byte[] resultKey = Arrays.copyOfRange(key, 1, key.length);
            long resultValue = ByteArrayUtils.byteArrayToLong((byte[])value);
            PairList pairList = result;
            synchronized (pairList) {
                result.add((Object)resultKey, (Object)resultValue);
            }
        });
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void pruneIndex(long targetIndexSizeBytes, long minimumTimestampToKeepEntry) throws StorageException {
        PairList<byte[], Long> lastAccessedTimestampByRevisionKey = this.getAllLastAccessedEntries();
        lastAccessedTimestampByRevisionKey.sort(Comparator.comparing(ImmutablePair::getSecond));
        List sizeKeysInOrder = CollectionUtils.map((Collection)lastAccessedTimestampByRevisionKey.extractFirstList(), GlobalArchiveContentIndexBase::makeEntrySizeKey);
        @Nullable List valuesAsByteArray = this.store.get(sizeKeysInOrder);
        List<@Nullable Long> revisionSizes = GlobalArchiveContentIndexBase.getRevisionSizes(lastAccessedTimestampByRevisionKey, valuesAsByteArray);
        long currentStoreSizeBytes = revisionSizes.stream().filter(Objects::nonNull).mapToLong(x -> x).sum();
        ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>();
        for (int i = 0; i < lastAccessedTimestampByRevisionKey.size() && (currentStoreSizeBytes > targetIndexSizeBytes || (Long)lastAccessedTimestampByRevisionKey.getSecond(i) < minimumTimestampToKeepEntry); ++i) {
            Long revisionSize = revisionSizes.get(i);
            if (revisionSize != null) {
                currentStoreSizeBytes -= revisionSize.longValue();
            }
            byte[] contentHash = (byte[])lastAccessedTimestampByRevisionKey.getFirst(i);
            keysToRemove.add(GlobalArchiveContentIndexBase.makeLastAccessedKey(contentHash));
            keysToRemove.add(GlobalArchiveContentIndexBase.makeEntrySizeKey(contentHash));
            keysToRemove.add(GlobalArchiveContentIndexBase.makeContentKey(contentHash));
        }
        this.store.remove(keysToRemove);
    }

    private static @NonNull List<@Nullable Long> getRevisionSizes(PairList<byte[], Long> lastAccessedTimestampByRevisionKey, List<byte @Nullable []> valuesAsByteArray) {
        ArrayList<@Nullable Long> revisionSizes = new ArrayList<Long>();
        for (int i = 0; i < valuesAsByteArray.size(); ++i) {
            byte[] value = valuesAsByteArray.get(i);
            if (value != null) {
                revisionSizes.add(ByteArrayUtils.byteArrayToLong((byte[])value));
                continue;
            }
            LOGGER.error("Found null entry during pruning of global archive content index. Revision key: " + ByteArrayUtils.hexDump((byte[])((byte[])lastAccessedTimestampByRevisionKey.getFirst(i))) + ", last accessed timestamp: " + String.valueOf(lastAccessedTimestampByRevisionKey.getSecond(i)));
            revisionSizes.add(null);
        }
        return revisionSizes;
    }
}

