/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.external.input.external_storage.IOutgoingExternalAnalysisArchive;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.EArtifactStoreScanType;
import com.teamscale.index.utils.StringPoolDeserializer;
import com.teamscale.index.utils.StringPoolSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.BiConsumerWithTwoExceptions;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class SimpleArtifactStoreClientBase<T extends ArtifactStoreRepositoryInfoBase> {
    protected static final Duration TIMEOUT = Duration.ofMinutes(10L);
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    public abstract void forEachEntryInArchive(String var1, String var2, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> var3) throws RepositoryException, StorageException, ProjectConfigurationException;

    @VisibleForTesting
    public static void forEachEntryInArchiveStream(String path, InputStream contentStream, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> consumer) throws IOException, StorageException {
        String lowerCasePath = path.toLowerCase();
        if (lowerCasePath.endsWith(".zip")) {
            SimpleArtifactStoreClientBase.forEachEntryInZipStream(contentStream, consumer);
        } else if (lowerCasePath.endsWith(".tar")) {
            SimpleArtifactStoreClientBase.forEachEntryInTarStream(contentStream, consumer);
        } else if (StringUtils.endsWithOneOf((String)lowerCasePath, (String[])new String[]{".tar.bz2", ".tbz2"})) {
            SimpleArtifactStoreClientBase.forEachEntryInTarStream((InputStream)new BZip2CompressorInputStream(contentStream), consumer);
        } else if (StringUtils.endsWithOneOf((String)lowerCasePath, (String[])new String[]{".tar.gz", ".tgz"})) {
            SimpleArtifactStoreClientBase.forEachEntryInTarStream((InputStream)new GzipCompressorInputStream(contentStream), consumer);
        } else {
            contentStream.close();
            throw new IOException("Unknown/unsupported archive file extension in archive " + path);
        }
    }

    private static void forEachEntryInZipStream(InputStream contentStream, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> consumer) throws IOException, StorageException {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(contentStream);){
            ZipArchiveEntry zipEntry = zis.getNextZipEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    consumer.accept((Object)zis, (Object)zipEntry);
                }
                zipEntry = zis.getNextZipEntry();
            }
        }
    }

    private static void forEachEntryInTarStream(InputStream uncompressedStream, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> consumer) throws IOException, StorageException {
        try (TarArchiveInputStream tarStream = new TarArchiveInputStream(uncompressedStream);){
            TarArchiveEntry tarEntry = tarStream.getNextTarEntry();
            while (tarEntry != null) {
                if (!tarEntry.isDirectory()) {
                    consumer.accept((Object)tarStream, (Object)tarEntry);
                }
                tarEntry = tarStream.getNextTarEntry();
            }
        }
    }

    public abstract ItemQueryResultData findItems(T var1, int var2) throws RepositoryException, ProjectConfigurationException, RescheduleRequestedException;

    public abstract void putArchive(String var1, IOutgoingExternalAnalysisArchive var2) throws RepositoryException;

    public abstract void deleteArchive(String var1, String var2) throws RepositoryException;

    @VisibleForTesting
    public static List<ItemData> filterDuplicateItems(ItemQueryResultData items) {
        HashMap itemByFullPath = new HashMap();
        items.forEach((Consumer<? super ItemData>)((Consumer<ItemData>)item -> itemByFullPath.merge(item.getFullPath(), item, (item1, item2) -> {
            if (item1.getCreationTimestamp() <= item2.getCreationTimestamp()) {
                return item1;
            }
            return item2;
        })));
        return new ArrayList<ItemData>(itemByFullPath.values());
    }

    public abstract Set<String> fetchBranches(T var1) throws RepositoryException, ProjectConfigurationException;

    public abstract void testConnection(String var1, String var2) throws RepositoryException, ProjectConfigurationException;

    public static class ItemQueryResultData
    implements Iterable<ItemData> {
        private static final String RESULTS_PROPERTY = "results";
        @JsonProperty(value="results")
        public final List<ItemData> results;
        private EArtifactStoreScanType scanType = EArtifactStoreScanType.INCREMENTAL_SCAN;

        public EArtifactStoreScanType getScanType() {
            return this.scanType;
        }

        @JsonCreator
        private ItemQueryResultData(@JsonProperty(value="results") Collection<ItemData> results) {
            this.results = new ArrayList<ItemData>(results);
        }

        public static ItemQueryResultData forIncrementalAdditiveScanWithAddedKeys(List<ItemData> addedKeys) {
            ItemQueryResultData itemData = new ItemQueryResultData(addedKeys);
            itemData.scanType = EArtifactStoreScanType.INCREMENTAL_ADDITIVE_SCAN;
            return itemData;
        }

        public static ItemQueryResultData forIncrementalScanWithAddedKeys(List<ItemData> addedKeys) {
            ItemQueryResultData itemData = new ItemQueryResultData(addedKeys);
            itemData.scanType = EArtifactStoreScanType.INCREMENTAL_SCAN;
            return itemData;
        }

        public static ItemQueryResultData forFullScanWithAllKeys(List<ItemData> allKeys) {
            ItemQueryResultData itemData = new ItemQueryResultData(allKeys);
            itemData.scanType = EArtifactStoreScanType.FULL_SCAN;
            return itemData;
        }

        public static ItemQueryResultData emptyResultData() {
            return new ItemQueryResultData((Collection<ItemData>)CollectionUtils.emptyList());
        }

        @Override
        public @NonNull Iterator<ItemData> iterator() {
            return this.results.iterator();
        }

        @Override
        public void forEach(Consumer<? super ItemData> action) {
            this.results.forEach(action);
        }

        @Override
        public Spliterator<ItemData> spliterator() {
            return this.results.spliterator();
        }

        public Stream<ItemData> stream() {
            return this.results.stream();
        }

        public byte[] toByteArray() throws StorageException {
            StringPoolSerializer stringPoolSerializer = new StringPoolSerializer(){

                @Override
                protected void serializeData(DataOutputStream dos) throws IOException {
                    dos.writeInt(scanType.ordinal());
                    dos.writeInt(results.size());
                    for (ItemData item : results) {
                        this.writeString(item.name, dos);
                        this.writeString(item.path, dos);
                        dos.writeLong(item.creationTimestamp);
                        dos.writeLong(item.contentLength);
                    }
                }
            };
            for (ItemData item : this.results) {
                stringPoolSerializer.addString(item.name);
                stringPoolSerializer.addString(item.path);
            }
            return stringPoolSerializer.serialize();
        }

        public static @Nullable ItemQueryResultData fromByteArray(byte @Nullable [] bytes) {
            if (bytes == null) {
                return null;
            }
            final ItemQueryResultData[] data = new ItemQueryResultData[]{null};
            StringPoolDeserializer deserializer = new StringPoolDeserializer(){

                @Override
                protected void deserializeData(DataInputStream din) throws IOException {
                    EArtifactStoreScanType scanType = EArtifactStoreScanType.fromSerializationId(din.readInt()).orElseThrow();
                    int resultCount = din.readInt();
                    ArrayList<ItemData> results = new ArrayList<ItemData>(resultCount);
                    for (int i = 0; i < resultCount; ++i) {
                        String name = this.readString(din);
                        String path = this.readString(din);
                        long creationTimestamp = din.readLong();
                        results.add(new ItemData(name, path, creationTimestamp, din.readLong()));
                    }
                    data[0] = new ItemQueryResultData(results);
                    data[0].scanType = scanType;
                }
            };
            deserializer.deserialize(bytes);
            return data[0];
        }
    }

    public static class ItemData {
        private static final String PATH_PROPERTY = "path";
        private static final String NAME_PROPERTY = "name";
        private static final String CREATED_PROPERTY = "created";
        private static final String SIZE_PROPERTY = "size";
        @JsonProperty(value="path")
        public final String path;
        @JsonProperty(value="name")
        public final String name;
        @JsonProperty(value="created")
        private final String created;
        @JsonProperty(value="size")
        private final long contentLength;
        private long creationTimestamp = -1L;

        @JsonCreator
        public ItemData(@JsonProperty(value="path") String path, @JsonProperty(value="name") String name, @JsonProperty(value="created") String created, @JsonProperty(value="size") long contentLength) {
            this.path = path;
            this.name = name;
            this.created = created;
            this.contentLength = contentLength;
            if (created != null) {
                this.creationTimestamp = Instant.from(DATE_FORMATTER.parse(created)).toEpochMilli();
            }
        }

        private ItemData(String name, String path, long creationTimestamp, long contentLength) {
            this.name = name;
            this.path = path;
            this.creationTimestamp = creationTimestamp;
            this.created = null;
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public String getFullPath() {
            return this.path + "/" + this.name;
        }

        public String toString() {
            return "ItemData{path='" + this.path + "', name='" + this.name + "', creationTimestamp='" + this.creationTimestamp + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemData itemData = (ItemData)o;
            return this.creationTimestamp == itemData.creationTimestamp && Objects.equals(this.path, itemData.path) && Objects.equals(this.name, itemData.name);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.name, this.creationTimestamp);
        }
    }

    public static class RepositoryData {
        public String key;
    }
}

