/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.artifactory;

import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ArtifactoryAqlUtils {
    public static String createAqlQuery(ArtifactoryRepositoryInfo info, long changedSinceTimestamp) throws StorageException {
        if (changedSinceTimestamp != 0L) {
            changedSinceTimestamp = Math.max(ArtifactoryAqlUtils.getLowerTimestampBoundaryForChanges(info), changedSinceTimestamp);
        }
        ArrayList<String> subQueryParts = new ArrayList<String>();
        subQueryParts.add(ArtifactoryAqlUtils.getRepositorySpecificFilters(info));
        if (changedSinceTimestamp != 0L) {
            subQueryParts.add(ArtifactoryAqlUtils.makeModifiedOrCreatedSinceQuery(changedSinceTimestamp));
        }
        return ArtifactoryAqlUtils.makeAqlQuery(ArtifactoryAqlUtils.makeAndQuery(subQueryParts));
    }

    private static long getLowerTimestampBoundaryForChanges(ArtifactoryRepositoryInfo info) {
        return info.getIgnoreChangesOlderThanDays().map(days -> DateTimeUtils.now().minus(Duration.ofDays(days.intValue()))).orElse(Instant.EPOCH).toEpochMilli();
    }

    private static String getRepositorySpecificFilters(ArtifactoryRepositoryInfo info) {
        List<String> nameSearchPatterns = info.getNameSearchPatterns();
        List<String> pathSearchPatterns = info.getPathSearchPatterns();
        ArrayList<String> subQueryParts = new ArrayList<String>();
        if (!nameSearchPatterns.isEmpty()) {
            subQueryParts.add(ArtifactoryAqlUtils.makeOrQuery(CollectionUtils.map(nameSearchPatterns, pattern -> ArtifactoryAqlUtils.makeMatchQuery("name", pattern))));
        }
        if (!pathSearchPatterns.isEmpty()) {
            subQueryParts.add(ArtifactoryAqlUtils.makeOrQuery(CollectionUtils.map(pathSearchPatterns, pattern -> ArtifactoryAqlUtils.makeMatchQuery("path", pattern))));
        }
        subQueryParts.add(ArtifactoryAqlUtils.makeEqualQuery("repo", info.getRepositoryOrBucketName()));
        return ArtifactoryAqlUtils.makeAndQuery(subQueryParts);
    }

    private static String makeAqlQuery(String filterQuery) {
        return "items.find(" + filterQuery + ").include(\"path\", \"name\", \"repo\", \"created\")";
    }

    private static String getTimestampAsString(long timestamp) {
        CCSMAssert.isFalse((timestamp < 0L ? 1 : 0) != 0, (String)"Timestamp for query may not be negative.");
        return SimpleArtifactStoreClientBase.DATE_FORMATTER.format(Instant.ofEpochMilli(timestamp).atZone(TimeZone.getDefault().toZoneId()));
    }

    private static String makeModifiedOrCreatedSinceQuery(@Nullable Long timestamp) {
        if (timestamp == null) {
            timestamp = 0L;
        }
        return ArtifactoryAqlUtils.makeOrQuery(ArtifactoryAqlUtils.makeGtQuery("modified", ArtifactoryAqlUtils.getTimestampAsString(timestamp)), ArtifactoryAqlUtils.makeGtQuery("created", ArtifactoryAqlUtils.getTimestampAsString(timestamp)));
    }

    public static String makeFetchBranchesQuery(String repository) {
        ArrayList<String> subQueryParts = new ArrayList<String>();
        subQueryParts.add(ArtifactoryAqlUtils.makeEqualQuery("repo", repository));
        subQueryParts.add(ArtifactoryAqlUtils.makeEqualQuery("type", "folder"));
        return ArtifactoryAqlUtils.makeAqlQuery(ArtifactoryAqlUtils.makeAndQuery(subQueryParts));
    }

    private static String makeGtQuery(String field, String value) {
        return ArtifactoryAqlUtils.makeSimpleQuery("$gt", field, value);
    }

    private static String makeMatchQuery(String field, String value) {
        return ArtifactoryAqlUtils.makeSimpleQuery("$match", field, value);
    }

    private static String makeEqualQuery(String field, String value) {
        return ArtifactoryAqlUtils.makeSimpleQuery("$eq", field, value);
    }

    private static String makeSimpleQuery(String operator, String field, String value) {
        field = ArtifactoryAqlUtils.sanitizeUserInput(field);
        value = ArtifactoryAqlUtils.sanitizeUserInput(value);
        return "{\"" + field + "\":{\"" + StringUtils.ensureStartsWith((String)operator, (String)"$") + "\":\"" + value + "\"}}";
    }

    private static String sanitizeUserInput(String value) {
        return value.replace("\"", Matcher.quoteReplacement("\""));
    }

    private static String makeOrQuery(String ... subQueries) {
        return ArtifactoryAqlUtils.makeCompoundQuery("$or", subQueries);
    }

    private static String makeOrQuery(List<String> subQueries) {
        return ArtifactoryAqlUtils.makeCompoundQuery("$or", (String[])subQueries.toArray(String[]::new));
    }

    private static String makeAndQuery(List<String> subQueries) {
        return ArtifactoryAqlUtils.makeCompoundQuery("$and", (String[])subQueries.toArray(String[]::new));
    }

    private static String makeCompoundQuery(String operator, String ... subQueries) {
        if (subQueries == null) {
            return "";
        }
        if (subQueries.length == 1) {
            return subQueries[0];
        }
        return "{\"" + StringUtils.ensureStartsWith((String)operator, (String)"$") + "\": [" + StringUtils.concat((Object[])subQueries, (String)",") + "]}";
    }
}

