/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameDependentRevisionInterpretationBase;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;

final class ConnectorRevisionInterpretation
extends BranchNameDependentRevisionInterpretationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ICommitTree foreignCommitTree;

    public ConnectorRevisionInterpretation(ICommitTree foreignCommitTree) {
        CCSMAssert.isNotNull((Object)foreignCommitTree);
        this.foreignCommitTree = foreignCommitTree;
    }

    @Override
    protected Optional<CommitDescriptor> interpretRevisionWithBranchName(String revision, @NonNull String branchName) {
        ICommitTreeNode node = this.foreignCommitTree.getNodeByRevision(new CommitTreeRevision(revision, branchName));
        if (node == null) {
            LOGGER.debug("Revision {} not contained in foreign commit tree. Can happen if the revision is outside the analysis scope of the connector or was labeled to a branch other than {}.", (Object)revision, (Object)branchName);
            return Optional.empty();
        }
        return ConnectorRevisionInterpretation.getCommitForAdjustedTimestamp(branchName, node);
    }

    public static Optional<CommitDescriptor> getCommitForAdjustedTimestamp(String branchName, ICommitTreeNode node) {
        if (node.getAdjustedTimestamp().isEmpty()) {
            LOGGER.warn("Skipping revision interpretation of node {} in foreign connector which isn't adjusted yet.", (Object)node);
            return Optional.empty();
        }
        return Optional.of(new CommitDescriptor(branchName, node.getAdjustedTimestamp().getAsLong()));
    }
}

