/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameDependentRevisionInterpretationBase;
import com.teamscale.index.repository.svn.SVNUtils;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

final class SvnRevisionInterpretation
extends BranchNameDependentRevisionInterpretationBase {
    private final SVNRepository repository;

    public SvnRevisionInterpretation(ExternalCredentials credentials) throws RepositoryException {
        try {
            this.repository = SVNUtils.createRepository(credentials.uri, credentials.username, credentials.password);
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Optional<CommitDescriptor> interpretRevisionWithBranchName(String revision, @NonNull String branchName) throws RepositoryException {
        return SVNUtils.convertRevisionToTimestamp(revision, this.repository).map(timestamp -> new CommitDescriptor(branchName, timestamp.longValue()));
    }

    @Override
    public void close() {
        this.repository.closeSession();
    }
}

