/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ICredentialsBasedConnectorDescriptor;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.rest.client.HttpClientUtils;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

public abstract class CredentialsBasedRepositoryConnectorDescriptorBase
extends RepositoryConnectorDescriptorBase
implements ICredentialsBasedConnectorDescriptor {
    @ConfigExposed(name="Account", description="The account for this connector.", required=true)
    protected AccountCredentials accountIdentifier;
    @ConfigExposed(name="Path suffix", description="The suffix to append to the base URL of the repository.")
    private String pathSuffix = "";
    public static final String PATH_SUFFIX_OPTION = "Path suffix";
    public static final String EXTERNAL_CREDENTIALS_NOT_FOUND_ERROR_MESSAGE = "External accounts not found: ";

    protected CredentialsBasedRepositoryConnectorDescriptorBase(ERepositoryConnector connectorType, String defaultBranchName) {
        super(connectorType, defaultBranchName);
    }

    protected ExternalCredentials resolveExternalCredentials() throws ConnectorValidationException {
        try {
            String credentialsName = this.accountIdentifier.getAccountIdentifier();
            ExternalCredentials externalCredentials = this.getContext().getExternalCredentialsProvider().getExternalCredentials(credentialsName);
            if (externalCredentials == null) {
                throw new ConnectorValidationException(EXTERNAL_CREDENTIALS_NOT_FOUND_ERROR_MESSAGE + credentialsName);
            }
            return externalCredentials;
        }
        catch (StorageException e) {
            throw new ConnectorValidationException("Error initializing account based repository from account " + this.accountIdentifier.getAccountIdentifier() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        triggerBuilder.setTriggerParameter("account-identifier", this.getAccountIdentifier());
        triggerBuilder.setTriggerParameter("path-suffix", this.getPathSuffix());
        super.setCommonParameters(triggerBuilder, triggerCreator);
    }

    protected static String concatenateNonEmptyWithSlash(String ... itemsToConcatenate) {
        return ConnectorUtils.concatenateNonEmptyWithSlash((String[])itemsToConcatenate);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        URI uri = this.getRepositoryUri();
        this.validateUri(uri);
        switch (uri.getScheme()) {
            case "http": 
            case "https": {
                this.validateHttpConnection(uri);
                break;
            }
            case "file": {
                this.validateFileConnection(uri);
                break;
            }
        }
    }

    private void validateUri(URI uri) throws ConnectorValidationException {
        String protocol = uri.getScheme();
        if (StringUtils.isEmpty((String)protocol)) {
            throw new ConnectorValidationException("No URL protocol specified.");
        }
        if (!this.validUriProtocol().test(protocol)) {
            throw new ConnectorValidationException("Invalid URL protocol '" + protocol + "'.");
        }
        if (uri.getSchemeSpecificPart().isEmpty()) {
            throw new ConnectorValidationException("Invalid empty URL path in '" + String.valueOf(uri) + "'.");
        }
    }

    protected final URI parseUri(String uri) throws ConnectorValidationException {
        try {
            URI parsedUri = UrlUtils.parseUri((String)UrlUtils.ensureParseable((String)uri));
            if (parsedUri.getScheme() == null) {
                parsedUri = this.useFallbackProtocol(parsedUri);
            }
            if (parsedUri.getAuthority() == null) {
                parsedUri = new URI(parsedUri.getScheme(), "", parsedUri.getPath(), parsedUri.getQuery(), parsedUri.getFragment());
            }
            return parsedUri;
        }
        catch (URISyntaxException e) {
            throw new ConnectorValidationException("Invalid URL format.", (Throwable)e);
        }
    }

    private URI useFallbackProtocol(URI uriWithoutProtocol) throws ConnectorValidationException {
        if (uriWithoutProtocol.isAbsolute()) {
            throw new AssertionError((Object)"Attempting to apply the fallback protocol to an absolute URI.");
        }
        String fallbackProtocol = this.fallbackUriProtocol().orElseThrow(() -> new ConnectorValidationException("The URL '" + String.valueOf(uriWithoutProtocol) + "' is missing a protocol."));
        String authority = uriWithoutProtocol.getAuthority();
        String path = StringUtils.ensureStartsWith((String)uriWithoutProtocol.getPath(), (String)"/");
        String query = uriWithoutProtocol.getQuery();
        String fragment = uriWithoutProtocol.getFragment();
        try {
            return new URI(fallbackProtocol, authority, path, query, fragment);
        }
        catch (URISyntaxException e) {
            throw new ConnectorValidationException("Invalid URL format.", (Throwable)e);
        }
    }

    protected Predicate<String> validUriProtocol() {
        return p -> true;
    }

    protected Optional<String> fallbackUriProtocol() {
        return Optional.empty();
    }

    protected void validateHttpConnection(URI uri) throws ConnectorValidationException {
        try {
            HttpClientUtils.checkHttpConnection((URL)uri.toURL());
        }
        catch (UnknownHostException e) {
            throw new ConnectorValidationException("Unknown host '" + uri.getHost() + "'. Is the URL correct?", (Throwable)e);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ConnectorValidationException("Could not connect to " + String.valueOf(uri) + ". Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void validateFileConnection(URI parsedUri) throws ConnectorValidationException {
        CCSMAssert.isTrue((boolean)"file".equals(parsedUri.getScheme()), () -> String.format("Expected \"%s\" to be have a file scheme", parsedUri));
        Path path = Path.of(parsedUri).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            throw new ConnectorValidationException("Path '" + String.valueOf(path) + "' does not exist.");
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new ConnectorValidationException("Path '" + String.valueOf(path) + "' is not a directory.");
        }
        if (!Files.isReadable(path)) {
            throw new ConnectorValidationException("Path '" + String.valueOf(path) + "' is not readable.");
        }
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        return this.parseUri(CredentialsBasedRepositoryConnectorDescriptorBase.concatenateNonEmptyWithSlash(this.resolveExternalCredentials().uri, this.getPathSuffix()));
    }

    @TestOnly
    public void setAccountIdentifierForTesting(AccountCredentials accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    @TestOnly
    public void setPathSuffixForTesting(String pathSuffix) {
        if (pathSuffix != null) {
            this.pathSuffix = pathSuffix;
        }
    }

    public String getAccountIdentifier() {
        return this.accountIdentifier.getAccountIdentifier();
    }
}

