/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.google.common.collect.Iterables;
import com.teamscale.index.repository.git.CommitGraphNode;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CommitGraphTraversalUtils {
    public static @NonNull List<CommitGraphNode> getLongestLinearHistory(@NonNull CommitGraphNode startNode) {
        ArrayList<CommitGraphNode> nodes = new ArrayList<CommitGraphNode>();
        UnmodifiableList<CommitGraphNode> parents = startNode.getParents();
        if (parents.size() != 1) {
            return nodes;
        }
        CommitGraphNode currentNode = (CommitGraphNode)Iterables.getOnlyElement(parents);
        while ((parents = currentNode.getParents()).size() == 1 && currentNode.getSuccessors().size() <= 1) {
            nodes.add(currentNode);
            currentNode = (CommitGraphNode)Iterables.getOnlyElement(parents);
        }
        return nodes;
    }
}

