/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.index.repository.git.GitBranchRetriever;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitRepositoryBase;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitPreviewUtils {
    public static EGitProtocol getGitProtocol(URI location) throws ProjectConfigurationException {
        Optional optionalProtocol = EGitProtocol.fromUri((String)location.toString());
        if (optionalProtocol.isEmpty()) {
            throw new ProjectConfigurationException("Unknown/unsupported protocol for GIT repo at: " + String.valueOf(location));
        }
        return (EGitProtocol)optionalProtocol.get();
    }

    public static TeamscaleGitCredentialsProvider getCredentialsProvider(ServerOptionIndex serverOptionIndex, EGitProtocol protocol, @Nullable ExternalCredentials credentials, String sshPrivateKeyId) throws RepositoryException {
        if (protocol == EGitProtocol.GIT) {
            return null;
        }
        if (credentials == null) {
            return GitUtils.createEmptyCredentialsProvider();
        }
        return GitUtils.createCredentialsProvider(credentials.username, credentials.password, GitPreviewUtils.getPrivateKey(serverOptionIndex, sshPrivateKeyId));
    }

    private static @Nullable GitPrivateKeyOption getPrivateKey(ServerOptionIndex serverOptionIndex, String sshPrivateKeyId) throws RepositoryException {
        if (StringUtils.isEmpty((String)sshPrivateKeyId)) {
            return null;
        }
        try {
            return (GitPrivateKeyOption)ServerOptionRegistry.getInstance().getServerMultiOption("git.privatekey", sshPrivateKeyId, GitPrivateKeyOption.class, serverOptionIndex);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public static List<String> retrieveFilesFromGit(@NonNull URI location, @NonNull ConnectorConfiguration connectorConfiguration, @NonNull ServerOptionIndex serverOptionIndex, @Nullable ExternalCredentials credentials, boolean isGerrit) throws RepositoryException, ProjectConfigurationException {
        return GitPreviewUtils.retrieveFilesFromGit(location, connectorConfiguration, serverOptionIndex, GitPreviewUtils.getCredentialsProvider(serverOptionIndex, GitPreviewUtils.getGitProtocol(location), credentials, connectorConfiguration.getOptionValue("SSH Private Key ID")), isGerrit);
    }

    public static List<String> retrieveFilesFromGit(URI location, ConnectorConfiguration connectorConfiguration, ServerOptionIndex serverOptionIndex, TeamscaleGitCredentialsProvider credentialsProvider, boolean isGerrit) throws RepositoryException {
        try (Repository repo = GitPreviewUtils.cloneAndSetUpRepository(location, connectorConfiguration, serverOptionIndex, credentialsProvider, isGerrit);){
            String branchName = connectorConfiguration.getOptionValue("Default branch name");
            List<String> list = GitPreviewUtils.collectFilesFromRepoHeadOnBranch(repo, branchName, location, credentialsProvider);
            return list;
        }
    }

    private static List<String> collectFilesFromRepoHeadOnBranch(Repository repo, String branchName, URI location, TeamscaleGitCredentialsProvider credentialsProvider) throws RepositoryException {
        ArrayList<String> arrayList;
        Ref branch = GitBranchRetriever.getRefForGitBranch(branchName, location, credentialsProvider).orElseThrow(() -> new RepositoryException("Branch '" + branchName + "' could not be found in the repository"));
        RevWalk walk = new RevWalk(repo);
        try {
            ArrayList<String> files = new ArrayList<String>();
            RevCommit commit = walk.parseCommit((AnyObjectId)branch.getObjectId());
            RevTree tree = commit.getTree();
            try (TreeWalk treeWalk = new TreeWalk(repo);){
                treeWalk.addTree((AnyObjectId)tree);
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    files.add(treeWalk.getPathString());
                }
            }
            arrayList = files;
        }
        catch (Throwable throwable) {
            try {
                try {
                    walk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        walk.close();
        return arrayList;
    }

    public static List<String> retrieveCommitMessagesFromGit(String branchName, URI location, ConnectorConfiguration connectorConfiguration, ServerOptionIndex serverOptionIndex, ExternalCredentials credentials, boolean isGerrit) throws RepositoryException, ProjectConfigurationException {
        EGitProtocol protocol = GitPreviewUtils.getGitProtocol(location);
        TeamscaleGitCredentialsProvider credentialsProvider = GitPreviewUtils.getCredentialsProvider(serverOptionIndex, protocol, credentials, connectorConfiguration.getOptionValue("SSH Private Key ID"));
        return GitPreviewUtils.retrieveCommitMessagesFromGit(branchName, location, connectorConfiguration, serverOptionIndex, credentialsProvider, isGerrit);
    }

    private static List<String> retrieveCommitMessagesFromGit(String branchName, URI location, ConnectorConfiguration connectorConfiguration, ServerOptionIndex serverOptionIndex, TeamscaleGitCredentialsProvider credentialsProvider, boolean isGerrit) throws RepositoryException {
        try (Repository repo = GitPreviewUtils.cloneAndSetUpRepository(location, connectorConfiguration, serverOptionIndex, credentialsProvider, isGerrit);){
            List<String> list = GitPreviewUtils.collectCommitsFromRepoHeadOnBranch(repo, branchName, location, credentialsProvider);
            return list;
        }
    }

    private static List<String> collectCommitsFromRepoHeadOnBranch(Repository repo, String branchName, URI location, TeamscaleGitCredentialsProvider credentialsProvider) throws RepositoryException {
        ArrayList<String> arrayList;
        Ref branch = GitBranchRetriever.getRefForGitBranch(branchName, location, credentialsProvider).orElseThrow(() -> new RepositoryException("Branch '" + branchName + "' could not be found in the repository"));
        RevWalk walk = new RevWalk(repo);
        try {
            ArrayList<String> commits = new ArrayList<String>();
            RevCommit commit = walk.parseCommit((AnyObjectId)branch.getObjectId());
            walk.markStart(commit);
            for (RevCommit rev : walk) {
                if (commits.size() == 10) break;
                commits.add(rev.getFullMessage());
            }
            walk.dispose();
            arrayList = commits;
        }
        catch (Throwable throwable) {
            try {
                try {
                    walk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        walk.close();
        return arrayList;
    }

    private static Path getClonePathForGit(URI location, ServerOptionIndex serverOptionIndex, boolean isGerrit, Long gerritMinimumCreationTimestamp) throws RepositoryException {
        try {
            return GitRepositoryBase.getLocalCloneLocation(RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)serverOptionIndex), location, isGerrit, gerritMinimumCreationTimestamp);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static Repository cloneAndSetUpRepository(URI location, ConnectorConfiguration connectorConfiguration, ServerOptionIndex serverOptionIndex, TeamscaleGitCredentialsProvider credentialsProvider, boolean isGerrit) throws RepositoryException {
        Path gitClonePath;
        String optionValue;
        Long gerritMinimumCreationTimestamp = null;
        if (isGerrit && !StringUtils.isEmpty((String)(optionValue = connectorConfiguration.getOptionValue("Minimum Change Creation Date")))) {
            gerritMinimumCreationTimestamp = ConnectorUtils.getTimestampForEndDate((String)optionValue).orElse(null);
        }
        if ((gitClonePath = GitPreviewUtils.getClonePathForGit(location, serverOptionIndex, isGerrit, gerritMinimumCreationTimestamp)).toUri().equals(location) && !Files.exists(gitClonePath, new LinkOption[0])) {
            throw new RepositoryException("There is no git repository at the expected location: " + String.valueOf(location));
        }
        String defaultBranch = connectorConfiguration.getOptionValue("Default branch name");
        return GitUtils.cloneAndSetUpRepository(gitClonePath, location, credentialsProvider, ICancelable.neverCanceled(), defaultBranch);
    }
}

