/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket;

import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.common.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.TestGapVotingInfo;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

public class BitbucketUtils {
    private static final String TEAMSCALE_FINDINGS_BUILD_KEY = "teamscale-findings-build";
    public static final String TEAMSCALE_TEST_GAPS_BUILD_KEY = "teamscale-test-gaps-build";
    public static final String TEAMSCALE_TEST_COVERAGE_BUILD_KEY = "teamscale-test-coverage-build";
    public static final Set<String> TEAMSCALE_BUILD_KEYS = Set.of("teamscale-findings-build", "teamscale-test-gaps-build", "teamscale-test-coverage-build");

    public static CommitStatus createFindingsCommitStatus(int addedFindingsCountForVoting, String targetUrl) {
        CommitStatus status = new CommitStatus(TEAMSCALE_FINDINGS_BUILD_KEY, "Teamscale Findings");
        status.setUrl(targetUrl);
        if (addedFindingsCountForVoting != 0) {
            status.setState("FAILED");
            Object description = "This pull request would add " + addedFindingsCountForVoting + " new finding";
            description = StringUtils.pluralize((String)description, (int)addedFindingsCountForVoting);
            status.setDescription((String)description);
            return status;
        }
        status.setState("SUCCESSFUL");
        status.setDescription("No new findings");
        return status;
    }

    public static CommitStatus createTestGapCommitStatus(TestGapVotingInfo testGapVotingInfo, String targetUrl) {
        CommitStatus status = new CommitStatus(TEAMSCALE_TEST_GAPS_BUILD_KEY, "Teamscale Test Gaps");
        status.setUrl(targetUrl);
        status.setDescription(testGapVotingInfo.toReadableDescription());
        String state = testGapVotingInfo.numberOfTestGaps() > 0 ? "FAILED" : "SUCCESSFUL";
        status.setState(state);
        return status;
    }

    public static CommitStatus createTestCoverageCommitStatus(LineCoverageVotingInfo lineCoverageVotingInfo, String targetUrl) {
        CommitStatus status = new CommitStatus(TEAMSCALE_TEST_COVERAGE_BUILD_KEY, "Teamscale Test Coverage");
        status.setUrl(targetUrl);
        status.setDescription(lineCoverageVotingInfo.toReadableDescription());
        String state = lineCoverageVotingInfo.isCoverageAboveThreshold() ? "SUCCESSFUL" : "FAILED";
        status.setState(state);
        return status;
    }
}

