/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.bitbucket.cloud.client.BitbucketCloudClientHelper;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudWorkspace;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequest;
import java.time.Instant;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;

public class BitbucketCloudMergeRequestProvider
extends MergeRequestProvider<BitbucketCloudPullRequest, MergeRequestBuildJob> {
    private final BitbucketCloudClientHelper clientHelper;

    public BitbucketCloudMergeRequestProvider(BitbucketCloudClientHelper clientHelper) {
        super(null, null);
        this.clientHelper = clientHelper;
    }

    @Override
    public List<BitbucketCloudPullRequest> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        try {
            return this.clientHelper.getAllPullRequests();
        }
        catch (JsonSerializationException | StorageException e) {
            throw new ServiceCallException(e);
        }
    }

    @Override
    public @Nullable BitbucketCloudPullRequest getPlatformMergeRequest(long id) throws ServiceCallException {
        return this.clientHelper.getPullRequest(id);
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(final BitbucketCloudPullRequest pullRequest) {
        return new MergeRequestProvider.IMergeRequestAdapter(){

            @Override
            public MergeRequestIdentifier getIdentifier() {
                return new MergeRequestIdentifier(BitbucketCloudMergeRequestProvider.this.clientHelper.getRepositoryName(), pullRequest.getId());
            }

            @Override
            public EMergeRequestStatus getStatus() {
                return switch (pullRequest.getState()) {
                    case BitbucketCloudPullRequest.BitbucketCloudPullRequestStates.OPEN -> EMergeRequestStatus.OPEN;
                    case BitbucketCloudPullRequest.BitbucketCloudPullRequestStates.MERGED -> EMergeRequestStatus.MERGED;
                    default -> EMergeRequestStatus.OTHER;
                };
            }

            @Override
            public String getTitle() {
                return pullRequest.getTitle();
            }

            @Override
            public String getSourceBranch() {
                return pullRequest.getSourceBranchName();
            }

            @Override
            public String getCommit() throws ServiceCallException {
                return BitbucketCloudMergeRequestProvider.this.clientHelper.getFullCommitHash(pullRequest.getSourceCommitHash());
            }

            @Override
            public String getTargetBranch() {
                return pullRequest.getDestinationBranchName();
            }

            @Override
            public String getUrl() {
                return BitbucketCloudMergeRequestProvider.this.clientHelper.getPullRequestUrl(pullRequest.getId());
            }

            @Override
            public Long getCreatedAt() {
                return Instant.parse(pullRequest.getCreatedOn()).toEpochMilli();
            }

            @Override
            public Long getUpdatedAt() {
                return Instant.parse(pullRequest.getUpdatedOn()).toEpochMilli();
            }
        };
    }

    @Override
    protected boolean isCrossRepositoryMergeRequest(@NonNull BitbucketCloudPullRequest pullRequest) throws ServiceCallException {
        String[] pullRequestRepoParts;
        BitbucketCloudWorkspace workspace;
        String[] parts = this.clientHelper.getRepositoryName().split("/", 2);
        if (parts[0].startsWith("{") ? !(workspace = this.getOrFetchWorkspace(pullRequest.getSource().getRepository())).getUuid().equals(parts[0]) : !(pullRequestRepoParts = pullRequest.getSource().getRepository().getFullName().split("/", 2))[0].equals(parts[0])) {
            return true;
        }
        if (parts[1].startsWith("{")) {
            BitbucketCloudRepository repository = pullRequest.getSource().getRepository();
            return !repository.getUuid().equals(parts[1]);
        }
        pullRequestRepoParts = pullRequest.getSource().getRepository().getFullName().split("/", 2);
        return !pullRequestRepoParts[1].equals(parts[1]);
    }

    private BitbucketCloudWorkspace getOrFetchWorkspace(BitbucketCloudRepository repository) throws ServiceCallException {
        if (repository.getWorkspace() != null) {
            return repository.getWorkspace();
        }
        return this.clientHelper.getWorkspace(repository);
    }

    @Override
    public String getRepositoryName() {
        return this.clientHelper.getRepositoryName();
    }
}

