/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class PlatformRepositoryIdentifier {
    private final String owner;
    private final String repo;

    public PlatformRepositoryIdentifier(String owner, String repo) {
        this.owner = owner;
        this.repo = repo;
    }

    public static PlatformRepositoryIdentifier fromRepositoryName(String repositoryName) {
        String[] parts = repositoryName.split("/");
        CCSMAssert.isTrue((parts.length == 2 ? 1 : 0) != 0, () -> "Invalid repository name '" + repositoryName + "': not in the form '[^/]+/[^/]+'.");
        return new PlatformRepositoryIdentifier(parts[0], parts[1]);
    }

    public static <X extends Exception> PlatformRepositoryIdentifier fromRepositoryName(String repositoryName, Function<String, X> exceptionFactory) throws X {
        String[] parts = repositoryName.split("/");
        if (parts.length != 2) {
            throw (Exception)exceptionFactory.apply("Invalid repository name '" + repositoryName + "': Expected name cannot be empty and must contain exactly one slash.");
        }
        return new PlatformRepositoryIdentifier(parts[0], parts[1]);
    }

    public String asRepositoryName() {
        return this.owner + "/" + this.repo;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepo() {
        return this.repo;
    }

    public String toString() {
        return this.asRepositoryName();
    }
}

