/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.git.common.BuildCompletenessStatus;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.ExternalUploadsVotingCondition;
import com.teamscale.index.repository.git.common.VoteSupportingGitRepositoryConnectorDescriptorBase;
import com.teamscale.wia.WiaUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class VotingRequirementsChecker {
    private static final ListMap<String, Long> IGNORED_PULL_REQUESTS;
    private static final Logger LOGGER;
    private final SupplierWithException<VotingRecordIndex, StorageException> votingRecordIndex;
    private final SupplierWithException<BranchAnalysisStateIndex, StorageException> branchAnalysisStateIndex;
    private final SupplierWithException<CommitDescriptorIndex, StorageException> commitDescriptorIndex;
    private final FunctionWithException<CommitDescriptor, ExternalResultsPartitionLastUpdateIndex, StorageException> externalResultsPartitionLastUpdateIndexForCommit;
    private final SupplierWithException<RepositoryLogIndex, StorageException> repositoryLogIndex;
    private final SupplierWithException<Boolean, StorageException> isShadowModeEnabled;
    private final PublicProjectId publicProjectId;

    public VotingRequirementsChecker(PublicProjectId publicProjectId, GlobalStorageSystem globalStorage, ProjectStorageSystem projectStorage) {
        this.publicProjectId = publicProjectId;
        this.votingRecordIndex = SupplierWithException.memoize(() -> (VotingRecordIndex)projectStorage.openProjectIndex(VotingRecordIndex.class, null));
        this.branchAnalysisStateIndex = SupplierWithException.memoize(() -> (BranchAnalysisStateIndex)projectStorage.openProjectIndex(BranchAnalysisStateIndex.class, null));
        this.commitDescriptorIndex = SupplierWithException.memoize(() -> (CommitDescriptorIndex)projectStorage.openProjectIndex(CommitDescriptorIndex.class, null));
        this.externalResultsPartitionLastUpdateIndexForCommit = commit -> (ExternalResultsPartitionLastUpdateIndex)projectStorage.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        this.repositoryLogIndex = SupplierWithException.memoize(() -> (RepositoryLogIndex)projectStorage.openProjectIndex(RepositoryLogIndex.class, null));
        this.isShadowModeEnabled = () -> ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)globalStorage);
    }

    @VisibleForTesting
    static ListMap<String, Long> getIgnoredPullRequestsFromJvmFlags(@Nullable String jvmFlag) {
        if (StringUtils.isEmpty((String)jvmFlag)) {
            return ListMap.emptyMap();
        }
        try {
            ListMap ignoredPullRequestsByProject = new ListMap();
            ListMap rawMap = ListMap.of((String[])VotingRequirementsChecker.splitByCommasAndArrows(jvmFlag));
            for (String projectId : rawMap.getKeys()) {
                for (String pullRequestId : Objects.requireNonNull((List)rawMap.getCollection((Object)projectId))) {
                    ignoredPullRequestsByProject.add((Object)projectId.trim(), (Object)Long.parseLong(pullRequestId.trim()));
                }
            }
            return ignoredPullRequestsByProject;
        }
        catch (ArrayIndexOutOfBoundsException | AssertionError | NumberFormatException e) {
            LOGGER.atFatal().withThrowable((Throwable)e).log("Ignoring system property {} as the value does not conform to the specified format.", (Object)TeamscaleSystemProperties.IGNORED_PULL_REQUESTS.getName());
            return ListMap.emptyMap();
        }
    }

    private static String @NonNull [] splitByCommasAndArrows(@NonNull String jvmFlag) {
        return (String[])Arrays.stream(jvmFlag.split(",")).flatMap(segment -> Arrays.stream(segment.split("->")).map(String::trim)).toArray(String[]::new);
    }

    public void checkVotingRequirements(boolean forceNewVote, CommitDescriptor commit, MergeRequestIdentifier mergeRequestIdentifier, ConnectorConfiguration connector, @Nullable ParentedCommitDescriptor latestCommitForConnector, @Nullable BuildCompletenessStatus buildCompletenessStatus, @Nullable ExternalUploadsVotingCondition externalUploadsArePresentForVoting) throws VotingException.Skipped, StorageException {
        if (((Boolean)this.isShadowModeEnabled.get()).booleanValue()) {
            throw VotingException.Skipped.shadowModeEnabled(commit);
        }
        if (this.isPullRequestExcludedViaJvmFlags(mergeRequestIdentifier)) {
            throw VotingException.Skipped.excludedViaJvmFlag(mergeRequestIdentifier.id, commit);
        }
        if (!CcpIntegrationFeatureEnablements.isAnyIntegrationEnabled(connector)) {
            throw VotingException.Skipped.integrationDisabled(commit, connector);
        }
        if (((VotingRecordIndex)((Object)this.votingRecordIndex.get())).isMarkedAsSuccessfullyVoted(commit) && !this.isCommitNeedsNewVote(forceNewVote, commit, buildCompletenessStatus)) {
            throw VotingException.Skipped.alreadyVoted(commit);
        }
        if (buildCompletenessStatus != null && ((VotingRecordIndex)((Object)this.votingRecordIndex.get())).isMarkedSuccessfullyVotedWithIncompleteBuild(commit, buildCompletenessStatus.relevantBuildJobs()) && !buildCompletenessStatus.isBuildComplete()) {
            throw VotingException.Skipped.waitingForRelevantBuildJobs(commit);
        }
        if (!this.isVotingRelevantAnalysisState(commit)) {
            throw VotingException.Skipped.notYetAnalyzed(commit);
        }
        if (latestCommitForConnector != null && this.isCodeCommitForDifferentRepository(latestCommitForConnector, connector)) {
            throw VotingException.Skipped.commitIsFromOtherRepository(commit, connector);
        }
        if (externalUploadsArePresentForVoting != null && !externalUploadsArePresentForVoting.isFulfilledFor(connector)) {
            throw VotingException.Skipped.waitingForExternalUploads(commit);
        }
    }

    private boolean isPullRequestExcludedViaJvmFlags(MergeRequestIdentifier mergeRequestIdentifier) {
        return !IGNORED_PULL_REQUESTS.isEmpty() && ((List)IGNORED_PULL_REQUESTS.getCollectionOrEmpty((Object)this.publicProjectId.projectId)).contains(mergeRequestIdentifier.id);
    }

    public static boolean isCommitRelevantForVoting(CommitDescriptor commit) {
        return !WiaUtils.isWorkItemConnectorCommit((CommitDescriptor)commit) && !PreCommitUtils.isPrecommitCommit((CommitDescriptor)commit);
    }

    private boolean isCommitNeedsNewVote(boolean forceNewVote, CommitDescriptor schedulingCommit, BuildCompletenessStatus buildCompletenessStatus) throws StorageException {
        return forceNewVote || this.existingVoteDidNotVoteOnAllPartitions(schedulingCommit) || this.existingVoteDidNotIncludeAllBuildJobs(schedulingCommit, buildCompletenessStatus);
    }

    private boolean existingVoteDidNotIncludeAllBuildJobs(CommitDescriptor schedulingCommit, BuildCompletenessStatus buildCompletenessStatus) throws StorageException {
        if (buildCompletenessStatus == null) {
            return false;
        }
        return ((VotingRecordIndex)((Object)this.votingRecordIndex.get())).getVotingRecord(schedulingCommit).map(record -> !Objects.equals(record.getRelevantBuildJobs(), buildCompletenessStatus.relevantBuildJobs())).orElse(false);
    }

    private boolean existingVoteDidNotVoteOnAllPartitions(CommitDescriptor schedulingCommit) throws StorageException {
        return ((VotingRecordIndex)((Object)this.votingRecordIndex.get())).existingVoteDidNotVoteOnAllPartitions(schedulingCommit, ((ExternalResultsPartitionLastUpdateIndex)this.externalResultsPartitionLastUpdateIndexForCommit.apply((Object)schedulingCommit)).getPartitionsUpdatedWithCommit(schedulingCommit));
    }

    private boolean isCodeCommitForDifferentRepository(ParentedCommitDescriptor latestCommitForConnector, ConnectorConfiguration connector) throws StorageException {
        String sourceBranchName = latestCommitForConnector.getBranchName();
        Optional<CommitDescriptor> sourceCommit = ((CommitDescriptorIndex)this.commitDescriptorIndex.get()).getLatestCommitForBranch(sourceBranchName).map(CommitDescriptor::new);
        if (sourceCommit.isEmpty()) {
            return false;
        }
        RepositoryLogEntryAggregate logEntryOfSource = this.getLogEntryForCommitOrThrow(sourceCommit.get());
        boolean isCodeCommit = logEntryOfSource.getCommitTypes() != null && logEntryOfSource.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT);
        String repositoryIdOfProjectConnector = connector.getOptionValue("Repository identifier");
        return isCodeCommit && !logEntryOfSource.containsRepositoryIdentifier(repositoryIdOfProjectConnector);
    }

    private RepositoryLogEntryAggregate getLogEntryForCommitOrThrow(CommitDescriptor sourceCommit) throws StorageException {
        Optional actualCommit;
        RepositoryLogEntryAggregate logEntryOfSource = (RepositoryLogEntryAggregate)((RepositoryLogIndex)((Object)this.repositoryLogIndex.get())).getEntry(sourceCommit);
        if (logEntryOfSource == null && (actualCommit = ((CommitDescriptorIndex)this.commitDescriptorIndex.get()).getFirstActualCommitBeforeOrAt(sourceCommit, 0L)).isPresent()) {
            logEntryOfSource = (RepositoryLogEntryAggregate)((RepositoryLogIndex)((Object)this.repositoryLogIndex.get())).getEntry((CommitDescriptor)actualCommit.get());
        }
        if (logEntryOfSource == null) {
            AnalysisState analysisState = ((BranchAnalysisStateIndex)this.branchAnalysisStateIndex.get()).getAnalysisState(sourceCommit.getBranchName());
            if (analysisState != null) {
                LOGGER.error("Repository log entry of the latest commit '{}' (according to the CommitDescriptorIndex) could not be found for branch '{}'. The branch analysis state for this branch is: '{}'.", (Object)sourceCommit, (Object)sourceCommit.getBranchName(), (Object)analysisState);
            }
            throw new StorageException("Source commit " + String.valueOf(sourceCommit) + " was not found in repository log index.");
        }
        return logEntryOfSource;
    }

    private boolean isVotingRelevantAnalysisState(CommitDescriptor schedulingCommit) throws StorageException {
        AnalysisState analysisState = ((BranchAnalysisStateIndex)this.branchAnalysisStateIndex.get()).getAnalysisState(schedulingCommit.getBranchName());
        LOGGER.debug("Analysis state for commit '" + String.valueOf(schedulingCommit) + "' is '" + String.valueOf(analysisState) + "'.");
        return analysisState != null && VoteSupportingGitRepositoryConnectorDescriptorBase.VOTING_OR_COMMENTING_RELEVANT_STATES.contains(analysisState.getState());
    }

    static {
        LOGGER = LogManager.getLogger();
        IGNORED_PULL_REQUESTS = VotingRequirementsChecker.getIgnoredPullRequestsFromJvmFlags((String)TeamscaleSystemProperties.IGNORED_PULL_REQUESTS.getValue());
    }
}

