/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestAnnotationUtils;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.gitea.GiteaClient;
import com.teamscale.index.repository.git.gitea.GiteaMergeRequestProvider;
import com.teamscale.index.repository.git.gitea.data.GiteaChangedFile;
import com.teamscale.index.repository.git.gitea.data.GiteaCommitStatusCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaIssueComment;
import com.teamscale.index.repository.git.gitea.data.GiteaIssueCommentCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequest;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestPatch;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReview;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReviewComment;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReviewCommentCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReviewCreate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class GiteaMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<GiteaPullRequest, MergeRequestBuildJob> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MARKER_START = "<!-- Teamscale begin -->";
    private static final String MARKER_END = "<!-- Teamscale end -->";
    private static final String COMMIT_STATUS_SUCCESS = "success";
    private static final String COMMIT_STATUS_ERROR = "error";
    private GiteaClient client;
    private PlatformRepositoryIdentifier repositoryIdentifier;
    private boolean isFindingsLineCommentLimitExceeded;
    private boolean isTestGapLineCommentLimitExceeded;

    public GiteaMergeRequestAnnotationTrigger() {
    }

    @VisibleForTesting
    protected GiteaMergeRequestAnnotationTrigger(GiteaClient client, PlatformRepositoryIdentifier repositoryIdentifier) {
        this.client = client;
        this.repositoryIdentifier = repositoryIdentifier;
    }

    @Override
    protected MergeRequestProvider<GiteaPullRequest, MergeRequestBuildJob> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        ExternalCredentials credentials = MergeRequestUpdateTriggerBase.extractCredentials(schedulingParameters.connector(), this.indexLayer.openGlobalStorageSystem());
        this.client = new GiteaClient(credentials.uri, credentials.username, credentials.password, LOGGER);
        String repositoryName = GiteaMergeRequestAnnotationTrigger.getRepositoryName(schedulingParameters.connector());
        this.repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(repositoryName);
        this.isFindingsLineCommentLimitExceeded = false;
        this.isTestGapLineCommentLimitExceeded = false;
        return new GiteaMergeRequestProvider(repositoryName, this.client);
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) throws ServiceCallException, StorageException {
        long pullRequestNumber = input.mergeRequest.getId();
        GiteaPullRequest pullRequest = this.client.getPullRequest(this.repositoryIdentifier, pullRequestNumber);
        String newDescription = MergeRequestAnnotationUtils.compileDescriptionWithLimitCommentWarning(commentLimitWarningExceededMessage, pullRequest.body(), MARKER_START, MARKER_END, commentLimitWarningFormat);
        try {
            this.updatePullRequestDescription(pullRequest.number(), newDescription);
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 403) {
                LOGGER.warn("Failed to add warning about too many line comments to description of pull request {} in repo '{}' due to permission error. Trying to add the warning as review to the pull request.", (Object)pullRequestNumber, (Object)this.repositoryIdentifier.asRepositoryName(), (Object)e);
                this.addLineCommentLimitWarningAsReview(pullRequestNumber, commentLimitWarningExceededMessage);
            }
            throw e;
        }
    }

    @VisibleForTesting
    protected void addLineCommentLimitWarningAsReview(long pullRequestNumber, String commentLimitWarningExceededMessage) throws ServiceCallException {
        String message = "<!-- Teamscale begin -->\n\n" + commentLimitWarningExceededMessage + "\n\n<!-- Teamscale end -->";
        GiteaPullRequestReviewCreate commentLimitWarningReview = new GiteaPullRequestReviewCreate(message);
        this.client.createPullRequestReview(this.repositoryIdentifier, pullRequestNumber, commentLimitWarningReview);
    }

    private void updatePullRequestDescription(long pullRequestNumber, String newDescription) throws ServiceCallException {
        this.client.updatePullRequest(this.repositoryIdentifier, pullRequestNumber, new GiteaPullRequestPatch(newDescription));
    }

    @Override
    protected Set<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.INLINE_COMMENTS);
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException, ExecutionCanceledException {
        this.deleteTeamscaleReviews(input.mergeRequest.getId());
        this.isFindingsLineCommentLimitExceeded = true;
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        if (!this.isFindingsLineCommentLimitExceeded) {
            this.deleteTeamscaleReviews(input.mergeRequest.getId());
        }
        this.isTestGapLineCommentLimitExceeded = true;
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) throws StorageException, ServiceCallException {
        long pullRequestNumber = input.mergeRequest.getId();
        if (!this.isFindingsLineCommentLimitExceeded && !this.isTestGapLineCommentLimitExceeded) {
            this.deleteTeamscaleReviews(pullRequestNumber);
        }
        this.createGiteaReviewForComments(pullRequestNumber, reviewComments);
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        int pullRequestId = (int)input.mergeRequest.getId();
        List<GiteaIssueComment> issueComments = this.client.getIssueComments(this.repositoryIdentifier, pullRequestId);
        List existingAggregatedTeamscaleComments = CollectionUtils.filter(issueComments, comment -> CcpCommentUtils.isTeamscaleTestGapSummaryComment(comment.body()));
        for (GiteaIssueComment comment2 : existingAggregatedTeamscaleComments) {
            this.client.deleteIssueComment(this.repositoryIdentifier, pullRequestId, comment2.id());
        }
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws ServiceCallException {
        this.client.postIssueComment(this.repositoryIdentifier, (int)pullRequestId, new GiteaIssueCommentCreate(commentContent));
    }

    private void createGiteaReviewForComments(long pullRequestNumber, List<IReviewComment> reviewComments) throws ServiceCallException {
        Set changedFilePaths = this.client.getPullRequestChangedFiles(this.repositoryIdentifier, pullRequestNumber).stream().map(GiteaChangedFile::filename).collect(Collectors.toSet());
        Map<String, List<IReviewComment>> pathToReviewComments = reviewComments.stream().filter(comment -> changedFilePaths.contains(comment.getLocation().getUniformPath())).collect(Collectors.groupingBy(comment -> comment.getLocation().getUniformPath()));
        if (pathToReviewComments.isEmpty()) {
            return;
        }
        ArrayList<GiteaPullRequestReviewCommentCreate> giteaComments = new ArrayList<GiteaPullRequestReviewCommentCreate>();
        pathToReviewComments.forEach((path, comments) -> giteaComments.addAll(GiteaMergeRequestAnnotationTrigger.createGiteaCommentsForPath(path, comments)));
        GiteaPullRequestReviewCreate giteaReview = new GiteaPullRequestReviewCreate(giteaComments);
        this.client.createPullRequestReview(this.repositoryIdentifier, pullRequestNumber, giteaReview);
    }

    private static List<GiteaPullRequestReviewCommentCreate> createGiteaCommentsForPath(String path, List<IReviewComment> reviewComments) {
        Map<Integer, List<IReviewComment>> lineToReviewComments = reviewComments.stream().collect(Collectors.groupingBy(IReviewComment::getStartLine));
        ArrayList<GiteaPullRequestReviewCommentCreate> giteaComments = new ArrayList<GiteaPullRequestReviewCommentCreate>();
        lineToReviewComments.forEach((lineNumber, lineComments) -> giteaComments.add(GiteaMergeRequestAnnotationTrigger.createGiteaComment(path, lineNumber, lineComments)));
        return giteaComments;
    }

    private static GiteaPullRequestReviewCommentCreate createGiteaComment(String path, int line, List<IReviewComment> reviewComments) {
        String commentText = CcpCommentUtils.createInlineCommentMarkdownContent(reviewComments, line);
        return new GiteaPullRequestReviewCommentCreate(commentText, path, line);
    }

    private void deleteTeamscaleReviews(long pullRequestNumber) throws ServiceCallException {
        List<Integer> reviewsToBeDeleted = this.getTeamscaleReviews(pullRequestNumber);
        if (reviewsToBeDeleted.size() > 1) {
            LOGGER.warn("Expected at most 1 existing Teamscale review but got {} for pull request {} in repo '{}'.", (Object)reviewsToBeDeleted.size(), (Object)pullRequestNumber, (Object)this.repositoryIdentifier.asRepositoryName());
        }
        for (int reviewId : reviewsToBeDeleted) {
            this.client.deletePullRequestReview(this.repositoryIdentifier, pullRequestNumber, reviewId);
        }
    }

    @VisibleForTesting
    protected List<Integer> getTeamscaleReviews(long pullRequestNumber) throws ServiceCallException {
        List<GiteaPullRequestReview> reviews = this.client.getPullRequestReviews(this.repositoryIdentifier, pullRequestNumber);
        ArrayList<Integer> teamscaleReviews = new ArrayList<Integer>();
        for (GiteaPullRequestReview review : reviews) {
            if (!review.body().contains(MARKER_START) && !this.hasTeamscaleComment(pullRequestNumber, review.id())) continue;
            teamscaleReviews.add(review.id());
        }
        return teamscaleReviews;
    }

    private boolean hasTeamscaleComment(long pullRequestNumber, int reviewId) throws ServiceCallException {
        List<GiteaPullRequestReviewComment> commentsInReview = this.client.getPullRequestReviewComments(this.repositoryIdentifier, pullRequestNumber, reviewId);
        return commentsInReview.stream().anyMatch(comment -> CcpCommentUtils.isTeamscaleComment(comment.body()));
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) throws StorageException, ServiceCallException {
        GiteaPullRequest pullRequest = this.client.getPullRequest(this.repositoryIdentifier, input.mergeRequest.getId());
        MergeRequestAnnotationUtils.updateDescription(pullRequest.body(), badgeAsMarkdown, MARKER_START, MARKER_END, GiteaMergeRequestAnnotationTrigger.isBadgeSetToTopPosition(schedulingParams.connector()), (ConsumerWithTwoExceptions<String, ServiceCallException, StorageException>)((ConsumerWithTwoExceptions)newDescription -> this.updatePullRequestDescription(pullRequest.number(), (String)newDescription)));
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, ServiceCallException {
        return this.postCommitStatus(schedulingParams, input);
    }

    private VotingRecord.EVotingState postCommitStatus(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        GiteaCommitStatusCreate commitStatus = GiteaMergeRequestAnnotationTrigger.createCommitStatus(input.getAddedFindingsForVoting().size(), input.createMergeRequestDetailsLink(schedulingParams.linkProvider()));
        this.client.postCommitStatus(this.repositoryIdentifier, input.mergeRequest.sourceHead, commitStatus);
        if (commitStatus.state().equals(COMMIT_STATUS_SUCCESS)) {
            return VotingRecord.EVotingState.VOTED_POSITIVE;
        }
        return VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    private static GiteaCommitStatusCreate createCommitStatus(int addedFindingsCount, String targetUrl) {
        Object description;
        String state;
        if (addedFindingsCount == 0) {
            state = COMMIT_STATUS_SUCCESS;
            description = "No new findings";
        } else {
            state = COMMIT_STATUS_ERROR;
            description = "This pull request would introduce " + addedFindingsCount + " new finding";
            description = StringUtils.pluralize((String)description, (int)addedFindingsCount);
        }
        return new GiteaCommitStatusCreate("Teamscale", (String)description, state, targetUrl);
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.GITEA;
    }

    @Override
    @VisibleForTesting
    protected VotingRecord.EVotingState performVoting(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        return super.performVoting(schedulingParams, input);
    }
}

