/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.gitea.GiteaClient;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequest;
import java.time.Instant;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.MergeRequestIdentifier;

public class GiteaMergeRequestProvider
extends MergeRequestProvider<GiteaPullRequest, MergeRequestBuildJob> {
    private final PlatformRepositoryIdentifier repositoryIdentifier;
    private final GiteaClient client;

    public GiteaMergeRequestProvider(String repositoryName, GiteaClient client) {
        super(null, null);
        this.repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(repositoryName);
        this.client = client;
    }

    @Override
    public @Nullable GiteaPullRequest getPlatformMergeRequest(long id) throws ServiceCallException {
        return this.client.getPullRequest(this.repositoryIdentifier, id);
    }

    @Override
    protected List<GiteaPullRequest> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        return this.client.getOpenPullRequests(this.repositoryIdentifier);
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(GiteaPullRequest giteaPullRequest) {
        return new GiteaMergeRequestAdapter(giteaPullRequest);
    }

    @Override
    protected boolean isCrossRepositoryMergeRequest(@NonNull GiteaPullRequest giteaPullRequest) throws ServiceCallException {
        return !giteaPullRequest.sourceBranchInfo().repo().fullName().equals(giteaPullRequest.targetBranchInfo().repo().fullName());
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryIdentifier.asRepositoryName();
    }

    private class GiteaMergeRequestAdapter
    implements MergeRequestProvider.IMergeRequestAdapter {
        private final GiteaPullRequest giteaPullRequest;
        private static final String STATUS_OPEN = "open";

        private GiteaMergeRequestAdapter(GiteaPullRequest pullRequest) {
            this.giteaPullRequest = pullRequest;
        }

        @Override
        public MergeRequestIdentifier getIdentifier() {
            return new MergeRequestIdentifier(GiteaMergeRequestProvider.this.repositoryIdentifier.asRepositoryName(), this.giteaPullRequest.number());
        }

        @Override
        public EMergeRequestStatus getStatus() {
            if (this.giteaPullRequest.state().equals(STATUS_OPEN)) {
                return EMergeRequestStatus.OPEN;
            }
            if (this.giteaPullRequest.merged()) {
                return EMergeRequestStatus.MERGED;
            }
            return EMergeRequestStatus.OTHER;
        }

        @Override
        public String getTitle() {
            return this.giteaPullRequest.title();
        }

        @Override
        public String getSourceBranch() {
            return this.giteaPullRequest.sourceBranchInfo().ref();
        }

        @Override
        public String getCommit() {
            return this.giteaPullRequest.sourceBranchInfo().sha();
        }

        @Override
        public String getTargetBranch() {
            return this.giteaPullRequest.targetBranchInfo().ref();
        }

        @Override
        public String getUrl() {
            return this.giteaPullRequest.url();
        }

        @Override
        public Long getCreatedAt() {
            return Instant.parse(this.giteaPullRequest.createdAt()).toEpochMilli();
        }

        @Override
        public Long getUpdatedAt() {
            return Instant.parse(this.giteaPullRequest.updatedAt()).toEpochMilli();
        }
    }
}

