/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.google.common.base.Preconditions;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.AppBasedGitRepositoryDataRetriever;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.AppBasedGithubConnectorValidationUtils;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.net.UrlUtils;

public final class GitHubDataRetriever
extends AppBasedGitRepositoryDataRetriever<String> {
    private final @NonNull GitHubInstallationIndex gitHubInstallationIndex;
    private final @NonNull Logger logger;
    private @Nullable GitHubApplicationDescription applicationDescription;

    public GitHubDataRetriever(@NonNull GitHubInstallationIndex gitHubInstallationIndex, @NonNull AccessTokenIndex accessTokenIndex, @NonNull ServerOptionIndex serverOptionIndex, @NonNull Logger logger, @Nullable ProjectConfiguration projectConfiguration, @Nullable ConnectorConfiguration connectorConfiguration, @Nullable String username) {
        super(serverOptionIndex, accessTokenIndex, projectConfiguration, connectorConfiguration, username);
        this.gitHubInstallationIndex = gitHubInstallationIndex;
        this.logger = logger;
    }

    public GitHubDataRetriever(GlobalStorageSystem globalStorage, Logger logger) throws StorageException {
        this((GitHubInstallationIndex)globalStorage.openGlobalIndex(GitHubInstallationIndex.class), (AccessTokenIndex)globalStorage.openGlobalIndex(AccessTokenIndex.class), (ServerOptionIndex)globalStorage.openGlobalIndex(ServerOptionIndex.class), logger, null, null, null);
    }

    @Override
    protected URI getRepositoryUri(String repositoryName, ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException, RepositoryException {
        String gitHubServerUrl = connectorConfiguration.getOptionValue("GitHub Server URL");
        GitHubAppBasedRepositoryAccessHelper<ProjectConfigurationException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<ProjectConfigurationException>(gitHubServerUrl, repositoryName, this.gitHubInstallationIndex, this.getServerOptionIndex(), this.getAccessTokenIndex(), ProjectConfigurationException::new, this.logger);
        try {
            return UrlUtils.parseUri((String)repositoryAccessHelper.getRepositoryCloneUrl());
        }
        catch (ServiceCallException | URISyntaxException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    protected void checkUserIsCollaborator(String username, String repositoryName) throws ProjectConfigurationException {
        Preconditions.checkState((this.applicationDescription != null ? 1 : 0) != 0, (Object)"Data retriever was not initialized correctly.");
        if (this.applicationDescription.skipCollaboratorCheck) {
            return;
        }
        AppBasedGithubConnectorValidationUtils.checkUserIsCollaborator(this.applicationDescription, (String)this.getInstallation(), PlatformRepositoryIdentifier.fromRepositoryName(repositoryName, ProjectConfigurationException::new), username, this.logger);
    }

    @Override
    protected String init(String repositoryName, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        String gitHubServerUrl = connectorConfiguration.getOptionValue("GitHub Server URL");
        GitHubAppBasedRepositoryAccessHelper<ProjectConfigurationException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<ProjectConfigurationException>(gitHubServerUrl, repositoryName, this.gitHubInstallationIndex, this.getServerOptionIndex(), this.getAccessTokenIndex(), ProjectConfigurationException::new, this.logger);
        try {
            this.applicationDescription = repositoryAccessHelper.getApplicationDescription();
            return repositoryAccessHelper.getInstallationAccessToken();
        }
        catch (ServiceCallException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    protected Pair<String, String> getConnectorUsernameAndPassword() {
        return new Pair((Object)"x-access-token", (Object)((String)this.getInstallation()));
    }

    @Override
    protected ExternalCredentials createExternalCredentials(URI repositoryUri) {
        return new ExternalCredentials("Dummy Credentials", repositoryUri.toString(), "x-access-token", (String)this.getInstallation());
    }
}

