/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunEntry;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunIndex;
import com.teamscale.index.repository.git.in_progress_reporting.AnalysisInProgressReporter;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;

public class GitHubPendingCheckRunReporter
extends AnalysisInProgressReporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ANALYSIS_IN_PROGRESS_MESSAGE = "Teamscale analysis is in progress.";
    private final SupplierWithException<GitHubPullRequestClient, ServiceCallException> client = SupplierWithException.memoize(() -> {
        try {
            return new GitHubAppBasedRepositoryAccessHelper<StorageException>(this.getGitHubConnectorDescriptor().getGitHubServerUrl().url(), repositoryIdentifier.asRepositoryName(), this.getGlobalStorage(), StorageException::new, LOGGER).createGitHubPullRequestClient();
        }
        catch (StorageException e) {
            throw new ServiceCallException((Throwable)e);
        }
    });

    public GitHubPendingCheckRunReporter(IndexLayer indexLayer, PlatformRepositoryIdentifier repositoryIdentifier) throws StorageException, ProjectConfigurationException {
        super(repositoryIdentifier, indexLayer, GitHubRepositoryConnectorDescriptor.class, LOGGER);
    }

    @Override
    protected void postAnalysisInProgressReport(String revision, CommitDescriptor commit, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException, ServiceCallException {
        GitHubCheckRunIndex checkRunIndex = (GitHubCheckRunIndex)this.getProjectStorage().openProjectIndex(GitHubCheckRunIndex.class, null);
        this.closeOutdatedCheckRuns(checkRunIndex, commit);
        if (!EFeatureToggle.ENABLE_MERGE_REQUEST_ANALYSIS_IN_PROGRESS_NOTIFICATION.isEnabled()) {
            return;
        }
        LOGGER.debug("Posting \"In Progress\" findings check run for commit '{}'", (Object)commit);
        this.postInProgressCheckRun(ECheckRunType.FINDINGS, revision, mergeRequestIdentifier, commit, checkRunIndex);
        if (CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(this.getConnectorConfiguration())) {
            LOGGER.debug("Posting \"In Progress\" test gap check run for commit '{}'", (Object)commit);
            this.postInProgressCheckRun(ECheckRunType.TEST_GAPS, revision, mergeRequestIdentifier, commit, checkRunIndex);
        }
        if (CcpIntegrationFeatureEnablements.isVotingForTestCoverageEnabled(this.getConnectorConfiguration())) {
            LOGGER.debug("Posting \"In Progress\" test coverage check run for commit '{}'", (Object)commit);
            this.postInProgressCheckRun(ECheckRunType.TEST_COVERAGE, revision, mergeRequestIdentifier, commit, checkRunIndex);
        }
    }

    private void postInProgressCheckRun(ECheckRunType type, String revision, MergeRequestIdentifier mergeRequestIdentifier, CommitDescriptor commit, GitHubCheckRunIndex gitHubCheckRunIndex) throws StorageException, ServiceCallException {
        Optional<Long> existingId = gitHubCheckRunIndex.readId(commit, type);
        if (existingId.isPresent()) {
            return;
        }
        CheckRun checkRun = this.createCheckRunInProgress(type, revision, mergeRequestIdentifier);
        Long checkRunId = this.postCheckRun(checkRun, mergeRequestIdentifier);
        gitHubCheckRunIndex.storeId(commit, type, checkRunId);
    }

    @Override
    protected ExternalCredentials getExternalCredentials() throws StorageException, ServiceCallException, ConnectorValidationException {
        GitHubRepositoryConnectorDescriptor connectorDescriptor = this.getGitHubConnectorDescriptor();
        GitHubAppBasedRepositoryAccessHelper<StorageException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<StorageException>(connectorDescriptor.getGitHubServerUrl().url(), connectorDescriptor.getRepositoryName(), this.getGlobalStorage(), message -> new StorageException("Failed to get installation token."), LOGGER);
        return new ExternalCredentials("GitHub Credentials", connectorDescriptor.getRepositoryUri().toString(), "x-access-token", repositoryAccessHelper.getInstallationAccessToken());
    }

    private CheckRun createCheckRunInProgress(ECheckRunType type, String sourceHead, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        GitHubRepositoryConnectorDescriptor connectorDescriptor = this.getGitHubConnectorDescriptor();
        @Nullable String input = connectorDescriptor.getContextIdentifier();
        return CheckRun.builder(type, StringUtils.isEmptyOrElse((String)input, (String)"Teamscale"), sourceHead, this.getLinkProvider().createMergeRequestDetailsLink(mergeRequestIdentifier)).withOutputTitle(ANALYSIS_IN_PROGRESS_MESSAGE).setInProgress().build();
    }

    private Long postCheckRun(CheckRun checkRun, MergeRequestIdentifier mergeRequestIdentifier) throws ServiceCallException {
        return ((GitHubPullRequestClient)((Object)this.client.get())).createCheckRun(PlatformRepositoryIdentifier.fromRepositoryName(mergeRequestIdentifier.repositoryName), checkRun);
    }

    private void closeOutdatedCheckRuns(GitHubCheckRunIndex gitHubCheckRunIndex, CommitDescriptor webHookCommit) throws StorageException, ServiceCallException {
        for (GitHubCheckRunEntry checkRunEntry : gitHubCheckRunIndex.readIdsForBranch(webHookCommit.getBranchName())) {
            CommitDescriptor checkRunCommit = checkRunEntry.getCommit();
            long checkRunId = checkRunEntry.getCheckRunId();
            if (webHookCommit.getTimestamp() <= checkRunCommit.getTimestamp()) {
                LOGGER.debug("Keeping check run '{}', because its commit '{}' is more recent than the received webhook commit '{}'.", (Object)checkRunId, (Object)checkRunCommit, (Object)webHookCommit);
                continue;
            }
            PlatformRepositoryIdentifier repositoryId = PlatformRepositoryIdentifier.fromRepositoryName(this.getConnectorDescriptor().getRepositoryName());
            Optional<CheckRun> existingCheckRun = ((GitHubPullRequestClient)((Object)this.client.get())).getCheckRunById(repositoryId, checkRunId);
            if (existingCheckRun.isPresent() && ((GitHubPullRequestClient)((Object)this.client.get())).closeCheckRun(existingCheckRun.get(), repositoryId, "Skipped because a newer commit was found on the source branch.")) {
                gitHubCheckRunIndex.removeCheckRun(checkRunCommit, checkRunEntry.getCheckRunType());
                continue;
            }
            LOGGER.debug("Could not fetch existing check run found for ID '{}'. Retrying next time.", (Object)checkRunId);
        }
    }

    private GitHubRepositoryConnectorDescriptor getGitHubConnectorDescriptor() {
        return (GitHubRepositoryConnectorDescriptor)this.getConnectorDescriptor();
    }
}

