/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import java.net.URI;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;

final class GitLabGitUtils {
    public static URI getRepositoryUri(ConnectorConfiguration connectorConfiguration, ExternalCredentials credentials, Logger interactionLogger) throws RepositoryException {
        String repositoryName = connectorConfiguration.getOptionValue("Repository name");
        GitLabClient client = new GitLabClient(credentials.uri, credentials.password, interactionLogger);
        try {
            return client.getProject(repositoryName).getHttpUriToRepo();
        }
        catch (ServiceCallException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private GitLabGitUtils() {
        throw new UnsupportedOperationException("Avoid instantiation of util class.");
    }
}

