/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestAnnotationUtils;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.merge_request.comments.ReviewCommentResolutionReasonProvider;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestProvider;
import com.teamscale.index.repository.git.gitlab.GitLabNoteBuilder;
import com.teamscale.index.repository.git.gitlab.GitLabUtils;
import com.teamscale.index.repository.git.gitlab.data.GitLabCommitStatus;
import com.teamscale.index.repository.git.gitlab.data.GitLabDiscussion;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import com.teamscale.index.repository.git.gitlab.data.GitLabNote;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jetbrains.annotations.VisibleForTesting;

public class GitLabMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<GitLabMergeRequest, GitLabCommitStatus> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MARKER_START = "<!-- Teamscale begin -->";
    private static final String MARKER_END = "<!-- Teamscale end -->";
    private static final String GITLAB_GHOST_USER_PREFIX = "ghost";
    private GitLabClient client;

    @Override
    protected MergeRequestProvider<GitLabMergeRequest, GitLabCommitStatus> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        ExternalCredentials credentials = MergeRequestUpdateTriggerBase.extractCredentials(schedulingParameters.connector(), this.indexLayer.openGlobalStorageSystem());
        this.client = new GitLabClient(credentials.uri, credentials.password, LOGGER);
        return new GitLabMergeRequestProvider(GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParameters.connector()), this.client, VotingConnectorUtils.getBuildIncludeExcludePatterns(schedulingParameters.connector()));
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, ExecutionCanceledException, StorageException {
        this.deleteInlineCommentsAfterLimitExceeded(schedulingParams, input, discussion -> CcpCommentUtils.isTeamscaleFindingsComment(discussion.getFirstNoteBody()));
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException, ExecutionCanceledException {
        this.deleteInlineCommentsAfterLimitExceeded(schedulingParams, input, discussion -> CcpCommentUtils.isMarkdownTeamscaleTestGapComment(discussion.getFirstNoteBody()));
    }

    private void deleteInlineCommentsAfterLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, Predicate<GitLabDiscussion> filterPredicate) throws ServiceCallException {
        String repositoryName = GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParams.connector());
        GitLabUtils.MergeRequestSpecificGitLabClient helperClient = new GitLabUtils.MergeRequestSpecificGitLabClient(this.client, GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParams.connector()), input.mergeRequest.getId());
        GitLabMergeRequest gitLabMergeRequest = this.client.getMergeRequest(repositoryName, input.mergeRequest.getId());
        for (GitLabDiscussion existingDiscussion : GitLabMergeRequestAnnotationTrigger.filterNonTeamscaleDiscussions(helperClient.listOpenOrResolvedMergeRequestDiscussions(), filterPredicate)) {
            if (GitLabMergeRequestAnnotationTrigger.discussionShouldNotBeDeleted(existingDiscussion)) continue;
            try {
                this.client.deleteMergeRequestNote(repositoryName, gitLabMergeRequest.id(), existingDiscussion.getFirstNoteId());
            }
            catch (ServiceCallException e) {
                LOGGER.error("Failed to delete Merge Request comment " + existingDiscussion.getFirstNoteId() + " for Merge Request " + gitLabMergeRequest.id() + " (" + e.getStatusCode() + " - " + e.getStatusMessage() + ")");
            }
        }
    }

    private static boolean discussionShouldNotBeDeleted(GitLabDiscussion discussion) {
        return discussion.isResolved() || discussion.getNotes().size() != 1 && !GitLabMergeRequestAnnotationTrigger.repliesOnlyByTeamscaleOrSystemNotes(discussion.getNotes());
    }

    private static boolean repliesOnlyByTeamscaleOrSystemNotes(List<GitLabNote> notes) {
        String authorOfOriginalComment = notes.getFirst().getUsername();
        return notes.stream().allMatch(note -> note.isSystemNote() || note.getUsername().equals(authorOfOriginalComment));
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) throws ServiceCallException {
        String repositoryName = GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParams.connector());
        GitLabMergeRequest gitLabMergeRequest = this.client.getMergeRequest(repositoryName, input.mergeRequest.getId());
        String newDescription = MergeRequestAnnotationUtils.compileDescriptionWithLimitCommentWarning(commentLimitWarningExceededMessage, gitLabMergeRequest.description(), MARKER_START, MARKER_END, commentLimitWarningFormat);
        this.client.updateMergeRequestDescription(repositoryName, gitLabMergeRequest.id(), newDescription);
    }

    protected EnumSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.INLINE_COMMENTS);
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) throws ServiceCallException, StorageException {
        String repositoryName = GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParams.connector());
        GitLabMergeRequest gitLabMergeRequest = this.client.getMergeRequest(repositoryName, input.mergeRequest.getId());
        MergeRequestAnnotationUtils.updateDescription(gitLabMergeRequest.description(), badgeAsMarkdown, MARKER_START, MARKER_END, GitLabMergeRequestAnnotationTrigger.isBadgeSetToTopPosition(schedulingParams.connector()), (ConsumerWithTwoExceptions<String, ServiceCallException, StorageException>)((ConsumerWithTwoExceptions)newDescription -> this.client.updateMergeRequestDescription(repositoryName, gitLabMergeRequest.id(), (String)newDescription)));
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        return VotingRecord.EVotingState.VOTING_DISABLED;
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) throws ServiceCallException {
        GitLabUtils.MergeRequestSpecificGitLabClient helperClient = new GitLabUtils.MergeRequestSpecificGitLabClient(this.client, GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParams.connector()), input.mergeRequest.getId());
        this.updateDiscussions(reviewComments, helperClient, input.sourceCommit);
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        GitLabUtils.MergeRequestSpecificGitLabClient helperClient = new GitLabUtils.MergeRequestSpecificGitLabClient(this.client, GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParams.connector()), input.mergeRequest.getId());
        List<GitLabDiscussion> existingDiscussions = helperClient.listOpenOrResolvedMergeRequestDiscussions();
        List aggregatedTeamscaleComments = CollectionUtils.filter(existingDiscussions, discussion -> CcpCommentUtils.isTeamscaleTestGapSummaryComment(discussion.getFirstNoteBody()));
        for (GitLabDiscussion existingAggregatedComment : aggregatedTeamscaleComments) {
            if (GitLabMergeRequestAnnotationTrigger.discussionShouldNotBeDeleted(existingAggregatedComment)) continue;
            helperClient.deleteMergeRequestNote(existingAggregatedComment.getFirstNoteId());
        }
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws ServiceCallException, IOException {
        GitLabUtils.MergeRequestSpecificGitLabClient helperClient = new GitLabUtils.MergeRequestSpecificGitLabClient(this.client, GitLabMergeRequestAnnotationTrigger.getRepositoryName(schedulingParams.connector()), pullRequestId);
        helperClient.createMergeRequestDiscussion(new GitLabNote(commentContent));
    }

    private void updateDiscussions(List<IReviewComment> reviewComments, GitLabUtils.MergeRequestSpecificGitLabClient helperClient, CommitDescriptor sourceCommit) throws ServiceCallException {
        HashMap<String, GitLabDiscussion> existingDiscussionsByFindingId = new HashMap<String, GitLabDiscussion>();
        HashMap<String, GitLabDiscussion> normalisedExistingTestGapComments = new HashMap<String, GitLabDiscussion>();
        List<GitLabDiscussion> existingDiscussions = helperClient.listOpenOrResolvedMergeRequestDiscussions();
        for (GitLabDiscussion discussion : GitLabMergeRequestAnnotationTrigger.filterNonTeamscaleDiscussions(existingDiscussions)) {
            Optional<String> findingsId = CcpCommentUtils.extractFindingIdFromComment(discussion.getFirstNoteBody());
            findingsId.ifPresent(id -> existingDiscussionsByFindingId.put((String)id, discussion));
            if (findingsId.isPresent()) continue;
            Optional<String> normalizedTestGapComment = CcpCommentUtils.extractNormalizedTestGapComment(discussion.getFirstNoteBody());
            normalizedTestGapComment.ifPresent(comment -> normalisedExistingTestGapComments.put((String)comment, discussion));
        }
        for (GitLabNote note : this.buildNewComments(reviewComments, helperClient)) {
            GitLabMergeRequestAnnotationTrigger.updateOrCreateMergeRequestDiscussion(helperClient, existingDiscussionsByFindingId, normalisedExistingTestGapComments, note);
        }
        this.resolveMergeRequestDiscussions(helperClient, existingDiscussionsByFindingId, sourceCommit);
        for (GitLabDiscussion discussion : normalisedExistingTestGapComments.values()) {
            helperClient.deleteMergeRequestNote(discussion.getFirstNoteId());
        }
    }

    private void resolveMergeRequestDiscussions(GitLabUtils.MergeRequestSpecificGitLabClient helperClient, Map<String, GitLabDiscussion> existingDiscussions, CommitDescriptor sourceCommit) {
        try {
            ReviewCommentResolutionReasonProvider commentResolutionProvider = new ReviewCommentResolutionReasonProvider(this.createReviewCommentResolutionReasonParameters(sourceCommit));
            for (String findingId : existingDiscussions.keySet()) {
                GitLabMergeRequestAnnotationTrigger.resolveMergeRequestDiscussion(helperClient, existingDiscussions, findingId, commentResolutionProvider);
            }
        }
        catch (StorageException e) {
            LOGGER.error("Resolving outdated merge request comments failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void resolveMergeRequestDiscussion(GitLabUtils.MergeRequestSpecificGitLabClient helperClient, Map<String, GitLabDiscussion> existingDiscussions, String findingId, ReviewCommentResolutionReasonProvider commentResolutionProvider) throws StorageException {
        GitLabDiscussion discussion = existingDiscussions.get(findingId);
        if (!discussion.isResolved()) {
            try {
                helperClient.resolveMergeRequestDiscussion(discussion);
                String message = commentResolutionProvider.getMarkdownText(findingId);
                helperClient.replyToMergeRequestDiscussion(discussion, message);
            }
            catch (ServiceCallException e) {
                LOGGER.warn("Resolving outdated merge request comment for finding " + findingId + " failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void updateOrCreateMergeRequestDiscussion(GitLabUtils.MergeRequestSpecificGitLabClient helperClient, Map<String, GitLabDiscussion> existingDiscussionsByFindingId, Map<String, GitLabDiscussion> normalisedExistingTestGapComments, GitLabNote note) {
        String newBody = note.getBody();
        Optional<String> findingIdInNewBody = CcpCommentUtils.extractFindingIdFromComment(newBody);
        try {
            Optional<String> normalizedTestGapComment;
            if (findingIdInNewBody.isPresent()) {
                String findingId = findingIdInNewBody.get();
                GitLabDiscussion existingDiscussion = existingDiscussionsByFindingId.get(findingId);
                if (existingDiscussion != null && !CcpCommentUtils.normalizeCommentText(newBody).equals(CcpCommentUtils.normalizeCommentText(existingDiscussion.getFirstNoteBody())) && !GitLabMergeRequestAnnotationTrigger.discussionCreatedByDeletedUser(existingDiscussion)) {
                    helperClient.updateMergeRequestDiscussion(existingDiscussion, newBody);
                }
                if (existingDiscussionsByFindingId.remove(CcpCommentUtils.normalizeCommentText(findingId)) != null) {
                    return;
                }
            }
            if ((normalizedTestGapComment = CcpCommentUtils.extractNormalizedTestGapComment(newBody)).isPresent() && normalisedExistingTestGapComments.remove(normalizedTestGapComment.get()) != null) {
                return;
            }
            helperClient.createMergeRequestDiscussion(note);
        }
        catch (ServiceCallException | UnsupportedEncodingException e) {
            LOGGER.error("Posting merge request comment for note: " + String.valueOf(note) + " failed: " + e.getMessage(), e);
        }
    }

    private static boolean discussionCreatedByDeletedUser(GitLabDiscussion existingDiscussion) {
        return existingDiscussion.getFirstNote().getUsername().startsWith(GITLAB_GHOST_USER_PREFIX);
    }

    private List<GitLabNote> buildNewComments(List<IReviewComment> reviewComments, GitLabUtils.MergeRequestSpecificGitLabClient helperClient) throws ServiceCallException {
        GitLabMergeRequest mergeRequest = helperClient.getMergeRequestWithChanges();
        List<IReviewComment> relevantComments = GitLabUtils.filterCommentsNotInMergeRequest(reviewComments, mergeRequest);
        return new GitLabNoteBuilder(mergeRequest, (SupplierWithException<String, ServiceCallException>)((SupplierWithException)this.client::getVersion)).buildNotes(relevantComments);
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.GITLAB;
    }

    @VisibleForTesting
    public static List<GitLabDiscussion> filterNonTeamscaleDiscussions(List<GitLabDiscussion> discussions) {
        return GitLabMergeRequestAnnotationTrigger.filterNonTeamscaleDiscussions(discussions, discussion -> CcpCommentUtils.isDeletableTeamscaleComment(discussion.getFirstNoteBody()));
    }

    private static List<GitLabDiscussion> filterNonTeamscaleDiscussions(List<GitLabDiscussion> discussions, Predicate<GitLabDiscussion> filterPredicate) {
        return CollectionUtils.filter(discussions, filterPredicate);
    }
}

