/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.labeling;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.git.GitCommandLineToolBase;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.debug_dump.dump.EGitRepositoryDumpState;
import com.teamscale.index.repository.git.debug_dump.replay.CommitGraphNodeMock;
import com.teamscale.index.repository.git.debug_dump.replay.GitDebugDumpRepositoryConnection;
import com.teamscale.index.repository.git.debug_dump.replay.GitRepositoryDebugDumpReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.options.Option;

public class GitBranchLabeler
extends GitCommandLineToolBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean showParents = false;
    private boolean dumpCommitTreeGraph = false;

    @Option(shortName=112, longName="parents", description="Shows commit parents in the output")
    public void showParents() {
        this.showParents = true;
    }

    @Option(shortName=103, longName="graph", description="Dump commit tree graphs")
    public void dumpCommitTreeGraph() {
        this.dumpCommitTreeGraph = true;
    }

    protected void run() throws RepositoryException, StorageException {
        CommitTree commitTree;
        if (this.dumpCommitTreeGraph) {
            if (this.debugDumpPath == null) {
                LOGGER.error("Cannot read commit trees, because debug dump path is not set!");
                return;
            }
            try {
                this.dumpXdotCommitTree(GitRepositoryDebugDumpReader.readCommitTree(this.debugDumpPath, EGitRepositoryDumpState.PRE_LABEL), EGitRepositoryDumpState.PRE_LABEL.toString());
                this.dumpXdotCommitTree(GitRepositoryDebugDumpReader.readCommitTree(this.debugDumpPath, EGitRepositoryDumpState.POST_LABEL), EGitRepositoryDumpState.POST_LABEL.toString());
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        GitRepositoryConnection connection = this.createGitRepositoryConnection();
        Stopwatch watch = Stopwatch.createStarted();
        try {
            commitTree = this.expandCommitTree(connection, false);
        }
        catch (RescheduleRequestedException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (connection instanceof GitDebugDumpRepositoryConnection) {
            commitTree = ((GitDebugDumpRepositoryConnection)connection).getCommitTree();
        }
        commitTree.getAllNodes().stream().sorted(Comparator.comparing(x -> x.getRevision().getRevision())).map(this::formatNodeForOutput).forEach(x$0 -> CommandLineBase.printInfo((String)x$0));
        this.performSanityCheck((ICommitTree)commitTree);
        GitBranchLabeler.printInfo((String)("Processing took " + (double)watch.elapsed().toMillis() / 1000.0 + " sec"));
    }

    private void performSanityCheck(ICommitTree commitTree) {
        if (this.debugDumpPath == null) {
            return;
        }
        ICommitTree originalPostLabelCommitTree = GitRepositoryDebugDumpReader.readCommitTree(this.debugDumpPath, EGitRepositoryDumpState.POST_INSERT_COMMIT_TREE_NODES);
        if (Iterators.elementsEqual(commitTree.getAllNodes().stream().sorted(Comparator.comparing(x -> x.getRevision().getRevision())).map(this::formatNodeForOutput).iterator(), originalPostLabelCommitTree.getAllNodes().stream().sorted(Comparator.comparing(x -> x.getRevision().getRevision())).map(this::formatNodeForOutput).iterator())) {
            return;
        }
        GitBranchLabeler.printInfo((String)"Difference in branch labeling detected! This is probably due to an internal error in the import/processing of the debug dump. Please create a bug ticket.\n");
        GitBranchLabeler.printInfo((String)"Original tree:");
        originalPostLabelCommitTree.getAllNodes().stream().sorted(Comparator.comparing(x -> x.getRevision().getRevision())).map(this::formatNodeForOutput).forEach(x$0 -> CommandLineBase.printInfo((String)x$0));
        for (ICommitTreeNode node : commitTree.getAllNodes()) {
            ((CommitGraphNodeMock)node).validate();
        }
    }

    private String formatNodeForOutput(ICommitTreeNode node) {
        Object output = node.getRevision().toString();
        if (this.showParents) {
            output = (String)output + "\n" + node.getParentRevisions().stream().map(parent -> "  " + parent.toString()).collect(Collectors.joining("\n"));
        }
        return output;
    }

    public static void main(String[] args) throws Exception {
        LoggingUtils.initLogger();
        GitBranchLabeler.execute(GitBranchLabeler::new, (String[])args);
    }

    private void dumpXdotCommitTree(ICommitTree tree, String state) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        HashSet<String> edges = new HashSet<String>();
        for (ICommitTreeNode node : tree.getAllNodes()) {
            GitBranchLabeler.addEdges(edges, node);
        }
        writer.println("digraph \"" + state + "\" {");
        for (String edge : edges) {
            writer.println(edge);
        }
        writer.println("}");
        writer.close();
        FileSystemUtils.writeFileUTF8((Path)this.debugDumpPath.resolve("commit-trees_" + state + ".dot"), (String)stringWriter.toString());
    }

    private static void addEdges(Set<String> edges, ICommitTreeNode node) {
        for (CommitTreeRevision parent : node.getParentRevisions()) {
            edges.add("\"" + String.valueOf(parent) + "\" -> \"" + String.valueOf(node.getRevision()) + "\"");
        }
    }
}

