/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager.data;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerUtils;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerCiStatus;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerDiff;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequestComments;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.PairList;

public class ScmManagerUtils {
    public static ScmManagerCiStatus.CiStatus buildCiStatus(MergeRequestAnnotationInput input, TeamscaleCommitLinkProvider linkProvider) {
        int addedFindingsCountForVoting = input.getAddedFindingsForVoting().size();
        String targetUrl = linkProvider.createMergeRequestDetailsLink(input.mergeRequest.identifier);
        return new ScmManagerCiStatus.CiStatus("teamscale", "teamscale-findings", targetUrl, addedFindingsCountForVoting);
    }

    public static List<ScmManagerPullRequestComments.PullRequestComment> createInlineCommentsFromFindings(List<IReviewComment> reviewComments, ScmManagerDiff.Diff diffs) {
        ArrayList<ScmManagerPullRequestComments.PullRequestComment> commentsToBeAdded = new ArrayList<ScmManagerPullRequestComments.PullRequestComment>();
        Map<String, PairList<Integer, Integer>> pathToDiffRangesMap = diffs.getPathToDiffRightSideRangesMap();
        Map<String, Map<Integer, Integer>> pathToDiffLinesMap = diffs.getPathToDiffLinesMap();
        Map<String, Map<Integer, String>> pathToLineDiffHunkMap = diffs.getPathToLineHunkMap();
        Map<String, List<IReviewComment>> pathToFindings = reviewComments.stream().collect(Collectors.groupingBy(reviewComment -> reviewComment.getLocation().getUniformPath()));
        pathToFindings.forEach((path, findingsList) -> commentsToBeAdded.addAll(ScmManagerUtils.getInlineCommentsForPath(path, findingsList, (PairList<Integer, Integer>)((PairList)pathToDiffRangesMap.get(path)), (Map)pathToDiffLinesMap.get(path), (Map)pathToLineDiffHunkMap.get(path))));
        return commentsToBeAdded;
    }

    private static List<ScmManagerPullRequestComments.PullRequestComment> getInlineCommentsForPath(String path, List<IReviewComment> reviewComments, PairList<Integer, Integer> diffRanges, Map<Integer, Integer> contextLinesMap, Map<Integer, String> lineToDiffHunkMap) {
        ArrayList<ScmManagerPullRequestComments.PullRequestComment> fileComments = new ArrayList<ScmManagerPullRequestComments.PullRequestComment>();
        if (diffRanges == null) {
            return fileComments;
        }
        Map<Integer, List<IReviewComment>> reviewCommentsByLine = reviewComments.stream().collect(Collectors.groupingBy(finding -> BitbucketServerUtils.getCorrespondingDiffLine(finding, diffRanges)));
        reviewCommentsByLine.forEach((line, reviewCommentsForLine) -> {
            String text = CcpCommentUtils.createInlineCommentMarkdownContent(reviewCommentsForLine, false, line);
            Integer oldLine = null;
            if (contextLinesMap.containsKey(line)) {
                oldLine = (Integer)contextLinesMap.get(line);
            }
            fileComments.add(new ScmManagerPullRequestComments.PullRequestComment(text, path, (String)lineToDiffHunkMap.get(line), (Integer)line, oldLine));
        });
        return fileComments;
    }
}

