/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import com.teamscale.index.repository.svn.SVNUtils;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public final class SVNFilesRetriever
implements IFilesRetriever {
    private final @NonNull ConnectorConfiguration connectorConfiguration;
    private final @NonNull ExternalCredentials credentials;

    public SVNFilesRetriever(@NonNull ConnectorConfiguration connectorConfiguration, @NonNull ExternalCredentials credentials) {
        this.credentials = credentials;
        this.connectorConfiguration = connectorConfiguration;
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException {
        try {
            String svnUrl = SVNFilesRetriever.getSvnUrlFromConnector(this.credentials.uri, this.connectorConfiguration);
            SVNURL repositoryURL = SVNURL.parseURIEncoded((String)svnUrl);
            return SVNUtils.listFilesInDirectoryRecursively(this.credentials.username, this.credentials.password, repositoryURL);
        }
        catch (SVNException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getSvnUrlFromConnector(String uri, ConnectorConfiguration connectorConfiguration) {
        String defaultBranchName = connectorConfiguration.getOptionValue("Default branch name");
        String branchesDirectory = connectorConfiguration.getOptionValue("Branches directory");
        if ("trunk".equals(defaultBranchName)) {
            branchesDirectory = null;
        }
        if (!Boolean.parseBoolean(connectorConfiguration.getOptionValue("Enable branch analysis"))) {
            defaultBranchName = null;
            branchesDirectory = null;
        }
        return UniformPathUtils.concatenate((String[])new String[]{StringUtils.stripSuffix((String)uri, (String)"/"), connectorConfiguration.getOptionValue("Path suffix"), branchesDirectory, defaultBranchName});
    }
}

