/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.svn.ISvnRepositoryView;
import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnCrawlHelper;
import com.teamscale.index.repository.svn.SvnLogCacheIndex;
import com.teamscale.index.repository.svn.SvnRepositoryExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.predicate.IPredicateWithException;
import org.conqat.lib.commons.system.PerformanceMonitor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public abstract class SvnRepositoryViewBase
implements ISvnRepositoryView {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, SVNRepository> repositories = new HashMap<String, SVNRepository>();
    protected final SVNRepository mainRepository;
    protected final IPredicateWithException<String, RepositoryException> isPathIncluded;
    protected final Predicate<String> canSubPathsBeIncluded;
    protected final Function<String, Optional<String>> branchNameExtractor;
    protected final SvnLogCacheIndex logCacheIndex;
    protected final SVNClientManager clientManager;
    protected final SvnRepositoryExecutor repositoryExecutor = new SvnRepositoryExecutor();
    protected final String branchesDirectory;

    protected SvnRepositoryViewBase(SVNRepository repository, IPredicateWithException<String, RepositoryException> isPathIncluded, Predicate<String> canSubPathsBeIncluded, Function<String, Optional<String>> branchNameExtractor, SvnLogCacheIndex logCacheIndex, String branchDirectoryName) {
        this.mainRepository = repository;
        this.isPathIncluded = isPathIncluded;
        this.canSubPathsBeIncluded = canSubPathsBeIncluded;
        this.branchNameExtractor = branchNameExtractor;
        this.logCacheIndex = logCacheIndex;
        this.branchesDirectory = branchDirectoryName;
        this.clientManager = SVNClientManager.newInstance(null, (ISVNAuthenticationManager)repository.getAuthenticationManager());
    }

    protected SVNRepository getOrCreateRepository(String repositoryRoot) throws RepositoryException {
        SVNRepository result = this.repositories.get(repositoryRoot);
        if (result == null) {
            try {
                result = SVNUtils.createRepository(repositoryRoot, null, null);
            }
            catch (SVNException e) {
                throw new RepositoryException((Throwable)e);
            }
            result.setAuthenticationManager(this.mainRepository.getAuthenticationManager());
            this.repositories.put(repositoryRoot, result);
        }
        return result;
    }

    @Override
    public SVNClientManager getClientManager() {
        return this.clientManager;
    }

    @Override
    public List<byte[]> getContent(List<String> paths, String revision) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting getContent on " + paths.size() + " files in revision " + revision);
        try {
            ArrayList futures = new ArrayList();
            for (String path : paths) {
                BinaryContentAccessor binaryContentAccessor = this.getBinaryContentAccessor(path, revision);
                futures.add(this.repositoryExecutor.submit(repository -> contentAccessor.getContentWithRetry((SVNRepository)repository), binaryContentAccessor.executionRepository));
            }
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            for (Future future : futures) {
                Pair resultAndException = (Pair)future.get();
                if (resultAndException.getSecond() != null) {
                    throw (SVNException)((Object)resultAndException.getSecond());
                }
                result.add((byte[])resultAndException.getFirst());
            }
            LOGGER.debug("Finished getContent (" + monitor.stop() + "ms)");
            return result;
        }
        catch (InterruptedException | ExecutionException | SVNException e) {
            throw new RepositoryException(e);
        }
    }

    protected abstract BinaryContentAccessor getBinaryContentAccessor(String var1, String var2) throws RepositoryException;

    @Override
    public void close() {
        this.clientManager.dispose();
        this.repositoryExecutor.close();
        for (SVNRepository repository : this.repositories.values()) {
            repository.closeSession();
        }
        this.mainRepository.closeSession();
    }

    protected static Set<String> crawl(SVNRepository repository, String basePath, long revision, SvnRepositoryExecutor repositoryExecutor, IPredicateWithException<String, RepositoryException> isPathIncluded, Predicate<String> canSubPathsBeIncluded) throws SVNException {
        if (!canSubPathsBeIncluded.test(basePath)) {
            return Collections.emptySet();
        }
        try {
            repository.info(basePath, revision);
        }
        catch (SVNException e) {
            LOGGER.warn("Attempted to crawl non-existing directory " + basePath + " in " + repository.getLocation().toDecodedString() + " at revision " + revision + ". Might be caused by invalid externals.");
            return Collections.emptySet();
        }
        SvnCrawlHelper crawlHelper = new SvnCrawlHelper(repository, revision, repositoryExecutor, isPathIncluded, canSubPathsBeIncluded);
        crawlHelper.crawl(basePath);
        crawlHelper.waitForTasks();
        return crawlHelper.paths;
    }

    @Override
    public long getFirstCommitTimestamp(String path) {
        try {
            SVNRepository repository = this.getOrCreateRepository(this.mainRepository.getLocation().appendPath(path, false).toDecodedString());
            Optional<SVNLogEntry> entry = SVNUtils.getFirstLogEntryByRevision(repository, 1L);
            if (!entry.isPresent() || entry.get().getDate() == null) {
                return -1L;
            }
            return entry.get().getDate().getTime();
        }
        catch (RepositoryException | SVNException e) {
            LOGGER.warn("Had exception during timestamp resolution of " + path + ": " + e.getMessage(), e);
            return -1L;
        }
    }

    @Override
    public List<String> listDirectories(String path) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting listDirectories on " + path);
        ArrayList entries = new ArrayList();
        try {
            this.mainRepository.getDir(path, -1L, null, 1, entries);
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
        LOGGER.debug("Finished listDirectories (" + monitor.stop() + "ms)");
        return CollectionUtils.filterAndMap(entries, entry -> entry.getKind() == SVNNodeKind.DIR, entry -> entry.getName());
    }

    protected class BinaryContentAccessor {
        private final SVNRepository executionRepository;
        private String resolvedPath;
        private long resolvedRevision;

        public BinaryContentAccessor(SvnRepositoryViewBase this$0, SVNRepository executionRepository, String resolvedPath, long resolvedRevision) {
            this.executionRepository = executionRepository;
            this.resolvedPath = resolvedPath;
            this.resolvedRevision = resolvedRevision;
        }

        public final byte[] getContentWithRetry(SVNRepository repository) throws SVNException {
            ArrayList result = new ArrayList(1);
            SVNUtils.runWithRetry(() -> result.add(SVNUtils.getBinaryContent(this.resolvedPath, this.resolvedRevision, repository)), e -> LOGGER.warn("Failed to retrieve content of " + this.resolvedPath + " at revision " + this.resolvedRevision + ". Retrying!", (Throwable)e), (ConsumerWithException<SVNException, SVNException>)((ConsumerWithException)e -> {
                throw e;
            }));
            return (byte[])result.get(0);
        }
    }
}

