/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issues.WorkItemUnmanagedKeysHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemDescriber;
import com.teamscale.wia.SpecItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;

@Index(name="spec-item-unmanaged-keys", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={byte[].class})
public class SpecItemUnmanagedKeysHistoryIndex
extends WorkItemUnmanagedKeysHistoryIndex<SpecItem, List<SpecItemCodeReference>>
implements IProjectIndex {
    public static final String INDEX_NAME = "spec-item-unmanaged-keys";
    private static final IKeyedObjectDescriber<SpecItem> DESCRIBER = new SpecItemDescriber();

    public SpecItemUnmanagedKeysHistoryIndex(IStore store) {
        super(store, DESCRIBER);
    }

    @Override
    protected Map<String, String> convertUpdates(List<SpecItemCodeReference> updatedEntries) {
        if (updatedEntries == null) {
            updatedEntries = Collections.emptyList();
        }
        long codeReferences = updatedEntries.stream().filter(Predicate.not(SpecItemCodeReference::isTestReference)).count();
        long testReferences = updatedEntries.stream().filter(SpecItemCodeReference::isTestReference).count();
        return Map.of("codeReferences", String.valueOf(codeReferences), "testReferences", String.valueOf(testReferences));
    }

    @Override
    protected String getDefaultValue(String unmanagedKey) {
        switch (unmanagedKey) {
            case "codeReferences": 
            case "testReferences": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key: " + unmanagedKey);
            }
        }
        return String.valueOf(0);
    }
}

