/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.index.UniformPathToValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="code-scopes-mapping", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS})
public class CodeScopesMappingIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "code-scopes-mapping";
    private static final ISerializer<CodeScopeName, byte[]> CODE_SCOPE_NAME_SERIALIZER = ISerializer.of(CodeScopeName::name, CodeScopeName::new).andThen(ISerializer.forString());
    private final UniformPathToValueIndex<CodeScopeName> pathToCodeScopeIndex;
    private final CodeScopeToUniformPathIndex codeScopeToPathIndex;

    public CodeScopesMappingIndex(IStore store) {
        UniformPathSerializer uniformPathSerializer = UniformPathSerializer.fullAbbreviatingSerializer((IStorageAbbreviator)((IAbbreviationStoreCapability)store.getCapability(IAbbreviationStoreCapability.class).orElseThrow()).abbreviator());
        this.pathToCodeScopeIndex = UniformPathToValueIndex.of((IStore)new DelegatingPartitionStore(store, "p2s"), (UniformPathSerializer)uniformPathSerializer, CODE_SCOPE_NAME_SERIALIZER);
        this.codeScopeToPathIndex = new CodeScopeToUniformPathIndex((IStore)new DelegatingPartitionStore(store, "s2p"), (ISerializer<UniformPath, byte[]>)uniformPathSerializer, CODE_SCOPE_NAME_SERIALIZER);
    }

    public void setMapping(UniformPath uniformPath, CodeScopeName codeScopeName) throws StorageException {
        this.setMappings((PairList<UniformPath, CodeScopeName>)PairList.from((Object)uniformPath, (Object)codeScopeName));
    }

    public void setMappings(PairList<UniformPath, CodeScopeName> uniformPathToCodeScope) throws StorageException {
        this.pathToCodeScopeIndex.setValues(uniformPathToCodeScope);
        this.codeScopeToPathIndex.storeMappings(uniformPathToCodeScope);
    }

    public Map<UniformPath, CodeScopeName> getMappings(Collection<UniformPath> uniformPaths) throws StorageException {
        return this.pathToCodeScopeIndex.getExistingValues(uniformPaths);
    }

    public Map<UniformPath, CodeScopeName> getAllMappings() throws StorageException {
        return this.pathToCodeScopeIndex.getAllEntries();
    }

    public Set<UniformPath> getPathsInCodeScope(CodeScopeName codeScopeName) throws StorageException {
        return this.codeScopeToPathIndex.getMappings(codeScopeName);
    }

    public void removeMappings(Collection<UniformPath> uniformPaths) throws StorageException {
        Map existingValues = this.pathToCodeScopeIndex.getExistingValues(uniformPaths);
        this.pathToCodeScopeIndex.removeValues(existingValues.keySet());
        this.codeScopeToPathIndex.removeMappings(existingValues);
    }

    private static class CodeScopeToUniformPathIndex
    implements IUtilityIndex {
        private static final byte[] SEPARATOR = new byte[]{0};
        private static final byte[] DUMMY_VALUE = new byte[0];
        private final IStore store;
        private final ISerializer<UniformPath, byte[]> uniformPathSerializer;
        private final ISerializer<CodeScopeName, byte[]> codeScopeNameSerializer;

        public CodeScopeToUniformPathIndex(IStore store, ISerializer<UniformPath, byte[]> uniformPathSerializer, ISerializer<CodeScopeName, byte[]> codeScopeNameSerializer) {
            this.store = store;
            this.uniformPathSerializer = uniformPathSerializer;
            this.codeScopeNameSerializer = codeScopeNameSerializer;
        }

        public void storeMappings(PairList<UniformPath, CodeScopeName> values) throws StorageException {
            Map pathsByCodeScope = values.stream().collect(Collectors.groupingBy(ImmutablePair::getSecond, Collectors.mapping(ImmutablePair::getFirst, Collectors.toSet())));
            for (Map.Entry entry : pathsByCodeScope.entrySet()) {
                this.storeMappings(entry.getKey(), entry.getValue());
            }
        }

        private void storeMappings(CodeScopeName codeScope, Set<UniformPath> paths) throws StorageException {
            PairList keysAndValues = (PairList)this.serializedKeyStream(codeScope, paths).collect(PairList.toPairList(Function.identity(), ignored -> DUMMY_VALUE));
            this.store.put(keysAndValues);
        }

        private Stream<byte[]> serializedKeyStream(CodeScopeName codeScope, Set<UniformPath> paths) throws StorageException {
            List serializedPaths = this.uniformPathSerializer.serialize(paths);
            byte[] serializedCodeScope = (byte[])this.codeScopeNameSerializer.serialize((Object)codeScope);
            return serializedPaths.stream().map(pathBytes -> ByteArrayUtils.concat((byte[][])new byte[][]{serializedCodeScope, SEPARATOR, pathBytes}));
        }

        public void removeMappings(Map<UniformPath, CodeScopeName> values) throws StorageException {
            Map pathsByCodeScope = values.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
            for (Map.Entry entry : pathsByCodeScope.entrySet()) {
                CodeScopeName codeScope = entry.getKey();
                Set<UniformPath> paths = entry.getValue();
                this.removeMappings(codeScope, paths);
            }
        }

        private void removeMappings(CodeScopeName codeScope, Set<UniformPath> paths) throws StorageException {
            List<byte[]> keysToRemove = this.serializedKeyStream(codeScope, paths).toList();
            this.store.remove(keysToRemove);
        }

        public Set<UniformPath> getMappings(CodeScopeName codeScope) throws StorageException {
            ArrayList keys = new ArrayList();
            byte[] prefix = ByteArrayUtils.concat((byte[][])new byte[][]{(byte[])this.codeScopeNameSerializer.serialize((Object)codeScope), SEPARATOR});
            this.store.scanKeys(prefix, (key, value) -> {
                List list = keys;
                synchronized (list) {
                    keys.add(ByteArrayUtils.removePrefix((byte[])prefix, (byte[])key));
                }
            });
            return new HashSet<UniformPath>(this.uniformPathSerializer.deserialize(keys));
        }

        public IStore getWrappedStore() {
            return this.store;
        }
    }
}

