/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.element_details.IncludeSearchPathEntry;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class CompilationCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MATCH_NOTHING_PATTERN_STRING = "(?!)";
    private static final String EXCLUDE_DEFINITION_PATTERN_VM_PROPERTY_NAME = "com.teamscale.reparsing.exclude_compilation_command_definition_pattern";
    private static final String EXCLUDE_SEARCH_PATH_PATTERN_VM_PROPERTY_NAME = "com.teamscale.reparsing.exclude_compilation_command_search_path_pattern";
    private static final Pattern EXCLUDE_DEFINITION_PATTERN = Pattern.compile(System.getProperty("com.teamscale.reparsing.exclude_compilation_command_definition_pattern", "(?!)"));
    private static final Pattern EXCLUDE_SEARCH_PATH_PATTERN = Pattern.compile(System.getProperty("com.teamscale.reparsing.exclude_compilation_command_search_path_pattern", "(?!)"));
    public static final String DEFAULT_CPP_COMPILER_COMMAND = "clang++";
    public static final String DEFAULT_C_COMPILER_COMMAND = "clang";
    public static final CompilationCommand EMPTY_CPP_COMMAND = new CompilationCommand("clang++");
    public static final CompilationCommand EMPTY_C_COMMAND = new CompilationCommand("clang");
    private final IncludePathDetail includePathDetail;
    private final List<String> definitions;
    private final String compilerCommand;
    private final List<String> otherOptions;

    public static Pattern getExcludeDefinitionPattern() {
        return EXCLUDE_DEFINITION_PATTERN;
    }

    public static Pattern getExcludeSearchPathPattern() {
        return EXCLUDE_SEARCH_PATH_PATTERN;
    }

    public CompilationCommand(IncludePathDetail includePathDetail, List<String> definitions, String compilerCommand, List<String> otherOptions) {
        this.includePathDetail = Objects.requireNonNull(includePathDetail);
        this.definitions = new ArrayList<String>(definitions);
        this.compilerCommand = Objects.requireNonNull(compilerCommand);
        this.otherOptions = Objects.requireNonNull(otherOptions);
        if (!MATCH_NOTHING_PATTERN_STRING.equals(CompilationCommand.getExcludeDefinitionPattern().pattern())) {
            this.removeDefinitionsWithMatchingSystemPattern();
        }
        if (!MATCH_NOTHING_PATTERN_STRING.equals(CompilationCommand.getExcludeSearchPathPattern().pattern())) {
            this.removeSearchPathsWithMatchingSystemPattern();
        }
    }

    public CompilationCommand(IncludePathDetail includePathDetail, List<String> definitions) {
        this(includePathDetail, definitions, DEFAULT_CPP_COMPILER_COMMAND, Collections.emptyList());
    }

    public CompilationCommand(String compilerCommand) {
        this(new IncludePathDetail(), Collections.emptyList(), compilerCommand, Collections.emptyList());
    }

    public IncludePathDetail getIncludePathDetail() {
        return this.includePathDetail;
    }

    public List<String> getDefinitions() {
        return this.definitions;
    }

    public String getCompilerCommand() {
        return this.compilerCommand;
    }

    public List<String> getOtherOptions() {
        return this.otherOptions;
    }

    public void removeDefinitionsWithMatchingSystemPattern() {
        this.definitions.removeIf(definition -> CompilationCommand.getExcludeDefinitionPattern().matcher((CharSequence)definition).matches());
    }

    public void removeSearchPathsWithMatchingSystemPattern() {
        this.includePathDetail.removeSearchPathsWithMatching(CompilationCommand.getExcludeSearchPathPattern());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Command: ");
        builder.append(this.compilerCommand);
        for (IncludeSearchPathEntry entry : this.includePathDetail.getIncludeSearchPathEntries()) {
            builder.append(" ");
            builder.append(entry.toString());
        }
        for (String definition : this.definitions) {
            builder.append(" ");
            builder.append(definition);
        }
        for (String option : this.otherOptions) {
            builder.append(" ");
            builder.append(option);
        }
        return builder.toString();
    }

    public static CompilationCommand getDefaultCompilationCommand(BasicTokenElementInfo element) {
        if (element.getLanguage() == ELanguage.C) {
            return EMPTY_C_COMMAND;
        }
        return EMPTY_CPP_COMMAND;
    }
}

