/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CppSystemIncludeDirectories
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_DIRECTORIES = CppSystemIncludeDirectories.determineDefaultIncludeDirectories();
    private final CodeScopeAware<List<String>> directoriesPerCodeScope = CodeScopeAware.empty();

    public CppSystemIncludeDirectories(CodeScopeAware<String> directoriesSeparatedByNewLinePerCodeScope) {
        for (CodeScopeName codeScopeName : directoriesSeparatedByNewLinePerCodeScope.getCodeScopeNames()) {
            String directoriesSeparatedByNewLine = (String)directoriesSeparatedByNewLinePerCodeScope.getValue(codeScopeName);
            List directories = CollectionUtils.filterAndMap((Collection)StringUtils.splitLinesAsList((String)directoriesSeparatedByNewLine), s -> !StringUtils.isEmpty((String)s), String::trim);
            this.directoriesPerCodeScope.setValue(codeScopeName, (Object)directories);
        }
    }

    public CodeScopeAware<List<String>> getDirectoriesForAllCodeScopes() {
        return this.directoriesPerCodeScope;
    }

    private static String determineDefaultIncludeDirectories() {
        List<String> result = CppSystemIncludeDirectories.determineDefaultIncludeFromLinuxCompiler("clang");
        if (CollectionUtils.isNullOrEmpty(result)) {
            result = CppSystemIncludeDirectories.determineDefaultIncludeFromLinuxCompiler("gcc");
        }
        return StringUtils.concat((Iterable)CollectionUtils.emptyIfNull(result), (String)"\n");
    }

    private static List<String> determineDefaultIncludeFromLinuxCompiler(String compilerExecutableName) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String errorOutput = ProcessUtils.execute((String[])new String[]{compilerExecutableName, "-v", "-E", "-xc++", "-"}, (String)"").getStderr();
            boolean inIncludes = false;
            for (String line : StringUtils.splitLinesAsList((String)errorOutput)) {
                if (line.matches(".*include.*search starts here:")) {
                    inIncludes = true;
                    continue;
                }
                if (line.matches("End of search list.")) {
                    inIncludes = false;
                    continue;
                }
                if (!inIncludes || line.startsWith("#")) continue;
                result.add(StringUtils.getFirstPart((String)line.trim(), (char)' '));
            }
            return result;
        }
        catch (IOException e) {
            LOGGER.debug("Failed to check " + compilerExecutableName + " (likely not installed): " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

