/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparsingDependencyIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PreprocessorIncludeReparseTrigger
extends ChangeProcessorAnalysisStep {
    public static final Set<ELanguage> RELEVANT_LANGUAGES = CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES;
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta basicContentIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicContentIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY, indexName="reparsing-dependency")
    private List<PreprocessorIncludeReparsingDependencyIndex> parentReparsingDependencyIndices;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ReparseRequiredIndex reparseRequiredIndex;

    public void execute() throws StorageException {
        List deletedUniformPaths = this.basicContentIndexDelta.getDeletedKeysAsStrings();
        List addedOrChangedUniformPaths = this.basicContentIndexDelta.getAddedOrChangedKeysAsStrings();
        HashSet<String> additionalUniformPathsToBeReparsed = new HashSet<String>();
        additionalUniformPathsToBeReparsed.addAll(this.determineDirectlyDependentUniformPaths(deletedUniformPaths));
        additionalUniformPathsToBeReparsed.addAll(this.determineDirectlyDependentUniformPaths(addedOrChangedUniformPaths));
        additionalUniformPathsToBeReparsed.addAll(this.determineTransitiveDependencyHull(additionalUniformPathsToBeReparsed));
        CollectionUtils.removeAll(additionalUniformPathsToBeReparsed, (List)deletedUniformPaths);
        CollectionUtils.removeAll(additionalUniformPathsToBeReparsed, (List)addedOrChangedUniformPaths);
        this.removeAllHiddenOrUnknownPaths(additionalUniformPathsToBeReparsed);
        this.reparseRequiredIndex.storeAdditionalUniformPathsForReparsing(this.getSchedulingCommit(), additionalUniformPathsToBeReparsed);
    }

    private void removeAllHiddenOrUnknownPaths(Set<String> additionalUniformPathsToBeReparsed) throws StorageException {
        Map<String, BasicTokenElementInfo> elements = this.basicContentIndex.getTokenElementsByPath(additionalUniformPathsToBeReparsed);
        for (Map.Entry<String, BasicTokenElementInfo> entry : elements.entrySet()) {
            if (!entry.getValue().getFirstDetailOfType(HiddenTokenElementDetail.class).isPresent()) continue;
            additionalUniformPathsToBeReparsed.remove(entry.getKey());
        }
        additionalUniformPathsToBeReparsed.removeIf(Predicate.not(elements::containsKey));
    }

    private Set<String> determineDirectlyDependentUniformPaths(Collection<String> uniformPaths) throws StorageException {
        List fileNames = CollectionUtils.map(uniformPaths, PreprocessorIncludeReparsingDependencyIndex::buildDependencyTargetStorageKeyForUniformPath);
        HashSet<String> dependentUniformPaths = new HashSet<String>();
        for (PreprocessorIncludeReparsingDependencyIndex inverseIndex : this.parentReparsingDependencyIndices) {
            List<List<String>> uniformPathsIncludingFileNames = inverseIndex.getPathsIncludingFileNames(fileNames);
            for (List<String> uniformPathsIncludingFileName : uniformPathsIncludingFileNames) {
                if (uniformPathsIncludingFileName == null) continue;
                dependentUniformPaths.addAll(uniformPathsIncludingFileName);
            }
        }
        List legacyFileNames = CollectionUtils.map(uniformPaths, PreprocessorIncludeReparsingDependencyIndex::buildLegacyDependencyTargetStorageKeyForUniformPath);
        for (PreprocessorIncludeReparsingDependencyIndex inverseIndex : this.parentReparsingDependencyIndices) {
            List<List<String>> uniformPathsIncludingFileNames = inverseIndex.getPathsIncludingFileNames(legacyFileNames);
            for (List<String> uniformPathsIncludingFileName : uniformPathsIncludingFileNames) {
                if (uniformPathsIncludingFileName == null) continue;
                dependentUniformPaths.addAll(uniformPathsIncludingFileName);
            }
        }
        return dependentUniformPaths;
    }

    private Set<String> determineTransitiveDependencyHull(Set<String> seedUniformPaths) throws StorageException {
        HashSet<String> transitiveHull = new HashSet<String>(seedUniformPaths);
        Set<String> currentStep = new HashSet<String>(seedUniformPaths);
        while (!currentStep.isEmpty()) {
            Set<String> nextDirectlyDependentPaths = this.determineDirectlyDependentUniformPaths(currentStep);
            nextDirectlyDependentPaths.removeAll(transitiveHull);
            currentStep = nextDirectlyDependentPaths;
            transitiveHull.addAll(nextDirectlyDependentPaths);
        }
        return transitiveHull;
    }
}

