/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.HiddenMetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexBase;
import com.teamscale.core.metrics.directory.MetricTrendIndex;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.IMetricSchemaRetriever;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.user.User;
import com.teamscale.index.metrics.MetricNames;
import com.teamscale.index.resource.retrieval_strategy.IndexMetricRetrievalStrategyBase;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyUtils;
import com.teamscale.index.resource.retrieval_strategy.WorkItemHistoryAccessOptionExpander;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.stream.IStreamSource;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ReadOnlyStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class WorkItemMetricRetrievalStrategy
extends IndexMetricRetrievalStrategyBase {
    public static final Set<String> INCLUDED_DEFAULT_METRICS = Set.of("Change Count", "Last Change Date", MetricNames.FINDINGS_COUNT.getName(), MetricNames.FINDINGS_COUNT_YELLOW.getName(), MetricNames.FINDINGS_COUNT_RED.getName(), MetricNames.FINDINGS_COUNT_BY_CATEGORY.getName(), MetricNames.FINDINGS_COUNT_BY_CATEGORY_YELLOW.getName(), MetricNames.FINDINGS_COUNT_BY_CATEGORY_RED.getName(), MetricNames.COMPLETE_BLACKLIST_COUNT.getName(), MetricNames.COMPLETE_BLACKLIST_COUNT_RED.getName(), MetricNames.COMPLETE_BLACKLIST_COUNT_YELLOW.getName(), MetricNames.TOLERATED_BLACKLIST_COUNT.getName(), MetricNames.TOLERATED_BLACKLIST_COUNT_YELLOW.getName(), MetricNames.TOLERATED_BLACKLIST_COUNT_RED.getName(), MetricNames.FALSE_POSITIVE_BLACKLIST_COUNT.getName(), MetricNames.FALSE_POSITIVE_BLACKLIST_COUNT_YELLOW.getName(), MetricNames.FALSE_POSITIVE_BLACKLIST_COUNT_RED.getName());
    private final String metricsDirectoryIndexName;
    private final String metricsTrendIndexName;
    private final WorkItemHistoryAccessOptionExpander historyAccessOptionExpander;
    private final ConcurrentMap<Pair<CommitDescriptor, CommitDescriptor>, List<ParentedCommitDescriptor>> relevantCommitCache = new ConcurrentHashMap<Pair<CommitDescriptor, CommitDescriptor>, List<ParentedCommitDescriptor>>();

    public WorkItemMetricRetrievalStrategy(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, String metricsDirectoryIndexName, String metricsTrendIndexName, IMetricSchemaRetriever schemaRetriever, boolean onlyHidden) {
        super(projectStorageSystem, globalStorageSystem, currentUser, schemaRetriever, onlyHidden);
        this.metricsDirectoryIndexName = metricsDirectoryIndexName;
        this.metricsTrendIndexName = metricsTrendIndexName;
        this.historyAccessOptionExpander = new WorkItemHistoryAccessOptionExpander(projectStorageSystem);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        List<HistoryAccessOption> expanded = this.historyAccessOptionExpander.expandHistoryAccessOption(uniformPath, historyAccessOption);
        ArrayList<MetricDirectoryEntry> entries = new ArrayList<MetricDirectoryEntry>(expanded.size());
        for (HistoryAccessOption accessOption : expanded) {
            MetricDirectoryEntry metricDirectoryEntry = super.getMetricDirectoryEntry(uniformPath, accessOption);
            if (metricDirectoryEntry == null) continue;
            entries.add(metricDirectoryEntry);
        }
        MetricDirectorySchema schema = this.getMetricDirectorySchema(historyAccessOption);
        MetricDirectoryEntry result = MetricRetrievalStrategyUtils.aggregateEntries(uniformPath.toString(), entries, schema);
        CCSMAssert.isTrue((schema.size() == result.getValues().length ? 1 : 0) != 0, (String)"Numbers of metric values and schema entries should be equal.");
        return result;
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        ListMap values = new ListMap();
        for (HistoryAccessOption accessOption : this.historyAccessOptionExpander.expandHistoryAccessOption(CollectionUtils.map(uniformPathPrefixes, UniformPathCompatibilityUtil::convert), historyAccessOption)) {
            List<MetricDirectoryEntry> entries = super.getMetricDirectoryEntries(uniformPathPrefixes, accessOption);
            for (MetricDirectoryEntry entry2 : entries) {
                values.add((Object)entry2.getUniformPath(), (Object)entry2);
            }
        }
        MetricDirectorySchema schema = this.getMetricDirectorySchema();
        return values.entrySet().stream().map(entry -> MetricRetrievalStrategyUtils.aggregateEntries((String)entry.getKey(), (Collection)entry.getValue(), schema)).collect(Collectors.toList());
    }

    @Override
    protected MetricDirectoryIndexBase openMetricDirectoryIndex(HistoryAccessOption historyAccessOption) throws StorageException {
        if (this.onlyHidden) {
            if ("metrics-dir".equals(this.metricsDirectoryIndexName)) {
                return (MetricDirectoryIndexBase)this.projectStorageSystem.openProjectIndex(HiddenMetricDirectoryIndex.class, historyAccessOption);
            }
            return new HiddenMetricDirectoryIndex((IStore)new ReadOnlyStore((IStore)new InMemoryStore()));
        }
        return (MetricDirectoryIndexBase)this.projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, this.metricsDirectoryIndexName, historyAccessOption);
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        this.verifyNotHiddenForTrend();
        MetricTrendIndex trendIndex = (MetricTrendIndex)this.projectStorageSystem.openProjectIndex(MetricTrendIndex.class, this.metricsTrendIndexName, null);
        PairList<CommitDescriptor, CommitDescriptor> expandedCommits = this.expandCommits(uniformPath, start, end);
        TreeMap<Long, Map<String, Object[]>> trendsPerBranch = new TreeMap<Long, Map<String, Object[]>>();
        HashSet<String> allBranches = new HashSet<String>();
        for (Pair expandedCommit : expandedCommits) {
            CommitDescriptor startCommit = (CommitDescriptor)expandedCommit.getFirst();
            CommitDescriptor endCommit = (CommitDescriptor)expandedCommit.getSecond();
            List<TrendIndexBase.TrendEntry<Object[]>> trendEntries = this.extractTrend(trendIndex, uniformPath, startCommit, endCommit);
            String branchName = endCommit.getBranchName();
            for (TrendIndexBase.TrendEntry<Object[]> trendEntry : trendEntries) {
                trendsPerBranch.computeIfAbsent(trendEntry.timestamp(), ignored -> new HashMap()).put(branchName, (Object[])trendEntry.value());
                allBranches.add(branchName);
            }
        }
        return this.aggregateTrendsFromDifferentBranches(uniformPath, trendsPerBranch, allBranches);
    }

    @Override
    protected List<ParentedCommitDescriptor> getTrendRelevantCommits(CommitDescriptor start, CommitDescriptor end) throws StorageException {
        return (List)CollectionUtils.computeIfAbsentWithException(this.relevantCommitCache, (Object)new Pair((Object)start, (Object)end), ignored -> Collections.unmodifiableList(super.getTrendRelevantCommits(start, end)));
    }

    private List<TrendIndexBase.TrendEntry<Object[]>> aggregateTrendsFromDifferentBranches(UniformPath path, NavigableMap<Long, Map<String, Object[]>> trendsPerBranch, Set<String> allBranches) throws StorageException {
        MetricDirectorySchema schema = this.getMetricDirectorySchema();
        ArrayList<TrendIndexBase.TrendEntry<Object[]>> result = new ArrayList<TrendIndexBase.TrendEntry<Object[]>>(trendsPerBranch.size());
        Iterator iterator = trendsPerBranch.keySet().iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            Object[] mergedMetrics = this.getAggregatedMetricsForTimestamp(path, trendsPerBranch, allBranches, schema, timestamp);
            if (mergedMetrics == null) continue;
            result.add((TrendIndexBase.TrendEntry<Object[]>)new TrendIndexBase.TrendEntry(timestamp, (Object)mergedMetrics));
        }
        return result;
    }

    private @NonNull Object[] getAggregatedMetricsForTimestamp(UniformPath path, NavigableMap<Long, Map<String, Object[]>> trendsPerBranch, Set<String> allBranches, MetricDirectorySchema schema, long timestamp) throws StorageException {
        List<Object[]> metrics = this.getMetricDirectoryEntriesForTimestamp(path, trendsPerBranch, allBranches, timestamp);
        if (metrics.isEmpty()) {
            return null;
        }
        return MetricRetrievalStrategyUtils.aggregateMetrics(metrics, schema);
    }

    private @NonNull List<Object[]> getMetricDirectoryEntriesForTimestamp(UniformPath path, NavigableMap<Long, Map<String, Object[]>> trendsPerBranch, Set<String> allBranches, long timestamp) throws StorageException {
        Map valuesPerBranch = (Map)trendsPerBranch.get(timestamp);
        ArrayList<Object[]> metrics = new ArrayList<Object[]>();
        for (String branch : allBranches) {
            if (!valuesPerBranch.containsKey(branch)) {
                Object[] lastMetrics = this.getLastMetricForTimestampAndBranch(path, trendsPerBranch, timestamp, branch);
                if (lastMetrics.length <= 0) continue;
                valuesPerBranch.put(branch, lastMetrics);
                metrics.add(lastMetrics);
                continue;
            }
            metrics.add((Object[])valuesPerBranch.get(branch));
        }
        return metrics;
    }

    private Object[] getLastMetricForTimestampAndBranch(UniformPath path, NavigableMap<Long, Map<String, Object[]>> trendsPerBranch, long timestamp, String branch) throws StorageException {
        Map.Entry<Long, Map<String, Object[]>> lowerEntry = trendsPerBranch.lowerEntry(timestamp);
        if (lowerEntry == null || !lowerEntry.getValue().containsKey(branch)) {
            MetricDirectoryEntry metricDirectoryEntry = super.getMetricDirectoryEntry(path, HistoryAccessOption.readTimestamp((String)branch, (long)timestamp));
            if (metricDirectoryEntry != null) {
                return metricDirectoryEntry.getValues();
            }
        } else {
            return lowerEntry.getValue().get(branch);
        }
        return new Object[0];
    }

    private PairList<CommitDescriptor, CommitDescriptor> expandCommits(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        IStreamWithException branches = start.getBranchName().equals(end.getBranchName()) ? IStreamWithException.wrap(this.historyAccessOptionExpander.expandHistoryAccessOption(uniformPath, HistoryAccessOption.readCommit((CommitDescriptor)start)).stream().map(HistoryAccessOption::getBranchName), StorageException.class) : IStreamWithException.of((IStreamSource)IStreamSource.of(StorageException.class, (Object)start, (Object[])new CommitDescriptor[]{end})).map(HistoryAccessOption::readCommit).map(hao -> this.historyAccessOptionExpander.expandHistoryAccessOption(uniformPath, (HistoryAccessOption)hao)).flatMap(hao -> IStreamWithException.of((IStreamSource)IStreamSource.ofIterable((Iterable)hao, StorageException.class))).map(HistoryAccessOption::getBranchName);
        return (PairList)branches.distinct().collect(PairList.toPairList(branch -> new CommitDescriptor(branch, start.getTimestamp()), branch -> new CommitDescriptor(branch, end.getTimestamp())));
    }
}

