/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.ProcessCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.HandlerBeforeAttemptContext;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.auth.oauth2.GoogleCredentials;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.index.s3.CredentialsProcess;
import com.teamscale.index.s3.IS3Client;
import com.teamscale.index.s3.IS3ClientFactory;
import com.teamscale.index.s3.S3Client;
import com.teamscale.index.s3.S3RegionUtils;
import com.teamscale.index.s3.S3UriParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;

public final class S3ClientFactory
implements IS3ClientFactory {
    @Override
    public IS3Client createForUri(IExternalCredentialsProvider externalCredentialsProvider, S3UriParser.ParsedUri parsedUri) throws StorageException {
        if (parsedUri.isGlobalS3Uri()) {
            return S3ClientFactory.createWithDefaultCredentialProvider();
        }
        return S3ClientFactory.createFromParsedUri(parsedUri, externalCredentialsProvider);
    }

    @Override
    public IS3Client createWithCredentialsProcess(String baseUri, CredentialsProcess credentialsProcess) {
        return new S3Client(baseUri, (AWSCredentialsProvider)ProcessCredentialsProvider.builder().withCommand(credentialsProcess.createCommand()).build());
    }

    private static IS3Client createWithDefaultCredentialProvider() {
        DefaultAWSCredentialsProviderChain credentialsProvider = new DefaultAWSCredentialsProviderChain();
        return new S3Client(() -> ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider))).build(), (AWSCredentialsProvider)credentialsProvider);
    }

    private static IS3Client createFromParsedUri(S3UriParser.ParsedUri parsedUri, IExternalCredentialsProvider externalCredentialsProvider) throws StorageException {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enablePathStyleAccess();
        AWSCredentials credentials = S3ClientFactory.createCredentials(parsedUri, externalCredentialsProvider);
        AWSStaticCredentialsProvider credentialsProvider = null;
        if (credentials instanceof AnonymousAWSCredentials && parsedUri.isGoogleCloudStorageUri()) {
            builder.withRequestHandlers(new RequestHandler2[]{GoogleCloudAuthenticationHandler.getApplicationDefault()});
        } else {
            credentialsProvider = new AWSStaticCredentialsProvider(credentials);
            builder.withCredentials((AWSCredentialsProvider)credentialsProvider);
        }
        return new S3Client(() -> ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(parsedUri.getEndpoint(), S3RegionUtils.extractRegionFromBaseUri(parsedUri.getEndpoint()))))).build(), (AWSCredentialsProvider)credentialsProvider);
    }

    private static AWSCredentials createCredentials(S3UriParser.ParsedUri parsedUri, IExternalCredentialsProvider credentialsProvider) throws StorageException {
        ExternalCredentials externalCredentials;
        if (parsedUri.getAccessKey() != null && parsedUri.getSecretKey() != null) {
            return new BasicAWSCredentials(parsedUri.getAccessKey(), parsedUri.getSecretKey());
        }
        if (credentialsProvider != null && (externalCredentials = credentialsProvider.getExternalCredentials(parsedUri.getEndpoint())) != null && parsedUri.getEndpoint().equals(externalCredentials.uri)) {
            return new BasicAWSCredentials(externalCredentials.username, externalCredentials.password);
        }
        return new AnonymousAWSCredentials();
    }

    private static final class GoogleCloudAuthenticationHandler
    extends RequestHandler2 {
        private final GoogleCredentials credentials;

        public GoogleCloudAuthenticationHandler(GoogleCredentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
        }

        public static GoogleCloudAuthenticationHandler getApplicationDefault() {
            try {
                return new GoogleCloudAuthenticationHandler(GoogleCredentials.getApplicationDefault());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create Google Cloud credentials", e);
            }
        }

        public void beforeAttempt(HandlerBeforeAttemptContext context) {
            super.beforeAttempt(context);
            try {
                context.getRequest().addHeader("Authorization", "Bearer " + this.getToken());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to obtain Google Cloud token", e);
            }
        }

        private String getToken() throws IOException {
            this.credentials.refreshIfExpired();
            return this.credentials.getAccessToken().getTokenValue();
        }
    }
}

