/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.amazonaws.SdkBaseException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.google.common.annotations.VisibleForTesting;
import com.teamscale.core.config.TeamscaleSystemProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.string.StringUtils;

final class S3RegionUtils {
    private static final List<String> CUSTOM_REGION_NAMES;

    private S3RegionUtils() {
    }

    public static String extractRegionFromBaseUri(String baseUri) {
        return S3RegionUtils.extractRegionFromUri(baseUri, CUSTOM_REGION_NAMES);
    }

    private static Optional<Region> getRegion() {
        try {
            Region region;
            Optional awsRegionProperty = TeamscaleSystemProperties.AWS_REGION.getValue();
            if (awsRegionProperty.isPresent() && (region = RegionUtils.getRegion((String)((String)awsRegionProperty.get()))) != null) {
                return Optional.of(region);
            }
            return Optional.ofNullable(Regions.getCurrentRegion());
        }
        catch (SdkBaseException e) {
            return Optional.empty();
        }
    }

    private static Region getDefaultRegion() {
        return Region.getRegion((Regions)Regions.DEFAULT_REGION);
    }

    private static void disableAWSWarnLogs() {
        Configurator.setLevel((String)"com.amazonaws", (Level)Level.DEBUG);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig loggerConfig = ctx.getConfiguration().getLoggerConfig("com.amazonaws");
        loggerConfig.addFilter((Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                if (event.getLevel() == Level.INFO || event.getLevel() == Level.WARN) {
                    return Filter.Result.DENY;
                }
                return Filter.Result.NEUTRAL;
            }
        });
        ctx.updateLoggers();
    }

    @VisibleForTesting
    static @NonNull String extractRegionFromUri(@NonNull String uri, @NonNull List<String> customRegionNames) {
        for (Regions region : Regions.values()) {
            if (!StringUtils.containsIgnoreCase((String)uri, (String)region.getName())) continue;
            return Region.getRegion((Regions)region).getName();
        }
        for (String customRegionName : customRegionNames) {
            if (!StringUtils.containsIgnoreCase((String)uri, (String)customRegionName)) continue;
            return customRegionName;
        }
        if (EFeatureToggle.ENABLE_TEST_MODE.isEnabled()) {
            return S3RegionUtils.getDefaultRegion().getName();
        }
        return S3RegionUtils.getRegion().orElse(S3RegionUtils.getDefaultRegion()).getName();
    }

    @VisibleForTesting
    static @NonNull List<String> parseCustomRegionNames(@Nullable String customAwsRegionProperty) {
        if (StringUtils.isEmpty((String)customAwsRegionProperty)) {
            return Collections.emptyList();
        }
        ArrayList<String> customRegionNames = new ArrayList<String>();
        for (String regionName : customAwsRegionProperty.split(",")) {
            if (StringUtils.isEmpty((String)regionName)) continue;
            customRegionNames.add(regionName.trim());
        }
        return customRegionNames;
    }

    static {
        S3RegionUtils.disableAWSWarnLogs();
        CUSTOM_REGION_NAMES = S3RegionUtils.parseCustomRegionNames((String)TeamscaleSystemProperties.CUSTOM_AWS_REGIONS.getValue());
    }
}

