/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.index.comment_analysis.utils.CommentUtils;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.simulink.tracing.SimulinkCoderGeneratorTracingUtils;
import com.teamscale.index.simulink.tracing.SimulinkSourceFileMapper;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndex;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SimulinkCoderCodeGenerationSourceFileMapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> IF_SUBTYPES = CollectionUtils.asHashSet((Object[])new String[]{"if", "else", "else if"});

    public static @NonNull List<SimulinkSourceFileMapper.TracingBeacon> generateTracingBeacons(TokenElementInfo sourceElement, SimulinkModelInfoIndex modelInfoIndex, TracelinkAbbreviationIndex tracelinkAbbreviationIndex, ElementLocation baseLocation) throws StorageException {
        String modelName = SimulinkCoderGeneratorTracingUtils.extractModelName(sourceElement).get();
        ArrayList<SimulinkSourceFileMapper.TracingBeacon> newBeacons = new ArrayList<SimulinkSourceFileMapper.TracingBeacon>();
        UnmodifiableList<ShallowEntity> entities = sourceElement.getShallowEntitiesWithoutPreprocessorTokens();
        for (IToken comment : CommentUtils.getCommentTokens(sourceElement.getTokens())) {
            List<String> targetIds = SimulinkCoderCodeGenerationSourceFileMapper.extractTargetIds(comment.getText(), modelName, tracelinkAbbreviationIndex);
            if (targetIds.isEmpty()) continue;
            List targetLocations = CollectionUtils.mapWithException(targetIds, targetId -> SimulinkCoderCodeGenerationSourceFileMapper.resolveSimulinkElementLocation(targetId, baseLocation, modelInfoIndex));
            int startLine = comment.getLineNumber() + 1;
            int endLine = Integer.MAX_VALUE;
            Optional scopeEntity = ShallowEntityTraversalUtils.findEntityForLine((int)(comment.getLineNumber() + 1), entities);
            if (scopeEntity.isPresent()) {
                endLine = ((ShallowEntity)scopeEntity.get()).getEndLine();
                if (SimulinkCoderCodeGenerationSourceFileMapper.commentIsInFirstOrLastLineOfIfEntity(comment, (ShallowEntity)scopeEntity.get())) {
                    startLine = ((ShallowEntity)scopeEntity.get()).getStartLine();
                }
            }
            newBeacons.add(new SimulinkSourceFileMapper.TracingBeacon(startLine, endLine, targetLocations));
        }
        return newBeacons;
    }

    private static boolean commentIsInFirstOrLastLineOfIfEntity(IToken comment, ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.STATEMENT || !IF_SUBTYPES.contains(entity.getSubtype())) {
            return false;
        }
        if (entity.hasChildren()) {
            UnmodifiableList ownStartTokens = entity.ownStartTokens();
            return !ownStartTokens.isEmpty() && ((IToken)CollectionUtils.getLast((List)ownStartTokens)).getLineNumber() + 1 == comment.getLineNumber();
        }
        return comment.getLineNumber() + StringUtils.countLines((String)comment.getText()) == entity.getEndLine() - 1;
    }

    public static ElementLocation resolveSimulinkElementLocation(String targetElementId, ElementLocation baseLocation, SimulinkModelInfoIndex modelInfoIndex) throws StorageException {
        Optional<ElementLocation> resolvedLocation;
        Optional<QualifiedNameLocation> potentialLocation = SimulinkCoderCodeGenerationSourceFileMapper.resolveEmbeddedLibraryPath(targetElementId, modelInfoIndex.getModelNamesToPathMap());
        if (potentialLocation.isPresent() && (resolvedLocation = modelInfoIndex.resolve(potentialLocation.get())).isPresent()) {
            return resolvedLocation.get();
        }
        return baseLocation;
    }

    @VisibleForTesting
    static Optional<QualifiedNameLocation> resolveEmbeddedLibraryPath(String path, Map<String, String> validModelNamesToPaths) {
        Object[] pathElements = path.split(UniformPathUtils.SEPARATOR);
        int pathElementsLength = pathElements.length;
        for (int i = pathElementsLength - 1; i >= 0; --i) {
            if (pathElements[i].equals("$bdroot")) continue;
            String pathElement = StringUtils.stripPrefixIgnoreCase((String)pathElements[i], (String)"Lib_");
            for (String modelName : SimulinkModelInfoIndex.createAlternativeModelNames(pathElement)) {
                if (!validModelNamesToPaths.containsKey(modelName)) continue;
                String modelPath = validModelNamesToPaths.get(modelName);
                return Optional.of(new QualifiedNameLocation(SimulinkModelInfoIndex.makePath(modelName, (String[])ArrayUtils.subarray((Object[])pathElements, (int)(i + 1), (int)pathElementsLength)), modelPath));
            }
        }
        return Optional.empty();
    }

    private static List<String> extractTargetIds(String commentText, String modelName, TracelinkAbbreviationIndex tracelinkAbbreviationIndex) throws StorageException {
        ArrayList<String> resolvedLinks = new ArrayList<String>();
        Matcher matcher = SimulinkSourceFileMapper.CODE_LINK_PATTERN.matcher(commentText);
        while (matcher.find()) {
            Optional<String> codeLink = SimulinkCoderCodeGenerationSourceFileMapper.resolveCodeLink(matcher.group(1), modelName, tracelinkAbbreviationIndex);
            if (codeLink.isPresent()) {
                resolvedLinks.add(codeLink.get());
                continue;
            }
            LOGGER.warn("Encountered abbreviated path " + matcher.group(1) + " for model " + modelName + ", which can not be resolved using the abbreviation index.");
        }
        return resolvedLinks;
    }

    public static Optional<String> resolveCodeLink(String codeLink, String modelName, TracelinkAbbreviationIndex tracelinkAbbreviationIndex) throws StorageException {
        String firstPart = UniformPathUtils.extractProject((String)(codeLink = SimulinkCoderCodeGenerationSourceFileMapper.replaceColonsWithSlashes(codeLink)));
        if (!firstPart.startsWith("<")) {
            return Optional.of(codeLink);
        }
        String abbreviation = firstPart.substring(1, firstPart.length() - 1);
        return tracelinkAbbreviationIndex.replaceAbbreviation(codeLink, modelName, abbreviation);
    }

    @VisibleForTesting
    static String replaceColonsWithSlashes(String codeLink) {
        return codeLink.replace(':', '/');
    }
}

