/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.index.comment_analysis.utils.CommentUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SimulinkCoderGeneratorTracingUtils {
    private static final List<Pattern> MODEL_NAME_LINE_PATTERNS = Arrays.asList(Pattern.compile("Simulink model\\s*:\\s*(.+)"), Pattern.compile("Code generation for Simulink model ['\"](.+)['\"]"), Pattern.compile("Code generated for Simulink model ['\"](.+)['\"]"), Pattern.compile("Code generation for model ['\"](.+)['\"]"));
    private static final String GENERATED_FILE_ENDING = "_MemMap.h";

    public static Optional<String> extractModelName(TokenElementInfo codeElement) {
        if (codeElement.getUniformPath().endsWith(GENERATED_FILE_ENDING)) {
            String elementName = UniformPathUtils.getElementName((String)codeElement.getUniformPath());
            String modelName = StringUtils.stripSuffix((String)elementName, (String)GENERATED_FILE_ENDING);
            return Optional.of(modelName);
        }
        return SimulinkCoderGeneratorTracingUtils.getModelNameFromComments(codeElement.getTokens());
    }

    public static Optional<String> getModelNameFromComments(List<IToken> tokens) {
        for (IToken token : CommentUtils.getCommentTokens(tokens)) {
            for (Pattern pattern : MODEL_NAME_LINE_PATTERNS) {
                Matcher matcher = pattern.matcher(token.getText());
                if (!matcher.find()) continue;
                return Optional.of(matcher.group(1));
            }
        }
        return Optional.empty();
    }
}

