/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.structure.ShallowParsedMetricAnalyzerBase;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.util.TernaryOperatorCheckUtil;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CyclomaticComplexityAnalyzer
extends ShallowParsedMetricAnalyzerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> DECISION_STATEMENTS = CollectionUtils.asHashSet((Object[])new String[]{"if", "else if", "elif", "do", "while", "for", "switch", "switch expression"});

    @Override
    protected String getMetricName() {
        return "Cyclomatic Complexity";
    }

    @Override
    protected void calculateMetrics(TokenElementInfo element, List<ShallowEntity> entities) {
        for (ShallowEntity method : ShallowEntityTraversalUtils.listMethodsNonRecursive(entities)) {
            UnmodifiableList includedTokens = method.includedTokens();
            if (includedTokens.isEmpty()) continue;
            IToken firstToken = (IToken)includedTokens.get(0);
            IToken lastToken = (IToken)CollectionUtils.getLast((List)includedTokens);
            if (firstToken.getOffset() > lastToken.getEndOffset()) {
                LOGGER.warn("Skipping method with negative length (possibly caused by macro expansion) in " + element.getUniformPath() + ": " + method.getName());
                continue;
            }
            this.reportMetricValueForFilteredTokenRegion(CyclomaticComplexityAnalyzer.computeComplexityForMethod(method), firstToken, lastToken);
        }
    }

    public static int computeComplexityForMethod(ShallowEntity entity) {
        UnmodifiableList entities = entity.getChildren();
        if (!entities.isEmpty()) {
            return 1 + CyclomaticComplexityAnalyzer.computeComplexity((List<ShallowEntity>)entities);
        }
        return CyclomaticComplexityAnalyzer.computeComplexityForEmptyMethod(entity);
    }

    public static int computeComplexity(List<ShallowEntity> shallowEntities) {
        int complexity = 0;
        for (ShallowEntity entity : shallowEntities) {
            complexity += CyclomaticComplexityAnalyzer.computeComplexity(entity);
        }
        return complexity;
    }

    private static int computeComplexity(ShallowEntity entity) {
        String entitySubtype = entity.getSubtype();
        switch (entity.getType()) {
            case METHOD: {
                return CyclomaticComplexityAnalyzer.computeComplexity((List<ShallowEntity>)entity.getChildren());
            }
            case META: {
                if ("case".equals(entitySubtype)) {
                    return CyclomaticComplexityAnalyzer.computeComplexity((List<ShallowEntity>)entity.getChildren()) + 1;
                }
                return 0;
            }
            case STATEMENT: {
                int complexity = 0;
                if (entity.hasChildren()) {
                    complexity += CyclomaticComplexityAnalyzer.computeComplexity((List<ShallowEntity>)entity.getChildren());
                }
                if (DECISION_STATEMENTS.contains(entitySubtype)) {
                    ++complexity;
                }
                return complexity += TernaryOperatorCheckUtil.findOccurrences((ShallowEntity)entity).size();
            }
        }
        return 0;
    }

    private static int computeComplexityForEmptyMethod(ShallowEntity entity) {
        if (entity.getSubtype() != null && (entity.getSubtype().endsWith("declaration") || entity.getSubtype().contains("abstract"))) {
            return 0;
        }
        return 1;
    }
}

