/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.core.runtime.api.ProcessIdManager;
import com.teamscale.index.system_info.SystemInfoEntry;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public abstract class SystemInfoFragmentBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String processId = ProcessIdManager.getProcessId();
    private final Instant createdAt = DateTimeUtils.now();
    private final long updateIntervalMillis;

    SystemInfoFragmentBase(long updateIntervalMillis) {
        this.updateIntervalMillis = updateIntervalMillis;
    }

    public long getUpdateIntervalMillis() {
        return this.updateIntervalMillis;
    }

    public boolean isUpdatedAtLeastDaily() {
        return this.getUpdateIntervalMillis() < 86400000L;
    }

    public boolean isUpToDate(Instant timestamp) {
        if (!this.isUpdatedAtLeastDaily()) {
            return true;
        }
        return this.createdAt.plusMillis(2L * this.getUpdateIntervalMillis()).isAfter(timestamp);
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public abstract String getFragmentCaption();

    public int getFragmentOrder() {
        return 10;
    }

    public abstract List<SystemInfoEntry> convertToKeyValuePairs();

    public String getProcessId() {
        return this.processId;
    }

    @VisibleForTesting
    public void setProcessId(String processId) {
        this.processId = processId;
    }
}

