/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.teamscale.core.user.User;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.task.CodeSnippet;
import com.teamscale.index.task.ETaskResolution;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskDiff;
import com.teamscale.index.task.TaskNotificationUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;
import org.conqat.lib.commons.string.NumbersAwareStringComparator;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class TaskUtils {
    public static void documentChanges(TaskDiff taskDiff, User user, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        Task previousTask = taskDiff.getPreviousTask();
        Task updatedTask = taskDiff.getUpdatedTask();
        ArrayList<String> changes = new ArrayList<String>();
        TaskUtils.checkChange(previousTask.getAssignee(), updatedTask.getAssignee(), "Assignee", changes);
        TaskUtils.checkChange(TaskUtils.getReadableName(previousTask.getStatus()), TaskUtils.getReadableName(updatedTask.getStatus()), "Status", changes);
        TaskUtils.checkChange(TaskUtils.getReadableName(previousTask.getResolution()), TaskUtils.getReadableName(updatedTask.getResolution()), "Resolution", changes);
        TaskUtils.checkChange(previousTask.getSubject(), updatedTask.getSubject(), "Subject", changes);
        TaskUtils.checkChange(previousTask.getDescription(), updatedTask.getDescription(), "Description", changes, false);
        changes.addAll(TaskUtils.createFindingChanges(taskDiff, publicId, globalStorageSystem));
        changes.addAll(TaskUtils.createCodeSnippetChanges(previousTask.getCodeSnippets(), updatedTask.getCodeSnippets()));
        changes.addAll(TaskUtils.createTaskTagChanges(previousTask.getTags(), updatedTask.getTags()));
        TaskUtils.updateTask(updatedTask, changes, user, publicId, globalStorageSystem);
    }

    private static String getReadableName(ETaskResolution resolution) {
        if (resolution == null) {
            return "";
        }
        return resolution.getReadableName();
    }

    private static String getReadableName(ETaskStatus status) {
        if (status == null) {
            return "";
        }
        return status.getReadableName();
    }

    @VisibleForTesting
    static List<String> createCodeSnippetChanges(Collection<CodeSnippet> existingCodeSnippets, Collection<CodeSnippet> newCodeSnippets) {
        Set addedItems = CollectionUtils.subtract(newCodeSnippets, existingCodeSnippets);
        ArrayList<String> changes = new ArrayList<String>(TaskUtils.createStringCollectionChanges(addedItems.stream().map(CodeSnippet::getLocation).map(TextRegionLocation::toLocationString).collect(Collectors.toSet()), true, "code snippet"));
        Set removedItems = CollectionUtils.subtract(existingCodeSnippets, newCodeSnippets);
        changes.addAll(TaskUtils.createStringCollectionChanges(removedItems.stream().map(CodeSnippet::getLocation).map(TextRegionLocation::toLocationString).collect(Collectors.toSet()), false, "code snippet"));
        return changes;
    }

    private static List<String> createTaskTagChanges(Collection<String> existingTaskTags, Collection<String> newTaskTags) {
        Set addedItems = CollectionUtils.subtract(newTaskTags, existingTaskTags);
        ArrayList<String> changes = new ArrayList<String>(TaskUtils.createStringCollectionChanges(addedItems, true, "tag"));
        Set removedItems = CollectionUtils.subtract(existingTaskTags, newTaskTags);
        changes.addAll(TaskUtils.createStringCollectionChanges(removedItems, false, "tag"));
        return changes;
    }

    private static List<String> createStringCollectionChanges(Set<String> items, boolean added, String itemName) {
        ArrayList<String> changes = new ArrayList<String>();
        for (String item : items) {
            StringBuilder line = new StringBuilder();
            if (added) {
                line.append("Added ");
            } else {
                line.append("Removed ");
            }
            line.append(itemName).append(": ").append(item);
            changes.add(line.toString());
        }
        return changes;
    }

    private static List<String> createFindingChanges(TaskDiff taskDiff, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        ArrayList<String> changes = new ArrayList<String>(TaskUtils.createFindingChanges(taskDiff.getAddedTaskFindings(), true, publicId, globalStorageSystem));
        changes.addAll(TaskUtils.createFindingChanges(taskDiff.getRemovedTaskFindings(), false, publicId, globalStorageSystem));
        return changes;
    }

    private static List<String> createFindingChanges(Map<String, TrackedFinding> findingsMap, boolean added, PublicProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        ArrayList<String> changes = new ArrayList<String>();
        for (TrackedFinding finding : findingsMap.values()) {
            StringBuilder line = new StringBuilder();
            if (added) {
                line.append("Added ");
            } else {
                line.append("Removed ");
            }
            line.append("Finding ").append(TaskUtils.buildFindingsSummaryElement(finding, projectId, globalStorageSystem));
            changes.add(line.toString());
        }
        return changes;
    }

    public static void documentStatusChange(ETaskStatus newStatus, ETaskResolution newResolution, Task task, User user, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        ArrayList<String> changes = new ArrayList<String>();
        TaskUtils.checkChange(task.getStatus().getReadableName(), newStatus.getReadableName(), "Status", changes);
        TaskUtils.checkChange(task.getResolution().getReadableName(), newResolution.getReadableName(), "Resolution", changes);
        TaskUtils.updateTask(task, changes, user, publicId, globalStorageSystem);
    }

    private static void updateTask(Task task, List<String> changes, User user, PublicProjectId publicId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        if (!changes.isEmpty()) {
            long now = DateTimeUtils.millisNow();
            String currentUser = user.getUsername();
            task.addComment(currentUser, now, StringUtils.concat(changes, (String)"\n"), true);
            task.setUpdated(now);
            task.setUpdatedBy(currentUser);
            TaskNotificationUtils.sendChangeNotification(task, changes, user, publicId, globalStorageSystem);
        }
    }

    private static void checkChange(String previousValue, String value, String valueName, List<String> changes) {
        TaskUtils.checkChange(previousValue, value, valueName, changes, true);
    }

    private static void checkChange(String previousValue, String value, String valueName, List<String> changes, boolean addValueChanges) {
        if (!TaskUtils.isEqual(previousValue, value)) {
            if (previousValue == null) {
                previousValue = "";
            }
            if (value == null) {
                value = "";
            }
            if (addValueChanges) {
                changes.add(valueName + " changed from '" + previousValue + "' to '" + value + "'");
            } else {
                changes.add(valueName + " changed");
            }
        }
    }

    private static boolean isEqual(String previousValue, String value) {
        if (StringUtils.isEmpty((String)previousValue) && StringUtils.isEmpty((String)value)) {
            return true;
        }
        return Objects.equals(previousValue, value);
    }

    public static List<Task> filterTasksByStatus(List<Task> tasks, Set<ETaskStatus> statusSet) {
        return CollectionUtils.filter(tasks, task -> statusSet.contains((Object)task.getStatus()));
    }

    public static List<String> getAllTags(List<Task> tasks) {
        return tasks.stream().flatMap(task -> task.getTags().stream()).filter(Objects::nonNull).distinct().sorted((Comparator<String>)NumbersAwareStringComparator.INSTANCE).collect(Collectors.toList());
    }

    private static String buildFindingsSummaryElement(TrackedFinding finding, PublicProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        String link = FindingsServiceUtils.buildFindingURL(finding, (IProjectId)projectId, globalStorageSystem);
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        if (link != null) {
            writer.addClosedTextElement((Enum)EHTMLElement.A, "\"" + finding.getMessage() + "\"", new Object[]{EHTMLAttribute.HREF, link});
        } else {
            writer.addText("\"" + finding.getMessage() + "\"");
        }
        writer.addText(" in ");
        writer.addClosedTextElement((Enum)EHTMLElement.CODE, finding.getLocationString(), new Object[0]);
        writer.close();
        return stringWriter.toString();
    }
}

