/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testcoverage.CoverageAdjuster;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.AssociatedMethodTestInfo;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoContainer;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.TestGapEnablementChecker;
import com.teamscale.index.testgap.TestInfoProcessorParameters;
import com.teamscale.index.testgap.trend.NewlyCoveredMethodsIndex;
import com.teamscale.index.testgap.trend.TestCoverageDeltaIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class MethodLastTestedSynchronizer {
    private static final Logger LOGGER = LogManager.getLogger();
    private TestInfoProcessorParameters parameters;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestCoverageDeltaIndex deltaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExecutedMethodIndex executedMethodIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementLineInfoIndex tokenElementLineInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private LineCoverageIndex coverageIndex;
    @DeltaSource(value=LineCoverageIndex.class)
    private KeyDelta coverageDelta;
    private final Set<String> coveredPartitions = Collections.synchronizedSet(new HashSet());
    private final List<AssociatedMethodInfo> executedMethods = Collections.synchronizedList(new ArrayList());
    private final Map<MethodLastTestedIndex.AccessKey, CommitDescriptor> updatedTestInfoData = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<MethodLocation>> newlyCoveredMethodsAfterChangeByPartition = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<MethodLocation>> newlyCoveredMethodsByPartition = Collections.synchronizedMap(new HashMap());
    private CommitDescriptor schedulingCommit;
    private IProfilingMonitor profilingMonitor;

    public void process(CommitDescriptor schedulingCommit, TestInfoProcessorParameters parameters, IProfilingMonitor profilingMonitor, ExecuteInParallelBatchesFunction executeInParallelBatchesFunction) throws StorageException, ExecutionException {
        this.schedulingCommit = schedulingCommit;
        this.parameters = parameters;
        this.profilingMonitor = profilingMonitor;
        this.updateDeletedEntries();
        List changedCoverageInfoKeys = PartitionIndexBase.getPartitionAndPaths((Collection)this.coverageDelta.getAddedOrChangedKeysAsStrings());
        if (changedCoverageInfoKeys.isEmpty()) {
            return;
        }
        changedCoverageInfoKeys.sort(Comparator.comparing(PartitionAndPath::getUniformPath));
        profilingMonitor.startProfiling("processing batches");
        executeInParallelBatchesFunction.executeParallelBatches(changedCoverageInfoKeys, changedCoverageInfoKeysBatch -> this.processBatch(schedulingCommit, parameters, (List<PartitionAndPath>)changedCoverageInfoKeysBatch), 500);
        profilingMonitor.stopProfiling("processing batches");
        profilingMonitor.startProfiling("persisting results");
        this.persistResults();
        profilingMonitor.stopProfiling("persisting results");
    }

    private void processBatch(CommitDescriptor schedulingCommit, TestInfoProcessorParameters parameters, List<PartitionAndPath> changedCoverageInfoKeysBatch) throws StorageException {
        Map<PartitionAndPath, LineCoverageInfo> coverageInfosByPartitionAndPath = this.coverageIndex.getCoverageInfos(changedCoverageInfoKeysBatch);
        List relevantEntries = CollectionUtils.filter(coverageInfosByPartitionAndPath.entrySet(), entry -> ((LineCoverageInfo)entry.getValue()).getUploadCommitTimestamp() == schedulingCommit.getTimestamp());
        List uniformPaths = CollectionUtils.map((Collection)relevantEntries, entry -> ((PartitionAndPath)entry.getKey()).getUniformPath());
        Map<String, MethodInfoContainer> containers = parameters.getMethodInfoIndex().getMethodContainersWithoutCrossAnnotationInfoByUniformPath(uniformPaths);
        Map<String, TokenElementLineInfo> tokenElementLineInfos = this.tokenElementLineInfoIndex.getLineInfosByPaths(uniformPaths);
        List relevantPartitionsAndPaths = CollectionUtils.map((Collection)relevantEntries, Map.Entry::getKey);
        Map<Pair<String, MethodLocation>, CommitDescriptor> lastCoverageCommits = this.getLastCoverageCommits(relevantPartitionsAndPaths, containers);
        Set<String> testCodePaths = MethodLastTestedSynchronizer.getTestCodePathsInDelta(tokenElementLineInfos);
        Map<String, CommitDescriptor> partitionToLastUpdateMap = Collections.emptyMap();
        if (!parameters.getOldLastTestedIndexes().isEmpty()) {
            partitionToLastUpdateMap = parameters.getOldLastTestedIndexes().get(0).getPartitionToLastUploadMap();
        }
        TestGapEnablementChecker tgaEnablementChecker = new TestGapEnablementChecker(uniformPaths, parameters.getCodeScopesMappingIndex(), parameters.getTgaEnablementPerCodeScope());
        for (Map.Entry entry2 : relevantEntries) {
            String uniformPath = ((PartitionAndPath)entry2.getKey()).getUniformPath();
            MethodInfoContainer container = containers.get(uniformPath);
            TokenElementLineInfo tokenElementLineInfo = tokenElementLineInfos.get(uniformPath);
            if (container == null) continue;
            if (tokenElementLineInfo == null) {
                LOGGER.warn("The file '" + uniformPath + "' for which coverage was uploaded does not exist. Skipping.");
                continue;
            }
            this.processCoverageForFile(((PartitionAndPath)entry2.getKey()).getPartition(), uniformPath, container, (LineCoverageInfo)entry2.getValue(), tokenElementLineInfo, lastCoverageCommits, testCodePaths.contains(uniformPath), partitionToLastUpdateMap, tgaEnablementChecker.isTgaEnabled(uniformPath));
        }
    }

    private static Set<String> getTestCodePathsInDelta(Map<String, TokenElementLineInfo> tokenElementLineInfos) {
        HashSet<String> testCodePaths = new HashSet<String>();
        tokenElementLineInfos.forEach((uniformPath, tokenElementLineInfo) -> {
            if (tokenElementLineInfo.isTestCode()) {
                testCodePaths.add((String)uniformPath);
            }
        });
        return testCodePaths;
    }

    private void updateDeletedEntries() throws StorageException {
        this.profilingMonitor.startProfiling("updating deleted entries");
        List deletedKeys = PartitionIndexBase.getPartitionAndPaths((Collection)this.coverageDelta.getDeletedKeysAsStrings());
        if (deletedKeys.isEmpty()) {
            return;
        }
        deletedKeys.sort(Comparator.comparing(PartitionAndPath::getUniformPath));
        for (List deletedKeyBatch : Lists.partition((List)deletedKeys, (int)500)) {
            List uniformPaths = CollectionUtils.map((Collection)deletedKeyBatch, PartitionAndPath::getUniformPath);
            Map<String, MethodInfoContainer> containers = this.parameters.getMethodInfoIndex().getMethodContainersWithoutCrossAnnotationInfoByUniformPath(uniformPaths);
            Map<Pair<String, MethodLocation>, CommitDescriptor> lastCoverageCommits = this.getLastCoverageCommits(deletedKeyBatch, containers);
            PairList updatedEntries = new PairList();
            for (Map.Entry<Pair<String, MethodLocation>, CommitDescriptor> entry : lastCoverageCommits.entrySet()) {
                Pair<String, MethodLocation> key = entry.getKey();
                MethodLocation methodId = (MethodLocation)key.getSecond();
                updatedEntries.add((Object)new MethodLastTestedIndex.AccessKey((String)key.getFirst(), methodId.getUniformPath(), methodId.getRegion()), (Object)entry.getValue());
            }
            this.parameters.getNewLastTestedIndex().setLastTestedTimestamps((PairList<MethodLastTestedIndex.AccessKey, CommitDescriptor>)updatedEntries, 0L);
        }
        this.profilingMonitor.stopProfiling("updating deleted entries");
    }

    private Map<Pair<String, MethodLocation>, CommitDescriptor> getLastCoverageCommits(List<PartitionAndPath> relevantPartitionsAndPaths, Map<String, MethodInfoContainer> containers) throws StorageException {
        SetMap<String, MethodLocation> uniformPathsAndRegionsByPartition = MethodLastTestedSynchronizer.buildRelevantPathsAndRegionsListWithPartitions(relevantPartitionsAndPaths, containers);
        HashMap<Pair<String, MethodLocation>, CommitDescriptor> lastCoverageCommits = new HashMap<Pair<String, MethodLocation>, CommitDescriptor>();
        for (int i = 0; i < this.parameters.getOldLastTestedIndexes().size(); ++i) {
            MethodLastTestedIndex oldTestInfoIndex = this.parameters.getOldLastTestedIndexes().get(i);
            List<AssociatedMethodTestInfo> lastChangeTimestampsInIndex = oldTestInfoIndex.getTestInfosForMethodLocationsInPartitions(uniformPathsAndRegionsByPartition);
            for (AssociatedMethodTestInfo lastChange : lastChangeTimestampsInIndex) {
                Pair key = new Pair((Object)lastChange.getPartition(), (Object)lastChange.getLocation());
                lastCoverageCommits.merge((Pair<String, MethodLocation>)key, lastChange.getCommit(), CommitDescriptor::max);
            }
        }
        return lastCoverageCommits;
    }

    private static SetMap<String, MethodLocation> buildRelevantPathsAndRegionsListWithPartitions(List<PartitionAndPath> relevantPartitionsAndPaths, Map<String, MethodInfoContainer> containers) {
        SetMap uniformPathsAndRegions = new SetMap();
        for (PartitionAndPath relevantPartitionsAndPath : relevantPartitionsAndPaths) {
            String uniformPath = relevantPartitionsAndPath.getUniformPath();
            MethodInfoContainer container = containers.get(uniformPath);
            if (container == null) continue;
            for (Map.Entry<OffsetBasedRegion, MethodInfo> entry : container.entrySet()) {
                uniformPathsAndRegions.add((Object)relevantPartitionsAndPath.getPartition(), (Object)new MethodLocation(uniformPath, entry.getKey()));
            }
        }
        return uniformPathsAndRegions;
    }

    private void processCoverageForFile(String partition, String uniformPath, MethodInfoContainer container, LineCoverageInfo coverageInfo, TokenElementLineInfo tokenElementLineInfo, Map<Pair<String, MethodLocation>, CommitDescriptor> lastCoverageTimestamps, boolean pathIsTestCode, Map<String, CommitDescriptor> oldPartitionToLastUpdateMap, boolean isTgaEnabled) {
        boolean coveredAtLeastOneMethod = false;
        LineOffsetConverter rawLineOffsetConverter = tokenElementLineInfo.getRawLineOffsetConverter();
        CoverageAdjuster.correctLineCoverage(uniformPath, tokenElementLineInfo, coverageInfo, true);
        CompactLines coveredLines = coverageInfo.getCoveredLines();
        for (Map.Entry<OffsetBasedRegion, MethodInfo> entry : container.entrySet()) {
            OffsetBasedRegion region = entry.getKey();
            LineBasedRegion lineBasedRegion = MethodLastTestedSynchronizer.getUnfilteredLineRegion(rawLineOffsetConverter, (SimpleRegion)region);
            if (!coveredLines.containsAny(lineBasedRegion)) {
                Optional<CommitDescriptor> lastTestCommit = MethodLastTestedSynchronizer.getLastTestCommit(partition, uniformPath, lastCoverageTimestamps, region);
                lastTestCommit.ifPresent(commitDescriptor -> this.addUpdatedTestInfoData(partition, uniformPath, region, (CommitDescriptor)commitDescriptor));
                continue;
            }
            MethodInfo methodInfo = entry.getValue();
            this.executedMethods.add(new AssociatedMethodInfo(uniformPath, region, methodInfo));
            this.addUpdatedTestInfoData(partition, uniformPath, region, this.schedulingCommit);
            if (methodInfo.isRelevantForTgaTreemap(pathIsTestCode, isTgaEnabled)) {
                this.updateNewlyCoveredMethods(partition, uniformPath, lastCoverageTimestamps, entry, region, oldPartitionToLastUpdateMap);
            }
            coveredAtLeastOneMethod = true;
        }
        if (coveredAtLeastOneMethod) {
            this.coveredPartitions.add(partition);
        }
    }

    private static Optional<CommitDescriptor> getLastTestCommit(String partition, String uniformPath, Map<Pair<String, MethodLocation>, CommitDescriptor> lastCoverageTimestamps, OffsetBasedRegion region) {
        return Optional.ofNullable(lastCoverageTimestamps.get(new Pair((Object)partition, (Object)new MethodLocation(uniformPath, region))));
    }

    private void addUpdatedTestInfoData(String partition, String uniformPath, OffsetBasedRegion region, CommitDescriptor testCommit) {
        this.updatedTestInfoData.put(new MethodLastTestedIndex.AccessKey(partition, uniformPath, region), testCommit);
    }

    private void updateNewlyCoveredMethods(String partition, String uniformPath, Map<Pair<String, MethodLocation>, CommitDescriptor> lastCoverageTimestamps, Map.Entry<OffsetBasedRegion, MethodInfo> entry, OffsetBasedRegion region, Map<String, CommitDescriptor> oldPartitionToLastUpdateMap) {
        CommitDescriptor lastTest = lastCoverageTimestamps.get(new Pair((Object)partition, (Object)new MethodLocation(uniformPath, region)));
        if (oldPartitionToLastUpdateMap.get(partition) == null || lastTest == null || !oldPartitionToLastUpdateMap.get(partition).equals((Object)lastTest)) {
            this.newlyCoveredMethodsByPartition.computeIfAbsent(partition, p -> Collections.synchronizedList(new ArrayList())).add(new MethodLocation(uniformPath, region));
        }
        if (MethodLastTestedSynchronizer.isNewlyCoveredAfterChange(partition, uniformPath, region, entry.getValue(), lastCoverageTimestamps)) {
            this.newlyCoveredMethodsAfterChangeByPartition.computeIfAbsent(partition, p -> Collections.synchronizedList(new ArrayList())).add(new MethodLocation(uniformPath, region));
        }
    }

    private static LineBasedRegion getUnfilteredLineRegion(LineOffsetConverter rawLineOffsetConverter, SimpleRegion unfilteredRegion) {
        int lineStart = rawLineOffsetConverter.getLine(unfilteredRegion.getStart());
        int lineEnd = rawLineOffsetConverter.getLine(unfilteredRegion.getEnd());
        return new LineBasedRegion(lineStart, lineEnd);
    }

    private void persistResults() throws StorageException {
        if (!this.coveredPartitions.isEmpty()) {
            this.deltaIndex.addPartitionWithCoverage(this.schedulingCommit, this.coveredPartitions);
            this.parameters.getNewLastTestedIndex().addPartitions(this.coveredPartitions);
        }
        if (!this.executedMethods.isEmpty()) {
            this.executedMethodIndex.addExecutedMethods(this.schedulingCommit, this.executedMethods);
        }
        if (!this.updatedTestInfoData.isEmpty()) {
            this.parameters.getNewLastTestedIndex().setLastTestedTimestamps((PairList<MethodLastTestedIndex.AccessKey, CommitDescriptor>)PairList.fromMap(this.updatedTestInfoData), this.schedulingCommit.getTimestamp());
        }
        this.parameters.getNewlyCoveredMethodsIndex().storeMethodsAsNewlyCovered(this.schedulingCommit, this.newlyCoveredMethodsByPartition, NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED);
        this.parameters.getNewlyCoveredMethodsIndex().storeMethodsAsNewlyCovered(this.schedulingCommit, this.newlyCoveredMethodsAfterChangeByPartition, NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED_AFTER_CHANGE);
    }

    private static boolean isNewlyCoveredAfterChange(String partition, String uniformPath, OffsetBasedRegion region, MethodInfo methodInfo, Map<Pair<String, MethodLocation>, CommitDescriptor> lastCoverageTimestamps) {
        Optional<CommitDescriptor> lastTestCommit = MethodLastTestedSynchronizer.getLastTestCommit(partition, uniformPath, lastCoverageTimestamps, region);
        return lastTestCommit.isEmpty() || methodInfo.getLastChangedTimestamp() > lastTestCommit.get().getTimestamp();
    }
}

