/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.assessment;

import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class TgaAbapBwAggregator {
    public UnassessedTestGapData aggregateBwObjects(UnassessedTestGapData unaggregatedData) {
        Map<Boolean, List<UnassessedTestGapData.UnassessedMethodData>> partitionedData = unaggregatedData.getMethods().stream().collect(Collectors.partitioningBy(TgaAbapBwAggregator::hasBwPath));
        List<UnassessedTestGapData.UnassessedMethodData> abapBwData = partitionedData.get(true);
        List<UnassessedTestGapData.UnassessedMethodData> nonAbapBwData = partitionedData.get(false);
        List<UnassessedTestGapData.UnassessedMethodData> aggregatedBwInfos = TgaAbapBwAggregator.aggregateAll(abapBwData);
        UnassessedTestGapData aggregatedData = new UnassessedTestGapData();
        nonAbapBwData.forEach(aggregatedData::addMethod);
        aggregatedBwInfos.forEach(aggregatedData::addMethod);
        return aggregatedData;
    }

    private static List<UnassessedTestGapData.UnassessedMethodData> aggregateAll(List<UnassessedTestGapData.UnassessedMethodData> abapBwData) {
        Map<String, List<UnassessedTestGapData.UnassessedMethodData>> abapBwDataByUniformPath = abapBwData.stream().collect(Collectors.groupingBy(data -> data.getLocation().getUniformPath()));
        List aggregatedBwInfos = CollectionUtils.map(abapBwDataByUniformPath.entrySet(), entry -> TgaAbapBwAggregator.aggregateForOneFile((String)entry.getKey(), (List)entry.getValue()));
        return aggregatedBwInfos;
    }

    private static UnassessedTestGapData.UnassessedMethodData aggregateForOneFile(String uniformPath, List<UnassessedTestGapData.UnassessedMethodData> methods) {
        int aggregatedEndOffset = 0;
        long aggregatedLastTestTimestamp = -1L;
        long aggregatedLastChangeTimestamp = -1L;
        long aggregatedCreationTimestamp = Long.MAX_VALUE;
        boolean aggregatedIsExecutedByCrossAnnotation = false;
        for (UnassessedTestGapData.UnassessedMethodData method : methods) {
            aggregatedEndOffset = Math.max(method.getLocation().getRegion().getEnd(), aggregatedEndOffset);
            aggregatedLastTestTimestamp = Math.max(method.getLastTestTimestamp(), aggregatedLastTestTimestamp);
            aggregatedLastChangeTimestamp = Math.max(method.getLastChangeTimestamp(), aggregatedLastChangeTimestamp);
            aggregatedCreationTimestamp = Math.min(method.getCreationTimestamp(), aggregatedCreationTimestamp);
            aggregatedIsExecutedByCrossAnnotation = aggregatedIsExecutedByCrossAnnotation || method.isExecutedByCrossAnnotation();
        }
        OffsetBasedRegion aggregatedRegion = new OffsetBasedRegion(0, aggregatedEndOffset);
        return new UnassessedTestGapData.UnassessedMethodData(new MethodLocation(uniformPath, aggregatedRegion), aggregatedCreationTimestamp, aggregatedLastChangeTimestamp, aggregatedLastTestTimestamp, aggregatedIsExecutedByCrossAnnotation, uniformPath);
    }

    private static boolean hasBwPath(UnassessedTestGapData.UnassessedMethodData data) {
        return AbapUtils.isBwTransformedPath((String)data.getLocation().getUniformPath());
    }
}

