/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsUtils;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class CodeScopePathDataRetriever
implements ITgaDataRetriever {
    private final String uniformPath;
    private final List<String> partitions;
    private final TgaDataRetrieverIndexes dataRetrieverIndexes;
    private final CrossAnnotator crossAnnotator;
    private final TestInfoFilter testInfoFilter;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public CodeScopePathDataRetriever(String uniformPath, List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.uniformPath = uniformPath;
        this.partitions = partitions;
        this.crossAnnotator = crossAnnotator;
        this.dataRetrieverIndexes = dataRetrieverIndexes;
        this.testInfoFilter = testInfoFilter;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        Optional<CodeScopeName> codeScopeName = CodeScopesMetricsUtils.extractCodeScopeNameFromPath(this.uniformPath);
        if (codeScopeName.isPresent() && !((Boolean)this.tgaEnablementPerCodeScope.getValue(codeScopeName.get())).booleanValue()) {
            return new UnassessedTestGapData();
        }
        UnassessedTestGapData codeScopeUnawareData = this.fetchDataCodeScopeUnaware(methodInfoFilter);
        return this.filterAndConvertUniformPathsToCodeScopePaths(codeScopeUnawareData);
    }

    private UnassessedTestGapData fetchDataCodeScopeUnaware(MethodInfoFilter methodInfoFilter) throws StorageException {
        String codeScopeUnawarePath = CodeScopesMetricsUtils.removeCodeScopesPathPrefix(this.uniformPath);
        String pathPrefixWithSlash = ResourceServiceUtils.getUniformPathPrefixContainerAware(this.dataRetrieverIndexes.getContainerIndex(), codeScopeUnawarePath);
        List<AssociatedMethodInfo> methodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getMethodInfosForPathPrefix(pathPrefixWithSlash);
        return DataRetrieverUtils.createUnassessedTestGapData(methodInfos, this.partitions, this.crossAnnotator, this.dataRetrieverIndexes, methodInfoFilter, this.testInfoFilter, this.tgaEnablementPerCodeScope);
    }

    private UnassessedTestGapData filterAndConvertUniformPathsToCodeScopePaths(UnassessedTestGapData codeScopeUnawareData) throws StorageException {
        Map<UniformPath, CodeScopeName> codeScopeMappings = this.dataRetrieverIndexes.getCodeScopesMappingIndex().getAllMappings();
        Optional<CodeScopeName> originalCodeScopeName = CodeScopesMetricsUtils.extractCodeScopeNameFromPath(this.uniformPath);
        ArrayList<UnassessedTestGapData.UnassessedMethodData> filteredAndTranslatedMethods = new ArrayList<UnassessedTestGapData.UnassessedMethodData>();
        for (UnassessedTestGapData.UnassessedMethodData method : codeScopeUnawareData.getMethods()) {
            UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)method.getLocation().getUniformPath());
            CodeScopeName codeScopeOfMethod = codeScopeMappings.get(uniformPath);
            if (codeScopeOfMethod == null || originalCodeScopeName.isPresent() && !originalCodeScopeName.get().equals((Object)codeScopeOfMethod)) continue;
            filteredAndTranslatedMethods.add(method.withUniformPath(uniformPath.asCodeScopePath(codeScopeOfMethod).toStringAsMigrationFrontier()));
        }
        return new UnassessedTestGapData(filteredAndTranslatedMethods);
    }
}

