/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public class UniformPathDataRetriever
implements ITgaDataRetriever {
    private final String uniformPath;
    private final List<String> partitions;
    private final TgaDataRetrieverIndexes dataRetrieverIndexes;
    private final CrossAnnotator crossAnnotator;
    private final TestInfoFilter testInfoFilter;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public UniformPathDataRetriever(String uniformPath, List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.uniformPath = uniformPath;
        this.partitions = partitions;
        this.dataRetrieverIndexes = dataRetrieverIndexes;
        this.crossAnnotator = crossAnnotator;
        this.testInfoFilter = testInfoFilter;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        String pathPrefixWithSlash = ResourceServiceUtils.getUniformPathPrefixContainerAware(this.dataRetrieverIndexes.getContainerIndex(), this.uniformPath);
        List<AssociatedMethodInfo> methodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getMethodInfosForPathPrefix(pathPrefixWithSlash);
        return DataRetrieverUtils.createUnassessedTestGapData(methodInfos, this.partitions, this.crossAnnotator, this.dataRetrieverIndexes, methodInfoFilter, this.testInfoFilter, this.tgaEnablementPerCodeScope);
    }
}

