/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.trend;

import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.trend.ITgaTrendAdjuster;
import com.teamscale.index.testgap.trend.TgaTrendDataCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

class ArchitectureTgaTrendAdjuster
implements ITgaTrendAdjuster {
    private final Map<String, String> sourceToArchitecturePathMap;
    private final TgaTrendDataCache trendDataCache;

    public ArchitectureTgaTrendAdjuster(String architecturePath, MetricsToArchitectureMetricsMappingIndex architectureMappingIndex, TgaTrendDataCache cache) throws StorageException {
        this.trendDataCache = cache;
        this.sourceToArchitecturePathMap = ArchitectureMetricsUtils.getRecursivePathMappings(architectureMappingIndex, architecturePath);
    }

    @Override
    public void invalidateRemovedFiles() {
        this.trendDataCache.invalidateFiles(CollectionUtils.differenceSet(this.trendDataCache.getKnownUniformPaths(), (Collection[])new Collection[]{this.sourceToArchitecturePathMap.keySet()}));
    }

    @Override
    public Set<MethodLocation> filterTouchedMethodsThatNeedNoUpdate(Set<MethodLocation> methods) {
        return CollectionUtils.filterToSet(methods, method -> this.sourceToArchitecturePathMap.containsKey(method.getUniformPath()));
    }

    @Override
    public Set<String> adjustFilesThatNeedToBeRecalculated(Set<String> touchedFiles) {
        Stream<String> filteredFiles = this.filterTouchedPathsThatNeedNoUpdate(touchedFiles.stream());
        return Stream.concat(filteredFiles, this.pathsThatWereAddedToTheArchitecture()).collect(Collectors.toSet());
    }

    private Stream<String> pathsThatWereAddedToTheArchitecture() {
        return CollectionUtils.differenceSet(this.sourceToArchitecturePathMap.keySet(), (Collection[])new Collection[]{this.trendDataCache.getKnownUniformPaths()}).stream();
    }

    private Stream<String> filterTouchedPathsThatNeedNoUpdate(Stream<String> touchedPaths) {
        return touchedPaths.filter(this.sourceToArchitecturePathMap::containsKey);
    }
}

