/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.base.Preconditions;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdPool;
import com.teamscale.index.testimpact.MethodLocationOffsetMapping;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class MethodIdMap {
    private final Map<String, MethodLocationOffsetMapping> methodLocationOffsetMappings;

    public MethodIdMap(Map<String, MethodLocationOffsetMapping> methodLocationOffsetMappings) {
        this.methodLocationOffsetMappings = methodLocationOffsetMappings;
    }

    public MethodIdMap(MethodIdMap methodIdMap) {
        this.methodLocationOffsetMappings = methodIdMap.methodLocationOffsetMappings.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> new MethodLocationOffsetMapping((MethodLocationOffsetMapping)entry.getValue())));
    }

    public MethodLocation getMethodLocation(MethodId methodId) {
        MethodLocationOffsetMapping methodLocationOffsetMapping = this.methodLocationOffsetMappings.get(methodId.getUniformPath());
        if (methodLocationOffsetMapping == null) {
            return null;
        }
        OffsetBasedRegion region = methodLocationOffsetMapping.getLocation(methodId.getId());
        if (region == null) {
            return null;
        }
        return new MethodLocation(methodId.getUniformPath(), region);
    }

    public Iterable<? extends Map.Entry<String, MethodLocationOffsetMapping>> entrySet() {
        return this.methodLocationOffsetMappings.entrySet();
    }

    public Set<String> getUniformPaths() {
        return this.methodLocationOffsetMappings.keySet();
    }

    public MethodId getMethodId(MethodLocation method) {
        MethodLocationOffsetMapping methodLocationOffsetMapping = this.methodLocationOffsetMappings.get(method.getUniformPath());
        if (methodLocationOffsetMapping == null) {
            return null;
        }
        Integer id = methodLocationOffsetMapping.getId(method.getRegion());
        if (id == null) {
            return null;
        }
        return MethodIdPool.getOrCreate(method.getUniformPath(), id);
    }

    public MethodId getOrInsertMethodLocation(MethodLocation methodLocation) {
        int id = this.methodLocationOffsetMappings.computeIfAbsent(methodLocation.getUniformPath(), key -> new MethodLocationOffsetMapping()).getOrInsertRegion(methodLocation.getRegion());
        return MethodIdPool.getOrCreate(methodLocation.getUniformPath(), id);
    }

    public void changeRegion(MethodId parentMethodId, MethodLocation parentMethodLocation, MethodLocation childMethodLocation) {
        Preconditions.checkArgument((boolean)parentMethodLocation.getUniformPath().equals(childMethodLocation.getUniformPath()));
        if (parentMethodLocation.getRegion().equals((Object)childMethodLocation.getRegion())) {
            return;
        }
        this.methodLocationOffsetMappings.get(parentMethodLocation.getUniformPath()).changeRegion(parentMethodId.getId(), childMethodLocation.getRegion());
    }

    public void removeMethodId(MethodId methodId) {
        this.methodLocationOffsetMappings.get(methodId.getUniformPath()).removeId(methodId.getId());
    }

    public void insert(String uniformPath, MethodLocationOffsetMapping methodLocationOffsetMapping) {
        this.methodLocationOffsetMappings.put(uniformPath, methodLocationOffsetMapping);
    }

    public void insertAll(MethodIdMap allMappingsFor) {
        this.methodLocationOffsetMappings.putAll(allMappingsFor.methodLocationOffsetMappings);
    }
}

