/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public class TestExecutionWithPartition
implements Serializable {
    private static final int TEST_EXECUTION_SIZE_WITHOUT_TEST_LOCATIONS = 30;
    private static final int COMMIT_DESCRIPTOR_SIZE = 12;
    private static final byte ARTIFICIAL_EXECUTION_FLAG = 1;
    private static final byte MESSAGE_PRESENT_FLAG = 2;
    private static final byte HASH_PRESENT_FLAG = 4;
    private static final byte EXECUTION_UNIT_PRESENT_FLAG = 8;
    private static final byte EXTERNAL_LINK_PRESENT_FLAG = 16;
    private static final long serialVersionUID = 1L;
    private static final String TEST_EXECUTION_PROPERTY = "testExecution";
    private static final String PARTITION_PROPERTY = "partition";
    private static final String COMMIT_PROPERTY = "commit";
    private static final String PREDECESSOR_COMMITS_PROPERTY = "predecessorCommits";
    @JsonProperty(value="testExecution")
    private final TestExecution testExecution;
    @JsonProperty(value="partition")
    private final String partition;
    @JsonProperty(value="commit")
    private final CommitDescriptor commit;
    @JsonProperty(value="isArtificialMergeTestExecution")
    private final boolean artificialMergeTestExecution;
    @JsonProperty(value="predecessorCommits")
    private final List<CommitDescriptor> predecessorCommits = new ArrayList<CommitDescriptor>();

    @JsonCreator
    public TestExecutionWithPartition(@JsonProperty(value="testExecution") TestExecution testExecution, @JsonProperty(value="partition") String partition, @JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="predecessorCommits") Collection<CommitDescriptor> predecessorCommits) {
        this(testExecution, partition, commit, predecessorCommits, false);
    }

    @VisibleForTesting
    TestExecutionWithPartition(TestExecution testExecution, String partition, CommitDescriptor commit, Collection<CommitDescriptor> predecessorCommits, boolean artificialMergeTestExecution) {
        Preconditions.checkState((boolean)predecessorCommits.stream().allMatch(predecessorCommit -> predecessorCommit.compareTo(commit) < 0), (Object)("Predecessor commits " + String.valueOf(predecessorCommits) + " can't come after commit " + String.valueOf(commit)));
        this.testExecution = testExecution;
        this.partition = partition;
        this.commit = commit;
        this.artificialMergeTestExecution = artificialMergeTestExecution;
        predecessorCommits.stream().distinct().forEach(this.predecessorCommits::add);
        Collections.sort(this.predecessorCommits);
    }

    public TestExecution getTestExecution() {
        return this.testExecution;
    }

    public String getPartition() {
        return this.partition;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public List<CommitDescriptor> getPredecessorCommits() {
        return CollectionUtils.asUnmodifiable(this.predecessorCommits);
    }

    public PartitionAndPath getPartitionAndPath() {
        return new PartitionAndPath(this.partition, this.testExecution.getUniformPath());
    }

    public boolean isArtificialMergeTestExecution() {
        return this.artificialMergeTestExecution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestExecutionWithPartition that = (TestExecutionWithPartition)o;
        return this.artificialMergeTestExecution == that.artificialMergeTestExecution && Objects.equals(this.testExecution, that.testExecution) && Objects.equals(this.partition, that.partition) && Objects.equals(this.commit, that.commit) && Objects.equals(this.predecessorCommits, that.predecessorCommits);
    }

    public int hashCode() {
        return Objects.hash(this.testExecution, this.partition, this.commit, this.artificialMergeTestExecution, this.predecessorCommits);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static TestExecutionWithPartition merge(CommitDescriptor mergeCommit, Collection<TestExecutionWithPartition> testExecutionsWithPartition) {
        Preconditions.checkArgument((!testExecutionsWithPartition.isEmpty() ? 1 : 0) != 0, (Object)"Can't merge empty collection of test executions with partition.");
        if (testExecutionsWithPartition.size() == 1) {
            return testExecutionsWithPartition.iterator().next();
        }
        String uniquePartition = testExecutionsWithPartition.iterator().next().getPartition();
        HashMap latestTestExecutionsWithPartitionPerBranch = new HashMap();
        HashMap latestPredecessorCommitsPerBranch = new HashMap();
        testExecutionsWithPartition.forEach(testExecutionWithPartition -> TestExecutionWithPartition.handleTestExecutionWithPartition(testExecutionWithPartition, uniquePartition, latestTestExecutionsWithPartitionPerBranch, latestPredecessorCommitsPerBranch));
        if (latestTestExecutionsWithPartitionPerBranch.size() == 1) {
            return (TestExecutionWithPartition)latestTestExecutionsWithPartitionPerBranch.values().iterator().next();
        }
        List latestTestExecutions = CollectionUtils.map(latestTestExecutionsWithPartitionPerBranch.values(), TestExecutionWithPartition::getTestExecution);
        TestExecution mergedTestExecution = TestExecution.merge((Collection)latestTestExecutions);
        return new TestExecutionWithPartition(mergedTestExecution, uniquePartition, mergeCommit, latestPredecessorCommitsPerBranch.values(), true);
    }

    private static void handleTestExecutionWithPartition(TestExecutionWithPartition testExecutionWithPartition, String uniquePartition, Map<String, TestExecutionWithPartition> latestTestExecutionsWithPartitionPerBranch, Map<String, CommitDescriptor> latestPredecessorCommitsPerBranch) {
        String partition = testExecutionWithPartition.getPartition();
        CCSMAssert.isTrue((boolean)uniquePartition.equals(partition), () -> "Can't merge test executions from separate partitions: " + uniquePartition + "," + partition);
        String branch = testExecutionWithPartition.getCommit().getBranchName();
        if (!latestPredecessorCommitsPerBranch.containsKey(branch) || latestPredecessorCommitsPerBranch.get(branch).compareTo(testExecutionWithPartition.getCommit()) < 0) {
            latestPredecessorCommitsPerBranch.put(branch, testExecutionWithPartition.getCommit());
            latestTestExecutionsWithPartitionPerBranch.put(branch, testExecutionWithPartition);
        }
    }

    public byte[] serialize(StorageStringAbbreviator abbreviator) throws StorageException {
        int testLocationOffset = TestExecutionWithPartition.getTestLocationsOffset(this.testExecution);
        int associatedSpecItemsOffset = TestExecutionWithPartition.getAssociatedSpecItemsOffset(this.testExecution);
        byte[] data = new byte[43 + 12 * this.predecessorCommits.size() + testLocationOffset + associatedSpecItemsOffset];
        this.serializeTestExecution(abbreviator, data);
        int offset = 30 + testLocationOffset + associatedSpecItemsOffset;
        TestExecutionWithPartition.setBitFlag(data, offset, (byte)1, this.artificialMergeTestExecution);
        TestExecutionWithPartition.serializeCommitDescriptor(data, ++offset, abbreviator, this.commit);
        offset += 12;
        for (CommitDescriptor commit : this.predecessorCommits) {
            TestExecutionWithPartition.serializeCommitDescriptor(data, offset, abbreviator, commit);
            offset += 12;
        }
        return data;
    }

    private static void serializeCommitDescriptor(byte[] data, int offset, StorageStringAbbreviator abbreviator, CommitDescriptor commit) throws StorageException {
        ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)abbreviator.abbreviate(commit.getBranchName()));
        ByteArrayUtils.putLongIntoByteArray((byte[])data, (int)(offset + 4), (long)commit.getTimestamp());
    }

    public static TestExecutionWithPartition deserialize(byte[] data, StorageStringAbbreviator abbreviator, PartitionAndPath partitionAndPath) throws StorageException {
        if (data == null) {
            return null;
        }
        TestExecution testExecution = TestExecutionWithPartition.deserializeTestExecution(data, abbreviator, partitionAndPath.getUniformPath());
        int offset = 30 + TestExecutionWithPartition.getTestLocationsOffset(testExecution) + TestExecutionWithPartition.getAssociatedSpecItemsOffset(testExecution);
        boolean isArtificialMergeTestExecution = TestExecutionWithPartition.getBitFlag(data[offset], (byte)1);
        CommitDescriptor commit = TestExecutionWithPartition.deserializeCommitDescriptor(data, abbreviator, ++offset);
        offset += 12;
        ArrayList<CommitDescriptor> predecessorCommits = new ArrayList<CommitDescriptor>();
        while (offset < data.length) {
            predecessorCommits.add(TestExecutionWithPartition.deserializeCommitDescriptor(data, abbreviator, offset));
            offset += 12;
        }
        return new TestExecutionWithPartition(testExecution, partitionAndPath.getPartition(), commit, predecessorCommits, isArtificialMergeTestExecution);
    }

    private static @NonNull CommitDescriptor deserializeCommitDescriptor(byte[] data, StorageStringAbbreviator abbreviator, int offset) throws StorageException {
        String branch = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset));
        long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])data, (int)(offset + 4));
        return new CommitDescriptor(branch, timestamp);
    }

    private void serializeTestExecution(StorageStringAbbreviator abbreviator, byte[] data) throws StorageException {
        int offset = 0;
        boolean messagePresent = this.testExecution.getMessage().isPresent();
        boolean hashPresent = this.testExecution.getHash() != null;
        boolean externalLinkPresent = this.testExecution.getExternalLink() != null;
        boolean executionUnitPresent = this.testExecution.getExecutionUnit() != null;
        boolean testLocationsPresent = this.testExecution.getTestLocations() != null;
        boolean associatedSpecItemsPresent = this.testExecution.getAssociatedSpecItems() != null;
        TestExecutionWithPartition.setBitFlag(data, offset, (byte)2, messagePresent);
        TestExecutionWithPartition.setBitFlag(data, offset, (byte)4, hashPresent);
        TestExecutionWithPartition.setBitFlag(data, offset, (byte)16, externalLinkPresent);
        TestExecutionWithPartition.setBitFlag(data, offset, (byte)8, executionUnitPresent);
        ByteArrayUtils.putDoubleIntoByteArray((byte[])data, (int)(++offset), (double)this.testExecution.getDurationSeconds());
        data[offset += 8] = (byte)this.testExecution.getResult().ordinal();
        ++offset;
        if (messagePresent) {
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)abbreviator.abbreviate((String)this.testExecution.getMessage().get()));
        }
        offset += 4;
        if (hashPresent) {
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)abbreviator.abbreviate(this.testExecution.getHash()));
        }
        offset += 4;
        if (externalLinkPresent) {
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)abbreviator.abbreviate(this.testExecution.getExternalLink()));
        }
        offset += 4;
        if (executionUnitPresent) {
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)abbreviator.abbreviate(this.testExecution.getExecutionUnit()));
        }
        int numberTestLocations = TestExecutionWithPartition.getNumberOfTestLocations(this.testExecution);
        ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(offset += 4), (int)numberTestLocations);
        if (testLocationsPresent) {
            List abbreviations = abbreviator.abbreviate((SequencedCollection)this.testExecution.getTestLocations());
            for (Integer abbreviation : abbreviations) {
                ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(offset += 4), (int)abbreviation);
            }
        }
        int numberAssociatedSpecItems = TestExecutionWithPartition.getNumberOfAssociatedSpecItems(this.testExecution);
        ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(offset += 4), (int)numberAssociatedSpecItems);
        if (associatedSpecItemsPresent) {
            List abbreviations = abbreviator.abbreviate((SequencedCollection)this.testExecution.getAssociatedSpecItems());
            for (Integer abbreviation : abbreviations) {
                ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(offset += 4), (int)abbreviation);
            }
        }
    }

    private static @NonNull TestExecution deserializeTestExecution(byte[] data, StorageStringAbbreviator abbreviator, String uniformPath) throws StorageException {
        int offset = 0;
        boolean messagePresent = TestExecutionWithPartition.getBitFlag(data[offset], (byte)2);
        boolean hashPresent = TestExecutionWithPartition.getBitFlag(data[offset], (byte)4);
        boolean externalLinkPresent = TestExecutionWithPartition.getBitFlag(data[offset], (byte)16);
        boolean executionUnitPresent = TestExecutionWithPartition.getBitFlag(data[offset], (byte)8);
        double durationInSeconds = ByteArrayUtils.getDoubleFromByteArray((byte[])data, (int)(++offset));
        ETestExecutionResult result = ETestExecutionResult.values()[data[offset += 8]];
        String message = TestExecutionWithPartition.getStringIfPresent(messagePresent, abbreviator, data, ++offset);
        String hash = TestExecutionWithPartition.getStringIfPresent(hashPresent, abbreviator, data, offset += 4);
        String externalLink = TestExecutionWithPartition.getStringIfPresent(externalLinkPresent, abbreviator, data, offset += 4);
        String executionUnit = TestExecutionWithPartition.getStringIfPresent(executionUnitPresent, abbreviator, data, offset += 4);
        int numberOfTestLocations = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset += 4));
        ArrayList<String> testLocations = null;
        if (numberOfTestLocations > 0) {
            testLocations = new ArrayList<String>();
            for (int i = 0; i < numberOfTestLocations; ++i) {
                testLocations.add(abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset += 4))));
            }
        }
        int numberOfAssociatedSpecItems = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset += 4));
        ArrayList<String> associatedSpecItems = null;
        if (numberOfAssociatedSpecItems > 0) {
            associatedSpecItems = new ArrayList<String>();
            for (int i = 0; i < numberOfAssociatedSpecItems; ++i) {
                associatedSpecItems.add(abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset += 4))));
            }
        }
        return new TestExecution(uniformPath, testLocations, durationInSeconds, result, message, hash, externalLink, executionUnit, associatedSpecItems);
    }

    private static boolean getBitFlag(byte data, byte flag) {
        return (data & flag) == flag;
    }

    private static void setBitFlag(byte[] data, int offset, byte flag, boolean set) {
        if (set) {
            int n = offset;
            data[n] = (byte)(data[n] | flag);
        }
    }

    private static int getNumberOfTestLocations(TestExecution testExecution) {
        List testLocations = testExecution.getTestLocations();
        if (testLocations == null) {
            return 0;
        }
        return testLocations.size();
    }

    private static int getTestLocationsOffset(TestExecution testExecution) {
        return (TestExecutionWithPartition.getNumberOfTestLocations(testExecution) + 1) * 4;
    }

    private static int getNumberOfAssociatedSpecItems(TestExecution testExecution) {
        if (testExecution.getAssociatedSpecItems() == null) {
            return 0;
        }
        return testExecution.getAssociatedSpecItems().size();
    }

    private static int getAssociatedSpecItemsOffset(TestExecution testExecution) {
        return (TestExecutionWithPartition.getNumberOfAssociatedSpecItems(testExecution) + 1) * 4;
    }

    private static @Nullable String getStringIfPresent(boolean stringPresent, StorageStringAbbreviator abbreviator, byte[] data, int offset) throws StorageException {
        if (stringPresent) {
            return abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset));
        }
        return null;
    }
}

